/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.util.PausableThreadPoolExecutor;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallerBlocksPolicy
implements RejectedExecutionHandler {
    protected static final Logger logger = LoggerFactory.getLogger(CallerBlocksPolicy.class);
    private final long maxWait;

    public CallerBlocksPolicy(long maxWait) {
        this.maxWait = maxWait;
    }

    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        block5: {
            if (!executor.isShutdown()) {
                try {
                    BlockingQueue<Runnable> queue;
                    PausableThreadPoolExecutor ex = (PausableThreadPoolExecutor)executor;
                    if (ex.isPaused()) {
                        logger.debug("**** RESUME ****");
                        ex.resume();
                    }
                    if (!(queue = executor.getQueue()).offer(r, this.maxWait, TimeUnit.MILLISECONDS)) {
                        throw new RejectedExecutionException("Max wait time expired to queue task");
                    }
                    break block5;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RejectedExecutionException("Interrupted", e);
                }
            }
            throw new RejectedExecutionException("Executor has been shut down");
        }
    }
}

