/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.CRC32;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public final class CodecUtils {
    private static final String MD5_DIGEST = "MD5";
    private static final String SHA256_DIGEST = "SHA-256";
    private static final String ENCODING = "UTF-8";
    public static final int MD5_BYTE_SIZE = 16;
    private static ThreadLocal<byte[]> _16ByteBuffer = new ThreadLocal<byte[]>(){

        @Override
        public final byte[] initialValue() {
            return new byte[16];
        }
    };
    private static ThreadLocal<MessageDigest> sCache = new ThreadLocal<MessageDigest>(){

        @Override
        public final MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance(CodecUtils.MD5_DIGEST);
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }

        @Override
        public final MessageDigest get() {
            MessageDigest d = (MessageDigest)super.get();
            d.reset();
            return d;
        }
    };
    private static ThreadLocal<CRC32> _crc32Hasher = new ThreadLocal<CRC32>(){

        @Override
        public final CRC32 initialValue() {
            try {
                return new CRC32();
            }
            catch (Throwable t) {
                throw new IllegalStateException(t);
            }
        }

        @Override
        public final CRC32 get() {
            CRC32 d = (CRC32)super.get();
            d.reset();
            return d;
        }
    };

    public static String sha256Hex(String pV) {
        try {
            MessageDigest d = MessageDigest.getInstance(SHA256_DIGEST);
            d.reset();
            d.update(pV.getBytes(ENCODING));
            return Hex.encodeHexString((byte[])d.digest());
        }
        catch (Throwable t) {
            throw new IllegalStateException(t);
        }
    }

    public static String md5Hex(String pV) {
        try {
            return CodecUtils.md5Hex(pV.getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String md5Hex(byte[] pV) {
        return CodecUtils.md5Hex(pV, 0, pV.length);
    }

    public static String md5Hex(byte[] pV, int pOffset, int pLength) {
        MessageDigest d = sCache.get();
        d.update(pV, pOffset, pLength);
        return Hex.encodeHexString((byte[])d.digest());
    }

    public static byte[] md5(byte[] pV) {
        MessageDigest d = sCache.get();
        d.update(pV);
        return d.digest();
    }

    public static byte[] sha1(byte[] pV) throws NoSuchAlgorithmException {
        return MessageDigest.getInstance("SHA-1").digest(pV);
    }

    public static long crc32(String pV) {
        CRC32 hasher = _crc32Hasher.get();
        try {
            hasher.update(pV.getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
        return hasher.getValue();
    }

    public static String toHex(byte[] pV) {
        try {
            return Hex.encodeHexString((byte[])pV);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String md5ToHex(byte[] pV) {
        try {
            if (pV.length == 16) {
                return Hex.encodeHexString((byte[])pV);
            }
            byte[] buffer = _16ByteBuffer.get();
            System.arraycopy(pV, 0, buffer, 0, 16);
            return Hex.encodeHexString((byte[])buffer);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toHex(String pV) {
        try {
            return Hex.encodeHexString((byte[])pV.getBytes(ENCODING));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static byte[] fromHex(String pV) {
        try {
            return Hex.decodeHex((char[])pV.toCharArray());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toBase64(byte[] pV) {
        return Base64.encodeBase64String((byte[])pV);
    }

    public static String toBase64UrlSafe(byte[] pV) {
        return Base64.encodeBase64URLSafeString((byte[])pV);
    }

    public static byte[] fromBase64(String pV) {
        return Base64.decodeBase64((String)pV);
    }

    public static String toBase32(byte[] pV) {
        return new Base32().encodeAsString(pV);
    }

    public static byte[] fromBase32(String pV) {
        return new Base32().decode(pV);
    }
}

