/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.util.ConnStormRunnable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.bson.Document;
import org.bson.conversions.Bson;

public class ConnStorm {
    private String mongoUriStr;
    private int threads;
    private List<ConnStormRunnable> runners;
    private Boolean storm = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        ConnectionString connectionString = new ConnectionString(this.mongoUriStr);
        MongoClientSettings mongoClientSettings = MongoClientSettings.builder().applyConnectionString(connectionString).build();
        MongoClient mongoClient = MongoClients.create((MongoClientSettings)mongoClientSettings);
        mongoClient.getDatabase("admin").runCommand((Bson)new Document("ping", (Object)1));
        this.runners = new ArrayList<ConnStormRunnable>(this.threads);
        int i = 0;
        while (i < this.threads) {
            ConnStormRunnable runnable = new ConnStormRunnable(connectionString, this);
            runnable.start();
            this.runners.add(runnable);
            ++i;
        }
        mongoClient.close();
        while (true) {
            System.out.println("Storm");
            this.storm = true;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ConnStorm connStorm = this;
            synchronized (connStorm) {
                this.notifyAll();
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected static CommandLine initializeAndParseCommandLineOptions(String[] args) {
        Options options = new Options();
        options.addOption(new Option("help", "print this message"));
        OptionBuilder.withArgName((String)"target mongo uri");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"host");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withArgName((String)"# threads");
        OptionBuilder.hasArgs();
        OptionBuilder.withLongOpt((String)"threads");
        options.addOption(OptionBuilder.create((String)"t"));
        GnuParser parser = new GnuParser();
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
            if (line.hasOption("help")) {
                ConnStorm.printHelpAndExit(options);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            ConnStorm.printHelpAndExit(options);
        }
        catch (Exception e) {
            e.printStackTrace();
            ConnStorm.printHelpAndExit(options);
        }
        return line;
    }

    private static void printHelpAndExit(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("replayUtil", options);
        System.exit(-1);
    }

    protected void parseArgs(String[] args) {
        CommandLine line = ConnStorm.initializeAndParseCommandLineOptions(args);
        this.mongoUriStr = line.getOptionValue("h");
        String threadsStr = line.getOptionValue("t");
        if (threadsStr != null) {
            this.threads = Integer.parseInt(threadsStr);
        }
    }

    public static void main(String[] args) throws Exception {
        ConnStorm stormy = new ConnStorm();
        stormy.parseArgs(args);
        stormy.execute();
    }
}

