/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.google.common.collect.Sets;
import com.mongodb.util.CodecUtils;
import java.util.Set;
import java.util.TreeSet;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffUtils {
    private static Logger logger = LoggerFactory.getLogger(DiffUtils.class);

    public static boolean compareHashes(byte[] sourceBytes, byte[] destBytes) {
        String sourceHash = CodecUtils.md5Hex(sourceBytes);
        String destHash = CodecUtils.md5Hex(destBytes);
        return sourceHash.equals(destHash);
    }

    public static boolean compareDocuments(String ns, RawBsonDocument sourceDoc, RawBsonDocument destDoc) {
        BsonValue id = sourceDoc.get((Object)"_id");
        Set sourceKeys = sourceDoc.keySet();
        Set destKeys = destDoc.keySet();
        TreeSet sortedKeys = new TreeSet();
        boolean setsEqual = sourceKeys.equals(destKeys);
        Sets.SetView diff = null;
        if (!setsEqual) {
            diff = Sets.difference((Set)sourceKeys, (Set)destKeys);
            logger.debug("    - keys do not match: keys missing from source" + diff);
            diff = Sets.difference((Set)destKeys, (Set)sourceKeys);
            logger.debug("    - keys do not match: keys missing from dest" + diff);
            sortedKeys.addAll(diff);
        }
        sortedKeys.addAll(sourceKeys);
        BsonDocument sourceDocNew = new BsonDocument();
        BsonDocument destDocNew = new BsonDocument();
        for (String key : sortedKeys) {
            boolean valuesEqual;
            BsonValue sourceVal = sourceDoc.get((Object)key);
            BsonValue destVal = destDoc.get((Object)key);
            boolean bl = valuesEqual = sourceVal != null && destVal != null && sourceVal.equals(destVal);
            if (!valuesEqual) {
                logger.debug(String.format("    - values not equal for key: %s, sourceVal: %s, destVal: %s", key, sourceVal, destVal));
            }
            if (sourceVal != null) {
                sourceDocNew.append(key, sourceVal);
            }
            if (destVal != null) {
                destDocNew.append(key, destVal);
            }
            if (!setsEqual) continue;
            RawBsonDocument sourceRawNew = new RawBsonDocument((Object)sourceDocNew, (Codec)new BsonDocumentCodec());
            RawBsonDocument destRawNew = new RawBsonDocument((Object)destDocNew, (Codec)new BsonDocumentCodec());
            boolean newDocsMatch = DiffUtils.compareHashes(sourceRawNew.getByteBuffer().array(), destRawNew.getByteBuffer().array());
            logger.debug(String.format("%s - bytes match: %s", ns, newDocsMatch));
        }
        return sourceDoc.equals((Object)destDoc);
    }
}

