/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    private static Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private CloseableHttpClient httpClient = HttpClients.custom().build();
    private Gson gson = new GsonBuilder().create();

    public String doGetAsString(String url) throws ClientProtocolException, IOException {
        HttpGet httpGet = new HttpGet(url);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
        int responseCode = response.getStatusLine().getStatusCode();
        if (responseCode != 200) {
            throw new IllegalStateException(String.format("Unexecpected http response status code %s", responseCode));
        }
        String responseStr = EntityUtils.toString((HttpEntity)response.getEntity());
        return responseStr;
    }

    public <T> T doGetAsObject(String url, Class<T> classOfT) throws IOException {
        String json = this.doGetAsString(url);
        try {
            return (T)this.gson.fromJson(json, classOfT);
        }
        catch (JsonSyntaxException jse) {
            logger.error("Error unmarshalling json", (Throwable)jse);
            return null;
        }
    }
}

