/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PausableThreadPoolExecutor
extends ThreadPoolExecutor {
    protected static final Logger logger = LoggerFactory.getLogger(PausableThreadPoolExecutor.class);
    private boolean isPaused;
    private ReentrantLock lock = new ReentrantLock();
    private Condition condition = this.lock.newCondition();

    public PausableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
    }

    public PausableThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, handler);
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        super.beforeExecute(thread, runnable);
        this.lock.lock();
        try {
            try {
                while (this.isPaused) {
                    this.condition.await();
                }
            }
            catch (InterruptedException ie) {
                thread.interrupt();
                this.lock.unlock();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRunning() {
        return !this.isPaused;
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public void pause() {
        this.lock.lock();
        try {
            this.isPaused = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void resume() {
        this.lock.lock();
        try {
            this.isPaused = false;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

