/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.util.Identifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShapeUtil {
    protected static final Logger logger = LoggerFactory.getLogger(ShapeUtil.class);
    private String dbName;
    private static final Set<String> EXPRESSION_OPERATORS = ShapeUtil.asSet("$and", "$or", "$nor");
    private static final Set<String> ALL_OPERATORS = ShapeUtil.asSet("$and", "$or", "$nor", "$in", "$gt", "$lt", "$eq", "$ne", "$nin", "$exists", "$gte", "find", "sort", "distinct", "aggregate");

    @SafeVarargs
    public static <T> Set<T> asSet(T ... elements) {
        return new HashSet<T>(Arrays.asList(elements));
    }

    private static boolean isExpressionOperator(String pKey) {
        return EXPRESSION_OPERATORS.contains(pKey.trim().toLowerCase());
    }

    private static boolean isOperator(String pKey) {
        return pKey.startsWith("$") || pKey.equals("find");
    }

    public static Set<String> getShape(Document predicateDoc) {
        if (predicateDoc == null) {
            return null;
        }
        TreeSet<String> predicates = new TreeSet<String>();
        ShapeUtil.predicateDocToShapeRecursive(predicateDoc, predicates);
        return predicates;
    }

    public static Document predicateDocToShapeRecursive(Document pPredicateDoc, Set<String> predicates) {
        Document shapePredicate = new Document();
        for (Map.Entry entry : pPredicateDoc.entrySet()) {
            Object shapeValue;
            String key = (String)entry.getKey();
            Object valueObj = entry.getValue();
            if (ShapeUtil.isExpressionOperator(key)) {
                if (valueObj instanceof List) {
                    shapeValue = ShapeUtil.expressionListToShapeValueRecursive(key, (List)valueObj, predicates);
                } else {
                    logger.warn("Unexpected value type {} for key {}; collapsing to 1", (Object)valueObj.getClass().getSimpleName(), (Object)key);
                    shapeValue = 1;
                }
            } else {
                shapeValue = Identifier.isDocWithNestedOperators(valueObj) ? ShapeUtil.predicateDocToShapeRecursive((Document)valueObj, predicates) : Integer.valueOf(1);
            }
            if (!ShapeUtil.isOperator(key)) {
                predicates.add(key);
            }
            shapePredicate.append(key, shapeValue);
        }
        return ShapeUtil.sortPredicateDoc(shapePredicate);
    }

    private static Document sortPredicateDoc(Document pPredicateDoc) {
        return pPredicateDoc.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(ShapeUtil.toBasicBSONObject());
    }

    private static List<Document> expressionListToShapeValueRecursive(String key, List<Document> pExpressionList, Set<String> predicates) {
        ArrayList<Document> shapeList = new ArrayList<Document>();
        for (Document elemObj : pExpressionList) {
            if (elemObj instanceof Document) {
                Document doc = elemObj;
                Document shapeDoc = ShapeUtil.predicateDocToShapeRecursive(doc, predicates);
                shapeList.add(shapeDoc);
                continue;
            }
            logger.warn("Unexpected expression element type {} in expression list for key {}; ignoring", (Object)elemObj.getClass().getSimpleName(), (Object)key);
        }
        return shapeList;
    }

    public static Collector<Map.Entry<String, Object>, Document, Document> toBasicBSONObject() {
        return new BasicBSONObjectCollector();
    }

    public static class BasicBSONObjectCollector
    implements Collector<Map.Entry<String, Object>, Document, Document> {
        @Override
        public Supplier<Document> supplier() {
            return Document::new;
        }

        @Override
        public BiConsumer<Document, Map.Entry<String, Object>> accumulator() {
            return (bsonObj, entry) -> {
                Document document = bsonObj.append((String)entry.getKey(), entry.getValue());
            };
        }

        @Override
        public BinaryOperator<Document> combiner() {
            return (left, right) -> {
                left.putAll((Map)right);
                return left;
            };
        }

        @Override
        public Function<Document, Document> finisher() {
            return Function.identity();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
        }
    }
}

