/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

public class TimedEvent {
    private long bytes = 0L;
    private long duration = -1L;
    private long start = System.nanoTime();
    private long count = 0L;
    private long errorCount = 0L;

    public long getBytes() {
        return this.bytes;
    }

    public long stop() {
        return this.stop(this.bytes < 0L ? 0L : this.bytes, false);
    }

    public long stop(long _bytes) {
        return this.stop(_bytes, false);
    }

    public void stop(boolean _error) {
        this.stop(-1L, _error);
    }

    public long stop(long _bytes, boolean _error) {
        if (this.duration > -1L) {
            return this.duration;
        }
        this.duration = System.nanoTime() - this.start;
        assert (this.duration > 0L);
        if (_bytes > -1L) {
            this.bytes = _bytes;
        }
        return this.duration;
    }

    public long getDuration() {
        if (this.duration < 0L) {
            return System.nanoTime() - this.start;
        }
        return this.duration;
    }

    public boolean isError() {
        return this.errorCount > 0L;
    }

    public long getStart() {
        return this.start;
    }

    public void increment(long _bytes) {
        this.bytes += _bytes;
    }

    public void incrementCount() {
        ++this.count;
    }

    public void incrementCount(long i) {
        this.count += i;
    }

    public void incrementError(long i) {
        this.errorCount += i;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getErrorCount() {
        return this.errorCount;
    }
}

