/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import com.mongodb.util.TimedEvent;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class Timer {
    public static final int BYTES_PER_KILOBYTE = 1024;
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int NANOSECONDS_PER_MICROSECOND = 1000;
    public static final int MICROSECONDS_PER_MILLISECOND = 1000;
    public static final int NANOSECONDS_PER_MILLISECOND = 1000000;
    public static final int NANOSECONDS_PER_SECOND = 1000000000;
    private volatile AtomicInteger errors;
    private long duration = -1L;
    private volatile ArrayList<TimedEvent> events = new ArrayList();
    private long start = System.nanoTime();
    private volatile AtomicInteger eventCount = new AtomicInteger(0);

    public Timer() {
        this.errors = new AtomicInteger(0);
    }

    public AtomicInteger getEventCount() {
        return this.eventCount;
    }

    public long getErrorCount() {
        return this.errors.get();
    }

    public long getDuration() {
        if (this.duration < 0L) {
            return System.nanoTime() - this.start;
        }
        return this.duration;
    }

    public long getStart() {
        return this.start;
    }

    public double getEventsPerSecond() {
        return (double)this.eventCount.get() / this.getDurationSeconds();
    }

    public long stop() {
        return this.stop(System.nanoTime());
    }

    public synchronized long stop(long l) {
        if (this.duration < 0L) {
            this.duration = l - this.start;
        }
        return this.duration;
    }

    public void incrementEventCount() {
        this.eventCount.incrementAndGet();
    }

    public void incrementErrorCount() {
        this.errors.incrementAndGet();
    }

    public double getDurationMilliseconds() {
        return (double)this.getDuration() / 1000000.0;
    }

    public double getDurationSeconds() {
        return (double)this.getDuration() / 1.0E9;
    }

    public String getProgressMessage() {
        return String.valueOf(Math.round(this.getEventsPerSecond())) + " tps";
    }
}

