/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util.bson;

import java.util.Comparator;
import org.bson.BsonDocument;
import org.bson.BsonType;
import org.bson.BsonValue;

public class BsonValueComparator
implements Comparator<BsonValue> {
    @Override
    public int compare(BsonValue x, BsonValue y) {
        BsonType xType = x.getBsonType();
        BsonType yType = y.getBsonType();
        boolean xIsComparable = x instanceof Comparable;
        boolean yIsComparable = y instanceof Comparable;
        if (xType.equals((Object)yType)) {
            if (xIsComparable) {
                return ((Comparable)x).compareTo((Comparable)y);
            }
            switch (xType) {
                case DOCUMENT: {
                    this.compareDocs((BsonDocument)x, (BsonDocument)y);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("not implemented");
                }
            }
        }
        return 0;
    }

    public int compareDocs(BsonDocument x, BsonDocument y) {
        String s1 = x.toJson();
        String s2 = y.toJson();
        return s1.compareTo(s2);
    }
}

