/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import java.util.Map;

public class Core {
    private static ApiProvider apiProvider;

    public static void init(ApiProvider apiProvider) {
        Core.apiProvider = apiProvider;
    }

    private static void verifyInit() {
        if (apiProvider == null) {
            throw new ExceptionInInitializerError("com.Helpshift.Core.init() method not called");
        }
    }

    public static void setNameAndEmail(String name, String email) {
        Core.verifyInit();
        apiProvider._setNameAndEmail(name, email);
    }

    public static void install(Application application, String apiKey, String domain, String appId) {
        Core.verifyInit();
        apiProvider._install(application, apiKey, domain, appId);
    }

    public static void install(Application application, String apiKey, String domain, String appId, Map config) {
        Core.verifyInit();
        apiProvider._install(application, apiKey, domain, appId, config);
    }

    public static void registerDeviceToken(Context context, String deviceToken) {
        Core.verifyInit();
        apiProvider._registerDeviceToken(context, deviceToken);
    }

    public static void handlePush(Context context, Intent intent) {
        Core.verifyInit();
        apiProvider._handlePush(context, intent);
    }

    public static void handlePush(Context context, Bundle data) {
        Core.verifyInit();
        apiProvider._handlePush(context, data);
    }

    public static void login(String userId, String name, String email) {
        Core.verifyInit();
        apiProvider._login(userId, name, email);
    }

    public static void logout() {
        Core.verifyInit();
        apiProvider._logout();
    }

    public static interface ApiProvider {
        public void _install(Application var1, String var2, String var3, String var4);

        public void _install(Application var1, String var2, String var3, String var4, Map var5);

        public void _setNameAndEmail(String var1, String var2);

        public void _registerDeviceToken(Context var1, String var2);

        public void _handlePush(Context var1, Intent var2);

        public void _handlePush(Context var1, Bundle var2);

        public void _login(String var1, String var2, String var3);

        public void _logout();
    }
}

