/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.app;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.helpshift.app.LifecycleListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;

@TargetApi(value=14)
public class MainLifecycleCallback
implements Application.ActivityLifecycleCallbacks {
    public static final int FOREGROUND = 1;
    public static final int BACKGROUND = 2;
    private final LinkedBlockingDeque<LifecycleListener> lifecycleListeners = new LinkedBlockingDeque();
    private final ExecutorService cachedExecutorService = Executors.newCachedThreadPool();
    private int start;
    private int stop;
    private static boolean foreground;
    private static boolean isConfigurationChanged;

    private void dispatchLifecycleEvent(final int lifecycleEvent) {
        this.cachedExecutorService.execute(new Runnable(){

            @Override
            public void run() {
                for (LifecycleListener listener : MainLifecycleCallback.this.lifecycleListeners) {
                    switch (lifecycleEvent) {
                        case 1: {
                            listener.onForeground();
                            break;
                        }
                        case 2: {
                            listener.onBackground();
                            break;
                        }
                    }
                }
            }
        });
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycleListeners.addFirst(listener);
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
    }

    public void onActivityStarted(Activity activity) {
        if (!isConfigurationChanged) {
            if (!foreground) {
                this.dispatchLifecycleEvent(1);
                foreground = true;
            }
            ++this.start;
        }
        isConfigurationChanged = false;
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        if (activity != null && activity.isChangingConfigurations()) {
            isConfigurationChanged = true;
        } else {
            isConfigurationChanged = false;
            ++this.stop;
            if (this.start == this.stop) {
                this.dispatchLifecycleEvent(2);
                foreground = false;
            }
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public static boolean isForeground() {
        return foreground;
    }

    static {
        isConfigurationChanged = false;
    }
}

