/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.location.Location;
import android.os.Bundle;
import android.support.annotation.NonNull;
import com.helpshift.Core;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.models.PropertyValue;
import com.helpshift.campaigns.network.NetworkManagerFactory;
import com.helpshift.campaigns.storage.StorageFactory;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.util.HelpshiftContext;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Campaigns
implements Core.ApiProvider {
    private Campaigns() {
    }

    public static Campaigns getInstance() {
        return LazyHolder.INSTANCE;
    }

    public static boolean addProperty(@NonNull String key, @NonNull String value) {
        return ControllerFactory.getInstance().userController.addProperty(key, new PropertyValue(value));
    }

    public static boolean addProperty(@NonNull String key, @NonNull Integer value) {
        return ControllerFactory.getInstance().userController.addProperty(key, new PropertyValue(value));
    }

    public static boolean addProperty(@NonNull String key, @NonNull Boolean value) {
        return ControllerFactory.getInstance().userController.addProperty(key, new PropertyValue(value));
    }

    public static boolean addProperty(@NonNull String key, @NonNull Date value) {
        return ControllerFactory.getInstance().userController.addProperty(key, new PropertyValue(value));
    }

    public static String[] addProperties(@NonNull Map<String, Object> keyValues) {
        HashMap<String, PropertyValue> properties = new HashMap<String, PropertyValue>();
        for (Map.Entry<String, Object> entry : keyValues.entrySet()) {
            if (entry.getValue() instanceof Location) continue;
            PropertyValue value = new PropertyValue(entry.getValue());
            properties.put(entry.getKey(), value);
        }
        return ControllerFactory.getInstance().userController.addProperties(properties);
    }

    @Override
    public void _install(@NonNull Application application, @NonNull String apiKey, @NonNull String domain, @NonNull String appId, @NonNull Map config) {
        Object sdkType;
        Object notificationIconResourceId;
        HelpshiftContext.setApplicationContext((Context)application);
        com.helpshift.storage.StorageFactory hsStorageFactory = com.helpshift.storage.StorageFactory.getInstance();
        StorageFactory campaignsStorageFactory = StorageFactory.getInstance();
        InfoModelFactory infoModelFactory = InfoModelFactory.getInstance();
        com.helpshift.controllers.ControllerFactory controllerFactory = com.helpshift.controllers.ControllerFactory.getInstance();
        ControllerFactory campaignsControllerFactory = ControllerFactory.getInstance();
        NetworkManagerFactory networkManagerFactory = NetworkManagerFactory.getInstance();
        InfoModelFactory.getInstance().appInfoModel.install(apiKey, domain, appId);
        Object notificationSoundResourceId = config.get("notificationSound");
        if (notificationSoundResourceId != null && notificationSoundResourceId instanceof Integer) {
            InfoModelFactory.getInstance().appInfoModel.setNotificationSoundId((Integer)config.get("notificationSound"));
        }
        if ((notificationIconResourceId = config.get("notificationIcon")) != null && notificationIconResourceId instanceof Integer) {
            InfoModelFactory.getInstance().appInfoModel.setNotificationIconId((Integer)config.get("notificationIcon"));
        }
        if ((sdkType = config.get("sdkType")) != null && sdkType instanceof String) {
            campaignsControllerFactory.deviceController.setDevelopmentPlatform((String)sdkType);
        } else {
            campaignsControllerFactory.deviceController.setDevelopmentPlatform("android");
        }
    }

    @Override
    public void _install(@NonNull Application application, @NonNull String apiKey, @NonNull String domain, @NonNull String appId) {
        this._install(application, apiKey, domain, appId, new HashMap());
    }

    @Override
    public void _setNameAndEmail(String name, String email) {
        ControllerFactory.getInstance().userController.setNameAndEmail(name, email);
    }

    @Override
    public void _registerDeviceToken(@NonNull Context context, @NonNull String deviceToken) {
        ControllerFactory.getInstance().deviceController.setPushToken(deviceToken);
    }

    @Override
    public void _handlePush(Context context, Intent intent) {
    }

    @Override
    public void _handlePush(Context context, Bundle data) {
    }

    @Override
    public void _login(@NonNull String userId, String name, String email) {
        ControllerFactory.getInstance().userController.login(userId, name, email);
    }

    @Override
    public void _logout() {
        ControllerFactory.getInstance().userController.logout();
    }

    private static class LazyHolder {
        private static final Campaigns INSTANCE = new Campaigns();

        private LazyHolder() {
        }
    }
}

