/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.controllers;

import com.helpshift.app.LifecycleListener;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.models.AnalyticsEvent;
import com.helpshift.controllers.SyncController;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.request.Request;
import com.helpshift.network.response.JsonArrayResponseParser;
import com.helpshift.network.response.Response;
import com.helpshift.specifications.DecayingIntervalSyncSpecification;
import com.helpshift.specifications.SyncSpecification;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.concurrent.DispatchQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.json.JSONArray;

public class AnalyticsEventController
implements NetworkDataProvider,
LifecycleListener {
    private KeyValueStorage storage;
    private DispatchQueue workerQueue;
    private SyncController syncController;
    private SyncSpecification syncSpecification;

    protected AnalyticsEventController(KeyValueStorage storage, DispatchQueue queue, SyncController syncController, SyncSpecification syncSpecification) {
        this.storage = storage;
        this.workerQueue = queue;
        this.syncController = syncController;
        this.syncSpecification = syncSpecification;
        HelpshiftContext.getMainLifecycleCallback().addLifecycleListener(this);
    }

    public SyncController getSyncController() {
        return this.syncController;
    }

    public DispatchQueue getWorkerQueue() {
        return this.workerQueue;
    }

    public KeyValueStorage getStorage() {
        return this.storage;
    }

    public void recordAnalyticsEvent(Integer type, String campaignId) {
        AnalyticsEvent analyticsEvent = new AnalyticsEvent(type, campaignId);
        this.addEventToStorage(analyticsEvent);
    }

    private void addEventToStorage(final AnalyticsEvent newEvent) {
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                ArrayList<AnalyticsEvent> events = (ArrayList<AnalyticsEvent>)AnalyticsEventController.this.storage.get("kAnalyticsEvents");
                if (events == null) {
                    events = new ArrayList<AnalyticsEvent>();
                }
                events.add(newEvent);
                AnalyticsEventController.this.storage.set("kAnalyticsEvents", events);
            }
        });
    }

    private void removeAnalyticsEventsFromStorage(final String[] eventIds) {
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                ArrayList events = (ArrayList)AnalyticsEventController.this.storage.get("kAnalyticsEvents");
                AnalyticsEventController.this.storage.removeKey("kAnalyticsEvents");
                ArrayList<String> eventIdsList = new ArrayList<String>(Arrays.asList(eventIds));
                ArrayList<AnalyticsEvent> newEvents = new ArrayList<AnalyticsEvent>();
                for (AnalyticsEvent event : events) {
                    if (eventIdsList.contains(event.getEventId())) continue;
                    newEvents.add(event);
                }
                if (newEvents.size() > 0) {
                    AnalyticsEventController.this.storage.set("kAnalyticsEvents", newEvents);
                }
            }
        });
    }

    ArrayList<AnalyticsEvent> getAnalyticsEventsFromStorage() {
        return (ArrayList)this.storage.get("kAnalyticsEvents");
    }

    @Override
    public Request getRequest() {
        Request newRequest = null;
        ArrayList<AnalyticsEvent> events = this.getAnalyticsEventsFromStorage();
        if (events != null && events.size() > 0) {
            final AnalyticsEventController controller = this;
            ArrayList<HashMap> eventsToSend = new ArrayList<HashMap>();
            ArrayList<String> eventIds = new ArrayList<String>();
            for (AnalyticsEvent event : events) {
                HashMap eventData = event.toData();
                eventsToSend.add(eventData);
                eventIds.add(event.getEventId());
            }
            JSONArray eventsJson = HSJSONUtils.fromListOfMaps(eventsToSend);
            HashMap<String, String> apiData = new HashMap<String, String>();
            apiData.put("e", eventsJson.toString());
            apiData.put("sv", "4.2.0");
            apiData.put("v", "1.0.1");
            HashMap<String, Object> deviceInfo = ControllerFactory.getInstance().deviceController.getDeviceInfoForPushAnalytics();
            for (String key : deviceInfo.keySet()) {
                apiData.put(key, deviceInfo.get(key).toString());
            }
            final String[] eventIdsArray = eventIds.toArray(new String[eventIds.size()]);
            Response.Listener<JSONArray> successListener = new Response.Listener<JSONArray>(){

                @Override
                public void onResponse(JSONArray response, Integer requestId) {
                    controller.workerQueue.dispatchAsync(new Runnable(){

                        @Override
                        public void run() {
                            controller.removeAnalyticsEventsFromStorage(eventIdsArray);
                            controller.syncController.dataSynced("data_type_analytics_event");
                        }
                    });
                }
            };
            Response.ErrorListener errorListener = new Response.ErrorListener(){

                @Override
                public void onErrorResponse(NetworkError error, Integer requestId) {
                    ((DecayingIntervalSyncSpecification)controller.syncSpecification).decayElapsedTimeThreshold();
                }
            };
            newRequest = new Request(1, "/ma/ae/", apiData, successListener, errorListener, new JsonArrayResponseParser());
        }
        return newRequest;
    }

    @Override
    public void setBatchSize(Integer batchSize) {
    }

    @Override
    public void onForeground() {
    }

    @Override
    public void onBackground() {
        ArrayList<AnalyticsEvent> events = this.getAnalyticsEventsFromStorage();
        if (events != null && events.size() > 0) {
            this.syncController.setDataChangeCount("data_type_analytics_event", this.getAnalyticsEventsFromStorage().size());
        }
    }
}

