/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.controllers;

import android.annotation.TargetApi;
import com.helpshift.campaigns.controllers.AnalyticsEventController;
import com.helpshift.campaigns.controllers.DeviceController;
import com.helpshift.campaigns.controllers.SessionController;
import com.helpshift.campaigns.controllers.SwitchUserController;
import com.helpshift.campaigns.controllers.UserController;
import com.helpshift.campaigns.models.AndroidDevice;
import com.helpshift.campaigns.models.DeviceModel;
import com.helpshift.campaigns.storage.PropertyStorage;
import com.helpshift.campaigns.storage.StorageFactory;
import com.helpshift.controllers.DataSyncCoordinator;
import com.helpshift.controllers.SyncController;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.model.SdkInfoModel;
import com.helpshift.network.util.constants.NetworkConstants;
import com.helpshift.specifications.DailyFrequencyBasedSyncSpecification;
import com.helpshift.specifications.DecayingIntervalSyncSpecification;
import com.helpshift.specifications.GenericSyncSpecification;
import com.helpshift.specifications.SyncSpecification;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.concurrent.DispatchQueue;
import java.util.concurrent.TimeUnit;

public class ControllerFactory {
    public final DeviceController deviceController;
    public final SessionController sessionController;
    public final SwitchUserController switchUserController;
    public final UserController userController;
    public final AnalyticsEventController analyticsEventController;

    @TargetApi(value=9)
    private ControllerFactory() {
        KeyValueStorage keyValueStorage = com.helpshift.storage.StorageFactory.getInstance().keyValueStorage;
        DataSyncCoordinator dataSyncCoordinator = com.helpshift.controllers.ControllerFactory.getInstance().dataSyncCoordinator;
        SyncController syncController = com.helpshift.controllers.ControllerFactory.getInstance().syncController;
        PropertyStorage propertyStorage = StorageFactory.getInstance().propertyStorage;
        SyncSpecification syncSpecification = dataSyncCoordinator.isFirstDeviceSyncComplete() ? new DailyFrequencyBasedSyncSpecification(4, "data_type_device") : new DecayingIntervalSyncSpecification(5, TimeUnit.SECONDS, "data_type_device");
        syncController.addSpecification(syncSpecification);
        this.deviceController = new DeviceController(dataSyncCoordinator, syncController, new DeviceModel(new AndroidDevice(), StorageFactory.getInstance().propertyStorage, new DispatchQueue(false)), syncSpecification);
        syncSpecification = new DecayingIntervalSyncSpecification(5, TimeUnit.SECONDS, "data_type_switch_user");
        syncController.addSpecification(syncSpecification);
        this.switchUserController = new SwitchUserController(dataSyncCoordinator, syncController, keyValueStorage, syncSpecification);
        syncSpecification = new DecayingIntervalSyncSpecification(5, TimeUnit.SECONDS, "data_type_analytics_event");
        syncController.addSpecification(syncSpecification);
        this.analyticsEventController = new AnalyticsEventController(keyValueStorage, new DispatchQueue(false), syncController, syncSpecification);
        syncSpecification = new GenericSyncSpecification(5, 24L, TimeUnit.HOURS, "data_type_session");
        syncController.addSpecification(syncSpecification);
        this.sessionController = new SessionController(syncController, new DispatchQueue(false), StorageFactory.getInstance().sessionStorage, NetworkConstants.DEFAULT_REQUEST_MAX_SIZE);
        syncSpecification = new GenericSyncSpecification(2, 24L, TimeUnit.HOURS, "data_type_user");
        syncController.addSpecification(syncSpecification);
        SdkInfoModel sdkInfoModel = InfoModelFactory.getInstance().sdkInfoModel;
        this.userController = new UserController(syncController, this.sessionController, this.switchUserController, new DispatchQueue(false), propertyStorage, NetworkConstants.DEFAULT_REQUEST_MAX_SIZE, sdkInfoModel);
    }

    public static ControllerFactory getInstance() {
        return LazyHolder.INSTANCE;
    }

    private static class LazyHolder {
        private static final ControllerFactory INSTANCE = new ControllerFactory();

        private LazyHolder() {
        }
    }
}

