/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.controllers;

import com.helpshift.app.LifecycleListener;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.models.DeviceModel;
import com.helpshift.campaigns.network.NetworkManagerFactory;
import com.helpshift.campaigns.util.constants.DeviceProperties;
import com.helpshift.campaigns.util.constants.SyncStatus;
import com.helpshift.controllers.DataSyncCoordinator;
import com.helpshift.controllers.SyncController;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.request.Request;
import com.helpshift.network.response.JsonArrayResponseParser;
import com.helpshift.network.response.Response;
import com.helpshift.specifications.DailyFrequencyBasedSyncSpecification;
import com.helpshift.specifications.DecayingIntervalSyncSpecification;
import com.helpshift.specifications.SyncSpecification;
import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HelpshiftContext;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class DeviceController
implements NetworkDataProvider,
LifecycleListener {
    private SyncController syncController;
    private DeviceModel deviceModel;
    private DataSyncCoordinator dataSyncCoordinator;
    private SyncSpecification syncSpecification;

    protected DeviceController(DataSyncCoordinator dataSyncCoordinator, SyncController syncController, DeviceModel deviceModel, SyncSpecification syncSpecification) {
        this.dataSyncCoordinator = dataSyncCoordinator;
        this.deviceModel = deviceModel;
        this.syncController = syncController;
        this.syncSpecification = syncSpecification;
        HelpshiftContext.getMainLifecycleCallback().addLifecycleListener(this);
        HashMap<String, ArrayList> syncingProperties = this.deviceModel.getSyncingPropertiesUnsafe();
        ArrayList<String> syncingList = new ArrayList<String>();
        syncingList.addAll(syncingProperties.keySet());
        this.deviceModel.setSyncStatus(SyncStatus.UNSYNCED, syncingList);
    }

    public SyncController getSyncController() {
        return this.syncController;
    }

    public DeviceModel getDeviceModel() {
        return this.deviceModel;
    }

    @Override
    public Request getRequest() {
        final DeviceController deviceController = this;
        HashMap<String, ArrayList> unSyncedProperties = this.deviceModel.getUnsyncedProperties();
        if (unSyncedProperties.size() > 0) {
            JSONObject propertiesJson = HSJSONUtils.fromNestedMap(unSyncedProperties);
            HashMap<String, String> apiData = new HashMap<String, String>();
            apiData.put("did", this.deviceModel.getIdentifier());
            final String uid = ControllerFactory.getInstance().userController.getCurrentUser().getIdentifier();
            apiData.put("uid", uid);
            apiData.put("p", propertiesJson.toString());
            final ArrayList<String> unSyncedList = new ArrayList<String>();
            unSyncedList.addAll(unSyncedProperties.keySet());
            this.deviceModel.setSyncStatus(SyncStatus.SYNCING, unSyncedList);
            Response.Listener<JSONArray> successListener = new Response.Listener<JSONArray>(){

                @Override
                public void onResponse(JSONArray response, Integer requestId) {
                    deviceController.syncController.dataSynced("data_type_device");
                    deviceController.deviceModel.setSyncStatus(SyncStatus.SYNCED, unSyncedList);
                    if (!deviceController.dataSyncCoordinator.isFirstDeviceSyncComplete()) {
                        deviceController.dataSyncCoordinator.firstDeviceSyncComplete();
                        ControllerFactory.getInstance().switchUserController.doneSwitch(uid);
                        deviceController.syncSpecification = new DailyFrequencyBasedSyncSpecification(4, "data_type_device");
                        deviceController.syncController.addSpecification(DeviceController.this.syncSpecification);
                        deviceController.syncController.addSyncListeners(NetworkManagerFactory.getInstance().devicePropertiesNetworkManager);
                    }
                }
            };
            Response.ErrorListener errorListener = new Response.ErrorListener(){

                @Override
                public void onErrorResponse(NetworkError error, Integer requestId) {
                    deviceController.deviceModel.setSyncStatus(SyncStatus.UNSYNCED, unSyncedList);
                    if (!deviceController.dataSyncCoordinator.isFirstDeviceSyncComplete() && deviceController.syncSpecification instanceof DecayingIntervalSyncSpecification) {
                        ((DecayingIntervalSyncSpecification)deviceController.syncSpecification).decayElapsedTimeThreshold();
                    }
                }
            };
            return new Request(1, "/ma/dp/", apiData, successListener, errorListener, new JsonArrayResponseParser());
        }
        return null;
    }

    public HashMap<String, Object> getDeviceInfoForPushAnalytics() {
        Object appVersion;
        Object dm;
        Object osVersion;
        String did;
        Object language;
        Object countryCode;
        HashMap<String, Object> deviceInfo = new HashMap<String, Object>();
        Object platform = this.deviceModel.getPropertyValue(DeviceProperties.DeviceKeys.PLATFORM);
        if (platform != null) {
            deviceInfo.put("p", platform);
        }
        if ((countryCode = this.deviceModel.getPropertyValue(DeviceProperties.DeviceKeys.COUNTRY)) != null) {
            deviceInfo.put("cc", countryCode);
        }
        if ((language = this.deviceModel.getPropertyValue(DeviceProperties.DeviceKeys.LANGUAGE)) != null) {
            deviceInfo.put("ln", language);
        }
        if ((did = this.deviceModel.getIdentifier()) != null) {
            deviceInfo.put("did", did);
        }
        if ((osVersion = this.deviceModel.getPropertyValue(DeviceProperties.DeviceKeys.OS)) != null) {
            deviceInfo.put("osv", osVersion);
        }
        if ((dm = this.deviceModel.getPropertyValue(DeviceProperties.DeviceKeys.MODEL)) != null) {
            deviceInfo.put("dm", dm);
        }
        if ((appVersion = this.deviceModel.getPropertyValue(DeviceProperties.DeviceKeys.APP_VERSION)) != null) {
            deviceInfo.put("av", appVersion);
        }
        return deviceInfo;
    }

    @Override
    public void setBatchSize(Integer batchSize) {
    }

    public void setPushToken(String pushToken) {
        this.deviceModel.setPushToken(pushToken);
    }

    public void setDevelopmentPlatform(String developmentPlatform) {
        this.deviceModel.setDevelopmentPlatform(developmentPlatform);
    }

    @Override
    public void onForeground() {
        this.deviceModel.rescanDevice();
    }

    @Override
    public void onBackground() {
        HashMap<String, ArrayList> unSynced = this.deviceModel.getUnsyncedProperties();
        if (unSynced.size() > 0) {
            this.syncController.setDataChangeCount("data_type_device", unSynced.size());
        }
    }
}

