/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.controllers;

import android.util.Log;
import com.helpshift.app.LifecycleListener;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.models.SessionModel;
import com.helpshift.campaigns.storage.SessionStorage;
import com.helpshift.campaigns.util.constants.SyncStatus;
import com.helpshift.controllers.SyncController;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.request.Request;
import com.helpshift.network.response.JsonArrayResponseParser;
import com.helpshift.network.response.Response;
import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.concurrent.DispatchQueue;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;

public class SessionController
implements NetworkDataProvider,
LifecycleListener {
    private static final String TAG = "HelpshiftDebug";
    private SyncController syncController;
    private SessionModel currentSession;
    private DispatchQueue workerQueue;
    private SessionStorage storage;
    private Integer batchSize;

    protected SessionController(SyncController syncController, DispatchQueue queue, SessionStorage sessionStorage, Integer batchSize) {
        this.workerQueue = queue;
        this.storage = sessionStorage;
        this.batchSize = batchSize;
        this.syncController = syncController;
        HelpshiftContext.getMainLifecycleCallback().addLifecycleListener(this);
        this.storage.cleanUpInvalidSessions();
        ArrayList<SessionModel> syncingSessions = this.storage.getAllSessions(SyncStatus.SYNCING);
        if (syncingSessions != null) {
            int numOfSessions = syncingSessions.size();
            String[] sessionIds = new String[numOfSessions];
            for (int i = 0; i < numOfSessions; ++i) {
                sessionIds[i] = syncingSessions.get(i).getIdentifier();
            }
            this.storage.setSyncStatus(SyncStatus.UNSYNCED, sessionIds);
        }
    }

    public SyncController getSyncController() {
        return this.syncController;
    }

    @Override
    public void setBatchSize(Integer newBatchSize) {
        this.batchSize = newBatchSize;
    }

    public SessionStorage getStorage() {
        return this.storage;
    }

    public DispatchQueue getWorkerQueue() {
        return this.workerQueue;
    }

    public boolean isSessionActive() {
        return this.currentSession != null;
    }

    public void startSession() {
        final SessionController controller = this;
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                controller.currentSession = new SessionModel();
                controller.storeSession();
            }
        });
    }

    public void endSession() {
        final SessionController controller = this;
        this.workerQueue.dispatchSync(new Runnable(){

            @Override
            public void run() {
                if (controller.currentSession != null) {
                    controller.currentSession.endNow();
                    controller.updateSession();
                    controller.currentSession = null;
                    controller.syncController.incrementDataChangeCount("data_type_session", 1);
                }
            }
        });
    }

    public void updateDurations() {
        final SessionController controller = this;
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                controller.currentSession.updateDurations();
                controller.updateSession();
            }
        });
    }

    public void storeSession() {
        this.storage.storeSession(this.currentSession);
    }

    public void updateSession() {
        this.storage.updateSession(this.currentSession);
    }

    public SessionModel getCurrentSession() {
        this.workerQueue.join();
        return this.currentSession;
    }

    private List<SessionModel> batchEvents(ArrayList<SessionModel> inputEvents, Integer batchSize) {
        List<SessionModel> batchedEvents = new ArrayList<SessionModel>();
        if (inputEvents != null) {
            batchedEvents = inputEvents;
            ArrayList<ArrayList<HashMap>> sessionData = new ArrayList<ArrayList<HashMap>>();
            Integer batchSizeInBytes = batchSize * 1024 * 1024;
            for (SessionModel sessionModel : inputEvents) {
                sessionData.add(sessionModel.toData());
            }
            try {
                JSONArray sessionJson = new JSONArray(sessionData);
                int length = sessionJson.toString().getBytes("UTF-8").length;
                if (length > batchSizeInBytes) {
                    Integer averageSize = length / sessionData.size();
                    Integer newCount = batchSizeInBytes / averageSize;
                    batchedEvents = inputEvents.subList(0, newCount);
                }
            }
            catch (UnsupportedEncodingException e) {
                Log.d((String)TAG, (String)"Unsupported exception in batching events : ", (Throwable)e);
            }
        }
        return batchedEvents;
    }

    @Override
    public Request getRequest() {
        Request newRequest = null;
        final SessionController controller = this;
        List<SessionModel> unsentSessions = controller.batchEvents(controller.storage.getAllSessions(SyncStatus.UNSYNCED), controller.batchSize);
        if (unsentSessions.size() > 0) {
            ArrayList<HashMap> events = new ArrayList<HashMap>();
            ArrayList<String> sessionIds = new ArrayList<String>();
            String uid = ControllerFactory.getInstance().userController.getCurrentUser().getIdentifier();
            String did = ControllerFactory.getInstance().deviceController.getDeviceModel().getIdentifier();
            for (SessionModel session : unsentSessions) {
                if (!session.getUserIdentifier().equals(uid) || !session.getDeviceIdentifier().equals(did)) continue;
                events.addAll(session.toData());
                sessionIds.add(session.getIdentifier());
            }
            JSONArray eventsJson = HSJSONUtils.fromListOfMaps(events);
            HashMap<String, String> apiData = new HashMap<String, String>();
            apiData.put("did", did);
            apiData.put("uid", uid);
            apiData.put("e", eventsJson.toString());
            final String[] sessions = sessionIds.toArray(new String[sessionIds.size()]);
            controller.storage.setSyncStatus(SyncStatus.SYNCING, sessions);
            Response.Listener<JSONArray> successListener = new Response.Listener<JSONArray>(){

                @Override
                public void onResponse(JSONArray response, Integer requestId) {
                    controller.workerQueue.dispatchAsync(new Runnable(){

                        @Override
                        public void run() {
                            controller.storage.removeSessions(sessions);
                            controller.syncController.dataSynced("data_type_session");
                        }
                    });
                }
            };
            Response.ErrorListener errorListener = new Response.ErrorListener(){

                @Override
                public void onErrorResponse(NetworkError error, Integer requestId) {
                    controller.storage.setSyncStatus(SyncStatus.UNSYNCED, sessions);
                }
            };
            newRequest = new Request(1, "/ma/session/", apiData, successListener, errorListener, new JsonArrayResponseParser());
        }
        return newRequest;
    }

    @Override
    public void onForeground() {
        this.startSession();
    }

    @Override
    public void onBackground() {
        this.endSession();
    }
}

