/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.controllers;

import android.text.TextUtils;
import android.util.Log;
import com.helpshift.campaigns.controllers.SessionController;
import com.helpshift.campaigns.controllers.SwitchUserController;
import com.helpshift.campaigns.models.PropertyValue;
import com.helpshift.campaigns.models.UserModel;
import com.helpshift.campaigns.storage.PropertyStorage;
import com.helpshift.campaigns.util.constants.SyncStatus;
import com.helpshift.controllers.SyncController;
import com.helpshift.model.SdkInfoModel;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.request.Request;
import com.helpshift.network.response.JsonArrayResponseParser;
import com.helpshift.network.response.Response;
import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HSPattern;
import com.helpshift.util.SchemaUtil;
import com.helpshift.util.concurrent.DispatchQueue;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class UserController
implements NetworkDataProvider {
    private static final String TAG = "HelpshiftDebug";
    private SyncController syncController;
    private SessionController sessionController;
    private SwitchUserController switchUserController;
    private UserModel currentUser;
    private DispatchQueue workerQueue;
    private PropertyStorage storage;
    private Integer batchSize;
    private SdkInfoModel sdkInfoModel;

    protected UserController(SyncController syncController, SessionController sessionController, SwitchUserController switchUserController, DispatchQueue queue, PropertyStorage storage, Integer batchSize, SdkInfoModel infoModel) {
        this.workerQueue = queue;
        this.batchSize = batchSize;
        this.sdkInfoModel = infoModel;
        this.sessionController = sessionController;
        this.switchUserController = switchUserController;
        this.storage = storage;
        String currentId = this.sdkInfoModel.getCurrentLoggedInId();
        if (TextUtils.isEmpty((CharSequence)currentId)) {
            currentId = this.sdkInfoModel.getDeviceId();
        }
        if (TextUtils.isEmpty((CharSequence)currentId)) {
            throw new IllegalArgumentException("Found no valid ID in user controller constructor.");
        }
        this.initializeForIdentifier(currentId);
        this.syncController = syncController;
    }

    public SyncController getSyncController() {
        return this.syncController;
    }

    @Override
    public void setBatchSize(Integer newBatchSize) {
        this.batchSize = newBatchSize;
    }

    public UserModel getCurrentUser() {
        return this.currentUser;
    }

    private void setCurrentUser(UserModel newUser) {
        this.currentUser = newUser;
    }

    private void initializeForIdentifier(String identifier) {
        if (!TextUtils.isEmpty((CharSequence)identifier)) {
            String previousLogin = null;
            if (this.currentUser != null) {
                previousLogin = this.currentUser.getIdentifier();
            }
            if (this.currentUser == null || !identifier.equals(previousLogin)) {
                this.storage.initStorage(identifier);
                this.currentUser = new UserModel(identifier, this.storage);
                this.sdkInfoModel.setCurrentLoggedInId(identifier);
            }
            HashMap<String, PropertyValue> syncingProperties = this.getSyncingPropertiesUnsafe();
            String[] syncingKeys = syncingProperties.keySet().toArray(new String[syncingProperties.keySet().size()]);
            ArrayList<String> syncingList = new ArrayList<String>(Arrays.asList(syncingKeys));
            this.getCurrentUser().setSyncStatus(SyncStatus.UNSYNCED, syncingList);
        }
    }

    private void switchToUser(String userId, String oldUserId) {
        if (!oldUserId.equals(userId)) {
            boolean isSessionActive = this.sessionController.isSessionActive();
            if (isSessionActive) {
                this.sessionController.endSession();
            }
            this.initializeForIdentifier(userId);
            if (isSessionActive) {
                this.sessionController.startSession();
            }
            this.switchUserController.requestSwitch(userId, oldUserId);
        }
    }

    public void logout() {
        final UserController controller = this;
        if (!controller.currentUser.getIdentifier().equals(controller.sdkInfoModel.getDeviceId())) {
            this.workerQueue.dispatchAsync(new Runnable(){

                @Override
                public void run() {
                    String currentLogin = controller.currentUser.getIdentifier();
                    controller.switchToUser(UserController.this.sdkInfoModel.getDeviceId(), currentLogin);
                }
            });
        }
    }

    public void login(final String identifier, final String name, final String email) {
        final UserController controller = this;
        String[] invalidLogins = new String[]{null, "", "null"};
        if (Arrays.asList(invalidLogins).contains(identifier)) {
            this.logout();
        } else {
            this.workerQueue.dispatchSync(new Runnable(){

                @Override
                public void run() {
                    String currentLogin = controller.currentUser.getIdentifier();
                    controller.switchToUser(identifier, currentLogin);
                    controller.setNameAndEmail(name, email);
                }
            });
        }
    }

    private Integer getSizeOfUserProperties() {
        return this.getSizeOfPropertiesMap(this.getAllPropertiesUnsafe());
    }

    private Integer getSizeOfPropertiesMap(HashMap<String, PropertyValue> inputProperties) {
        Integer currentSize = 0;
        if (inputProperties != null && inputProperties.size() > 0) {
            HashMap<String, ArrayList> jsonRepresentation = new HashMap<String, ArrayList>();
            for (Map.Entry<String, PropertyValue> entry : inputProperties.entrySet()) {
                PropertyValue value = entry.getValue();
                ArrayList valueInfo = value.getValueInfo();
                jsonRepresentation.put(entry.getKey(), valueInfo);
            }
            JSONObject propertiesJson = new JSONObject(jsonRepresentation);
            try {
                currentSize = propertiesJson.toString().getBytes("UTF-8").length;
            }
            catch (UnsupportedEncodingException e) {
                Log.d((String)TAG, (String)"Exception while getting property size : ", (Throwable)e);
            }
        }
        return currentSize;
    }

    public boolean addProperty(final String key, final PropertyValue value) {
        final UserController controller = this;
        final boolean isValidKey = SchemaUtil.validatePropertyKey(key);
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                if (isValidKey) {
                    HashMap<String, PropertyValue> propertyValueHashMap = new HashMap<String, PropertyValue>();
                    propertyValueHashMap.put(key, value);
                    Integer inputSize = controller.getSizeOfPropertiesMap(propertyValueHashMap);
                    if (controller.getSizeOfUserProperties() + inputSize <= 102400 && controller.getCurrentUser().addProperty(key, value)) {
                        controller.syncController.incrementDataChangeCount("data_type_user", 1);
                    }
                }
            }
        });
        return isValidKey;
    }

    public String[] addProperties(HashMap<String, PropertyValue> propertyValueHashMap) {
        final UserController controller = this;
        final HashMap<String, PropertyValue> acceptableProperties = new HashMap<String, PropertyValue>();
        for (Map.Entry<String, PropertyValue> entry : propertyValueHashMap.entrySet()) {
            if (!SchemaUtil.validatePropertyKey(entry.getKey())) continue;
            acceptableProperties.put(entry.getKey(), entry.getValue());
        }
        this.workerQueue.dispatchAsync(new Runnable(){

            @Override
            public void run() {
                if (acceptableProperties.size() > 0) {
                    ArrayList<String> addToDb;
                    int addToDbCount;
                    Integer inputSize = controller.getSizeOfPropertiesMap(acceptableProperties);
                    if (controller.getSizeOfUserProperties() + inputSize <= 102400 && (addToDbCount = (addToDb = controller.getCurrentUser().addProperties(acceptableProperties)).size()) > 0) {
                        controller.syncController.incrementDataChangeCount("data_type_user", addToDbCount);
                    }
                }
            }
        });
        return acceptableProperties.keySet().toArray(new String[acceptableProperties.size()]);
    }

    public HashMap<String, PropertyValue> getUnsyncedProperties() {
        final UserController controller = this;
        final HashMap<String, PropertyValue> properties = new HashMap<String, PropertyValue>();
        this.workerQueue.dispatchSync(new Runnable(){

            @Override
            public void run() {
                properties.putAll(controller.getCurrentUser().getUnsyncedProperties());
            }
        });
        return properties;
    }

    public HashMap<String, PropertyValue> getSyncingPropertiesUnsafe() {
        return this.getCurrentUser().getSyncingProperties();
    }

    private HashMap<String, PropertyValue> getAllPropertiesUnsafe() {
        return this.getCurrentUser().getAllProperties();
    }

    private HashMap<String, ArrayList> batchProperties(HashMap<String, PropertyValue> inputProperties, Integer batchSize) {
        HashMap<String, ArrayList> batchedProperties = new HashMap<String, ArrayList>();
        Integer currentSize = 0;
        Integer batchSizeInBytes = batchSize * 1024 * 1024;
        for (Map.Entry<String, PropertyValue> entry : inputProperties.entrySet()) {
            PropertyValue value = entry.getValue();
            ArrayList valueInfo = value.getValueInfo();
            JSONArray valueJson = new JSONArray((Collection)valueInfo);
            try {
                int jsonLength = valueJson.toString().getBytes("UTF-8").length;
                if (currentSize + jsonLength > batchSizeInBytes) break;
                batchedProperties.put(entry.getKey(), valueInfo);
                currentSize = currentSize + jsonLength;
            }
            catch (UnsupportedEncodingException e) {
                Log.d((String)TAG, (String)"Exception in batching : ", (Throwable)e);
            }
        }
        return batchedProperties;
    }

    @Override
    public Request getRequest() {
        Request newRequest = null;
        HashMap<String, ArrayList> unsyncedProperties = this.batchProperties(this.getUnsyncedProperties(), this.batchSize);
        if (unsyncedProperties.size() > 0) {
            final UserController userController = this;
            JSONObject propertiesJson = HSJSONUtils.fromNestedMap(unsyncedProperties);
            HashMap<String, String> apiData = new HashMap<String, String>();
            apiData.put("did", this.sdkInfoModel.getDeviceId());
            apiData.put("uid", this.getCurrentUser().getIdentifier());
            apiData.put("p", propertiesJson.toString());
            String[] unSyncedKeys = unsyncedProperties.keySet().toArray(new String[unsyncedProperties.keySet().size()]);
            final ArrayList<String> unSyncedList = new ArrayList<String>(Arrays.asList(unSyncedKeys));
            this.getCurrentUser().setSyncStatus(SyncStatus.SYNCING, unSyncedList);
            newRequest = new Request(1, "/ma/up/", apiData, new Response.Listener<JSONArray>(){

                @Override
                public void onResponse(JSONArray response, Integer requestId) {
                    userController.syncController.dataSynced("data_type_user");
                    userController.getCurrentUser().setSyncStatus(SyncStatus.SYNCED, unSyncedList);
                }
            }, new Response.ErrorListener(){

                @Override
                public void onErrorResponse(NetworkError error, Integer requestId) {
                    userController.getCurrentUser().setSyncStatus(SyncStatus.UNSYNCED, unSyncedList);
                }
            }, new JsonArrayResponseParser());
        }
        return newRequest;
    }

    public void setNameAndEmail(String name, String email) {
        String validName = null;
        String validEmail = null;
        if (name != null) {
            validName = name.trim();
        }
        if (email != null) {
            validEmail = email.trim();
        }
        HashMap<String, PropertyValue> userProperties = new HashMap<String, PropertyValue>();
        if (!TextUtils.isEmpty((CharSequence)validName) && !HSPattern.checkSpecialCharacters(validName)) {
            PropertyValue nameProperty = new PropertyValue(validName);
            userProperties.put("name", nameProperty);
        }
        if (!TextUtils.isEmpty((CharSequence)validEmail) && HSPattern.checkEmail(validEmail)) {
            PropertyValue emailProperty = new PropertyValue(validEmail);
            userProperties.put("email", emailProperty);
        }
        this.addProperties(userProperties);
        this.currentUser.setNameAndEmail(validName, validEmail);
    }
}

