/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.models;

import com.helpshift.campaigns.controllers.ControllerFactory;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class AnalyticsEvent
implements Serializable {
    private String eventId;
    private String campaignId;
    private Long timeStamp;
    private String userId;
    private Integer type;

    public AnalyticsEvent(Integer type, String campaignId) {
        long now = System.currentTimeMillis();
        this.eventId = "__hs_ae_" + campaignId + "_" + now;
        this.campaignId = campaignId;
        this.timeStamp = now;
        this.userId = ControllerFactory.getInstance().userController.getCurrentUser().getIdentifier();
        this.type = type;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public Long getTimeStamp() {
        return this.timeStamp;
    }

    public String getUserId() {
        return this.userId;
    }

    public Integer getType() {
        return this.type;
    }

    public HashMap toData() {
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("cid", this.campaignId);
        eventData.put("uid", this.userId);
        eventData.put("ts", this.timeStamp);
        eventData.put("t", this.type);
        eventData.put("v", 1);
        return eventData;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeUTF(this.eventId);
        out.writeUTF(this.campaignId);
        out.writeLong(this.timeStamp);
        out.writeUTF(this.userId);
        out.writeInt(this.type);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.eventId = in.readUTF();
        this.campaignId = in.readUTF();
        this.timeStamp = in.readLong();
        this.userId = in.readUTF();
        this.type = in.readInt();
    }

    public static class AnalyticsEventType {
        public static final Integer DEFAULT = 0;
        public static final Integer DELIVERY = 1;
        public static final Integer VIEW = 2;
        public static final Integer FAILURE = 3;
    }
}

