/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.models;

import android.content.Context;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.helpshift.campaigns.models.Device;
import com.helpshift.network.util.IpUtil;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HelpshiftContext;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.TimeZone;

public class AndroidDevice
implements Device {
    private static final String TAG = "HelpshiftDebug";

    @Override
    public String getOsVersion() {
        return Build.VERSION.RELEASE;
    }

    @Override
    public String getBuildModel() {
        return Build.MODEL;
    }

    @Override
    public String getAppVersion() {
        return ApplicationUtil.getApplicationVersion(HelpshiftContext.getApplicationContext());
    }

    @Override
    public String getCountryCode() {
        Context context = HelpshiftContext.getApplicationContext();
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getSimCountryIso();
    }

    @Override
    public String getLanguageCode() {
        String languageCode = null;
        try {
            languageCode = Locale.getDefault().toString();
        }
        catch (MissingResourceException e) {
            Log.d((String)TAG, (String)"Device Info - MissingResourceException", (Throwable)e);
        }
        return languageCode;
    }

    @Override
    public String getCarrierName() {
        Context context = HelpshiftContext.getApplicationContext();
        TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
        return tm.getNetworkOperatorName();
    }

    @Override
    public Integer getTimeZone() {
        TimeZone tz = TimeZone.getDefault();
        return tz.getRawOffset() / 60000;
    }

    @Override
    public String getIpAddress() {
        return IpUtil.getIPAddress(true);
    }
}

