/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.models;

import android.location.Location;
import android.text.TextUtils;
import com.helpshift.campaigns.util.constants.SyncStatus;
import com.helpshift.util.HSFormat;
import com.helpshift.util.LocationUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

public class PropertyValue
implements Serializable {
    private Object value;
    private String type;
    private Integer isSynced;

    public PropertyValue(Object value) {
        this.value = value;
        this.type = "u";
        this.isSynced = SyncStatus.UNSYNCED;
        if (value instanceof String) {
            if (!TextUtils.isEmpty((CharSequence)((String)(value = ((String)value).trim())))) {
                this.type = "s";
                this.value = value;
            }
        } else if (value instanceof Integer) {
            this.type = "n";
        } else if (value instanceof Boolean) {
            this.type = "b";
        } else if (value instanceof Date) {
            this.type = "d";
        } else if (value instanceof Location) {
            this.type = "l";
            this.value = LocationUtil.sanitizeLocation((Location)value);
        }
        if (this.type.equals("u")) {
            this.value = null;
        }
    }

    public PropertyValue(String type, String valueString) {
        this.type = type;
        if (valueString != null && type != null) {
            this.value = this.fromString(valueString.trim());
        }
        if (this.value == null) {
            this.type = "u";
        }
        this.isSynced = SyncStatus.UNSYNCED;
    }

    public Object getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public Integer getIsSynced() {
        return this.isSynced;
    }

    public void setIsSynced(Integer synced) {
        if (synced != null && SyncStatus.valueSet.contains(synced)) {
            this.isSynced = synced;
        }
    }

    public boolean equals(Object otherObj) {
        if (otherObj instanceof PropertyValue) {
            PropertyValue other = (PropertyValue)otherObj;
            return this.isSynced.equals(other.isSynced) && this.type.equals(other.type) && this.value.equals(other.value);
        }
        return false;
    }

    public String toString() {
        String value = null;
        if (this.value != null) {
            value = this.value.toString();
            if (this.type.equals("d")) {
                value = "" + ((Date)this.value).getTime();
            } else if (this.type.equals("l")) {
                Location location = (Location)this.value;
                value = location.getLatitude() + "," + location.getLongitude();
            }
        }
        return value;
    }

    private Object fromString(String valueString) {
        Object value;
        switch (this.type) {
            case "s": {
                if (!TextUtils.isEmpty((CharSequence)valueString)) {
                    value = valueString;
                    break;
                }
                value = null;
                break;
            }
            case "n": {
                try {
                    value = Integer.parseInt(valueString);
                }
                catch (NumberFormatException e) {
                    value = null;
                }
                break;
            }
            case "d": {
                try {
                    value = new Date(Long.parseLong(valueString));
                }
                catch (NumberFormatException e) {
                    value = null;
                }
                break;
            }
            case "b": {
                value = Boolean.parseBoolean(valueString);
                break;
            }
            case "l": {
                try {
                    String[] info = valueString.split(",");
                    Location newLocation = new Location("");
                    newLocation.setLatitude(Double.parseDouble(info[0]));
                    newLocation.setLongitude(Double.parseDouble(info[1]));
                    value = LocationUtil.sanitizeLocation(newLocation);
                }
                catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
                    value = null;
                }
                break;
            }
            default: {
                value = null;
            }
        }
        return value;
    }

    public ArrayList getValueInfo() {
        ArrayList<Object> returnValues = new ArrayList<Object>();
        returnValues.add(0, this.type);
        if (this.type.equals("l")) {
            Location location = (Location)this.value;
            returnValues.add(1, location.getLatitude() + "," + location.getLongitude());
        } else if (this.type.equals("d")) {
            returnValues.add(1, HSFormat.datePropertyTsFormat.format((Date)this.value));
        } else {
            returnValues.add(1, this.value);
        }
        return returnValues;
    }

    public boolean setValue(Object newValue) {
        boolean valueChanged = false;
        if (newValue instanceof String && (this.type.equals("s") || this.type.equals("u"))) {
            if (!TextUtils.isEmpty((CharSequence)((String)(newValue = ((String)newValue).trim()))) && !newValue.equals(this.value)) {
                valueChanged = true;
                this.type = "s";
            }
        } else if (newValue instanceof Integer && (this.type.equals("n") || this.type.equals("u")) && !newValue.equals(this.value)) {
            valueChanged = true;
            this.type = "n";
        } else if (newValue instanceof Boolean && (this.type.equals("b") || this.type.equals("u")) && !newValue.equals(this.value)) {
            valueChanged = true;
            this.type = "b";
        } else if (newValue instanceof Date && (this.type.equals("d") || this.type.equals("u")) && !newValue.equals(this.value)) {
            valueChanged = true;
            this.type = "d";
        } else if (newValue instanceof Location && (this.type.equals("l") || this.type.equals("u")) && !LocationUtil.isSameLocation((Location)this.value, (Location)newValue)) {
            valueChanged = true;
            this.type = "l";
            newValue = LocationUtil.sanitizeLocation((Location)newValue);
        }
        if (valueChanged) {
            this.value = newValue;
            this.isSynced = SyncStatus.UNSYNCED;
        }
        return valueChanged;
    }

    public boolean setValue(PropertyValue newValue) {
        return this.setValue(newValue.value);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.value);
        out.writeInt(this.isSynced);
        out.writeUTF(this.type);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.value = in.readObject();
        this.isSynced = in.readInt();
        this.type = in.readUTF();
    }

    public static class ValueTypes {
        public static final String STRING = "s";
        public static final String NUMBER = "n";
        public static final String BOOLEAN = "b";
        public static final String DATE = "d";
        public static final String LOCATION = "l";
        public static final String UNKNOWN = "u";
    }
}

