/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.models;

import android.os.SystemClock;
import com.helpshift.campaigns.controllers.ControllerFactory;
import com.helpshift.campaigns.models.DeviceModel;
import com.helpshift.campaigns.util.constants.SyncStatus;
import com.helpshift.util.TimeUtil;
import java.util.ArrayList;
import java.util.HashMap;

public class SessionModel {
    private String identifier;
    private String deviceIdentifier;
    private String userIdentifier;
    private long startTime;
    private long endTime;
    private long referenceTime;
    private long startElapsedTime;
    private ArrayList<Long> durations;
    private Integer syncStatus;

    public SessionModel() {
        long time = TimeUtil.getCurrentTimeInMillis();
        this.startElapsedTime = SystemClock.elapsedRealtime();
        DeviceModel deviceModel = ControllerFactory.getInstance().deviceController.getDeviceModel();
        this.identifier = "__hs_session_" + deviceModel.getIdentifier() + "_" + time;
        this.deviceIdentifier = deviceModel.getIdentifier();
        this.userIdentifier = ControllerFactory.getInstance().userController.getCurrentUser().getIdentifier();
        this.startTime = time;
        this.endTime = 0L;
        this.referenceTime = this.startTime;
        this.syncStatus = SyncStatus.UNSYNCED;
        this.durations = new ArrayList();
    }

    public SessionModel(String identifier, String deviceIdentifier, String userIdentifier, long startTime, long endTime, ArrayList<Long> durations, Integer syncStatus) {
        this.identifier = identifier;
        this.deviceIdentifier = deviceIdentifier;
        this.userIdentifier = userIdentifier;
        this.startTime = startTime;
        this.endTime = endTime;
        this.durations = durations;
        this.syncStatus = syncStatus;
        long refTime = this.startTime;
        for (Long increment : this.durations) {
            refTime += increment.longValue();
        }
        this.referenceTime = refTime;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    public String getDeviceIdentifier() {
        return this.deviceIdentifier;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public ArrayList<Long> getDurations() {
        return this.durations;
    }

    public Integer getSyncStatus() {
        return this.syncStatus;
    }

    public ArrayList<HashMap> toData() {
        ArrayList<HashMap> sessionEvent = new ArrayList<HashMap>();
        HashMap<String, Object> start = new HashMap<String, Object>();
        start.put("t", "s");
        start.put("sid", this.identifier);
        start.put("ts", this.startTime);
        sessionEvent.add(start);
        for (Long duration : this.durations) {
            HashMap<String, Object> interval = new HashMap<String, Object>();
            interval.put("t", "d");
            interval.put("sid", this.identifier);
            interval.put("d", duration);
            sessionEvent.add(interval);
        }
        HashMap<String, Object> end = new HashMap<String, Object>();
        end.put("t", "e");
        end.put("sid", this.identifier);
        end.put("ts", this.endTime);
        end.put("d", this.endTime - this.referenceTime);
        sessionEvent.add(end);
        return sessionEvent;
    }

    public void endNow() {
        if (this.endTime == 0L) {
            long currentElapsedTime = SystemClock.elapsedRealtime();
            this.endTime = this.startTime + (currentElapsedTime - this.startElapsedTime);
        }
    }

    public void updateDurations() {
        if (this.endTime == 0L) {
            long currentTime = this.startTime + (SystemClock.elapsedRealtime() - this.startElapsedTime);
            this.durations.add(currentTime - this.referenceTime);
            this.referenceTime = currentTime;
        }
    }

    public boolean equals(Object other) {
        if (other instanceof SessionModel) {
            SessionModel otherObj = (SessionModel)other;
            return this.identifier.equals(otherObj.identifier) && this.deviceIdentifier.equals(otherObj.deviceIdentifier) && this.userIdentifier.equals(otherObj.userIdentifier) && this.startTime == otherObj.startTime && this.endTime == otherObj.endTime && this.syncStatus.equals(otherObj.syncStatus) && this.durations.equals(otherObj.durations);
        }
        return false;
    }
}

