/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.models;

import com.helpshift.campaigns.models.SessionModel;
import com.helpshift.campaigns.util.constants.SyncStatus;
import java.util.ArrayList;

public class SessionModelBuilder {
    private final String identifier;
    private final String userIdentifier;
    private final String deviceIdentifier;
    private final long startTime;
    private ArrayList<Long> durations;
    private long endTime;
    private long referenceTime;
    private Integer syncStatus;

    public SessionModelBuilder(String identifier, String deviceIdentifier, String userIdentifier, long startTime) {
        this.identifier = identifier;
        this.deviceIdentifier = deviceIdentifier;
        this.userIdentifier = userIdentifier;
        this.startTime = startTime;
        this.endTime = 0L;
        this.syncStatus = SyncStatus.UNSYNCED;
        this.referenceTime = 0L;
    }

    public SessionModelBuilder setEndTime(long endTime) {
        this.endTime = endTime;
        return this;
    }

    public SessionModelBuilder setSyncStatus(Integer syncStatus) {
        this.syncStatus = syncStatus;
        return this;
    }

    public SessionModelBuilder setDurations(ArrayList<Long> durations) {
        this.durations = durations;
        return this;
    }

    public SessionModel build() {
        return new SessionModel(this.identifier, this.deviceIdentifier, this.userIdentifier, this.startTime, this.endTime, this.durations, this.syncStatus);
    }
}

