/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.models;

import com.helpshift.campaigns.models.PropertyValue;
import com.helpshift.campaigns.storage.PropertyStorage;
import com.helpshift.campaigns.util.constants.SyncStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class UserModel {
    String identifier;
    String name;
    String email;
    PropertyStorage storage;
    HashMap<String, PropertyValue> properties;

    public UserModel(String identifier, PropertyStorage storage) {
        PropertyValue email;
        this.identifier = identifier;
        this.properties = storage.getAllProperties(identifier);
        this.storage = storage;
        PropertyValue name = storage.getProperty("name", identifier);
        if (name != null) {
            this.name = name.toString();
        }
        if ((email = storage.getProperty("email", identifier)) != null) {
            this.email = email.toString();
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public boolean addProperty(String key, PropertyValue value) {
        PropertyValue existingValue;
        boolean valueChanged = false;
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if ((existingValue = this.properties.get(key)) != null && existingValue.setValue(value) || existingValue == null) {
            valueChanged = true;
        }
        if (valueChanged) {
            this.properties.put(key, value);
            this.storage.setProperty(key, value, this.identifier);
        }
        return valueChanged;
    }

    public ArrayList<String> addProperties(HashMap<String, PropertyValue> properties) {
        ArrayList<String> propertiesChanged = new ArrayList<String>();
        for (Map.Entry<String, PropertyValue> entry : properties.entrySet()) {
            if (!this.addProperty(entry.getKey(), entry.getValue())) continue;
            propertiesChanged.add(entry.getKey());
        }
        return propertiesChanged;
    }

    public HashMap<String, PropertyValue> getUnsyncedProperties() {
        HashMap<String, PropertyValue> unsynced = new HashMap<String, PropertyValue>();
        if (this.properties != null) {
            for (Map.Entry<String, PropertyValue> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                PropertyValue value = entry.getValue();
                if (!value.getIsSynced().equals(SyncStatus.UNSYNCED)) continue;
                unsynced.put(key, value);
            }
        }
        return unsynced;
    }

    public HashMap<String, PropertyValue> getSyncingProperties() {
        HashMap<String, PropertyValue> syncing = new HashMap<String, PropertyValue>();
        if (this.properties != null) {
            for (Map.Entry<String, PropertyValue> entry : this.properties.entrySet()) {
                String key = entry.getKey();
                PropertyValue value = entry.getValue();
                if (!value.getIsSynced().equals(SyncStatus.SYNCING)) continue;
                syncing.put(key, value);
            }
        }
        return syncing;
    }

    public HashMap<String, PropertyValue> getAllProperties() {
        return this.properties;
    }

    public void setSyncStatus(Integer syncStatus, ArrayList<String> keys) {
        if (this.properties != null && keys != null) {
            for (String key : keys) {
                PropertyValue value = this.properties.get(key);
                if (value == null) continue;
                value.setIsSynced(syncStatus);
                this.storage.setSyncStatus(syncStatus, key, this.identifier);
            }
        }
    }

    public void setNameAndEmail(String name, String email) {
        this.name = name;
        this.email = email;
    }
}

