/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.network;

import com.helpshift.campaigns.controllers.AnalyticsEventController;
import com.helpshift.campaigns.controllers.UserController;
import com.helpshift.controllers.DataSyncCoordinator;
import com.helpshift.listeners.SyncListener;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.request.Request;
import com.helpshift.network.request.RequestQueue;
import com.helpshift.util.ConnectivityUtil;

public class AnalyticsEventNetworkManager
extends SyncListener {
    private NetworkDataProvider dataProvider;
    private UserController userController;
    private RequestQueue requestQueue;
    private ConnectivityUtil connectivityUtil;
    private DataSyncCoordinator dataSyncCoordinator;

    public AnalyticsEventNetworkManager(AnalyticsEventController analyticsEventController, DataSyncCoordinator dataSyncCoordinator, UserController userController, RequestQueue requestQueue, ConnectivityUtil connectivityUtil) {
        super("data_type_analytics_event");
        this.dataProvider = analyticsEventController;
        analyticsEventController.getSyncController().addSyncListeners(this);
        this.dataSyncCoordinator = dataSyncCoordinator;
        this.userController = userController;
        this.requestQueue = requestQueue;
        this.connectivityUtil = connectivityUtil;
    }

    @Override
    public void sync() {
        if (this.dataSyncCoordinator.canSyncUserProperties(this.userController.getCurrentUser().getIdentifier())) {
            this.dataProvider.setBatchSize(this.connectivityUtil.getBatchSize());
            Request newRequest = this.dataProvider.getRequest();
            if (newRequest != null) {
                this.requestQueue.add(newRequest);
            }
        }
    }
}

