/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.network;

import com.helpshift.campaigns.controllers.SessionController;
import com.helpshift.campaigns.controllers.UserController;
import com.helpshift.controllers.DataSyncCoordinator;
import com.helpshift.listeners.SyncListener;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.request.Request;
import com.helpshift.network.request.RequestQueue;
import com.helpshift.util.ConnectivityUtil;

public class SessionNetworkManager
extends SyncListener {
    private NetworkDataProvider dataProvider;
    private RequestQueue requestQueue;
    private ConnectivityUtil connectivityUtil;
    private DataSyncCoordinator dataSyncCoordinator;
    private UserController userController;

    protected SessionNetworkManager(SessionController sessionController, UserController userController, DataSyncCoordinator dataSyncCoordinator, RequestQueue requestQueue, ConnectivityUtil connectivityUtil) {
        super("data_type_session");
        this.dataProvider = sessionController;
        sessionController.getSyncController().addSyncListeners(this);
        this.dataSyncCoordinator = dataSyncCoordinator;
        this.userController = userController;
        this.requestQueue = requestQueue;
        this.connectivityUtil = connectivityUtil;
    }

    @Override
    public void sync() {
        if (this.dataSyncCoordinator.canSyncSessionProperties(this.userController.getCurrentUser().getIdentifier())) {
            this.dataProvider.setBatchSize(this.connectivityUtil.getBatchSize());
            Request newRequest = this.dataProvider.getRequest();
            if (newRequest != null) {
                this.requestQueue.add(newRequest);
            }
        }
    }
}

