/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.network;

import com.helpshift.campaigns.controllers.SwitchUserController;
import com.helpshift.controllers.DataSyncCoordinator;
import com.helpshift.listeners.SyncListener;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.request.Request;
import com.helpshift.network.request.RequestQueue;
import com.helpshift.util.ConnectivityUtil;

public class SwitchUserNetworkManager
extends SyncListener {
    private NetworkDataProvider dataProvider;
    private DataSyncCoordinator dataSyncCoordinator;
    private RequestQueue requestQueue;
    private ConnectivityUtil connectivityUtil;

    protected SwitchUserNetworkManager(SwitchUserController switchUserController, DataSyncCoordinator dataSyncCoordinator, RequestQueue requestQueue, ConnectivityUtil connectivityUtil) {
        super("data_type_switch_user");
        switchUserController.getSyncController().addSyncListeners(this);
        this.dataProvider = switchUserController;
        this.dataSyncCoordinator = dataSyncCoordinator;
        this.requestQueue = requestQueue;
        this.connectivityUtil = connectivityUtil;
    }

    @Override
    public void sync() {
        if (this.dataSyncCoordinator.isFirstDeviceSyncComplete()) {
            this.dataProvider.setBatchSize(this.connectivityUtil.getBatchSize());
            Request newRequest = this.dataProvider.getRequest();
            if (newRequest != null) {
                this.requestQueue.add(newRequest);
            }
        }
    }
}

