/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.network;

import com.helpshift.campaigns.controllers.UserController;
import com.helpshift.controllers.DataSyncCoordinator;
import com.helpshift.listeners.SyncListener;
import com.helpshift.network.NetworkDataProvider;
import com.helpshift.network.request.Request;
import com.helpshift.network.request.RequestQueue;
import com.helpshift.util.ConnectivityUtil;

public class UserPropertiesNetworkManager
extends SyncListener {
    private NetworkDataProvider dataProvider;
    private RequestQueue requestQueue;
    private ConnectivityUtil connectivityUtil;
    private DataSyncCoordinator dataSyncCoordinator;

    protected UserPropertiesNetworkManager(UserController userController, DataSyncCoordinator dataSyncCoordinator, RequestQueue requestQueue, ConnectivityUtil connectivityUtil) {
        super("data_type_user");
        userController.getSyncController().addSyncListeners(this);
        this.dataProvider = userController;
        this.dataSyncCoordinator = dataSyncCoordinator;
        this.requestQueue = requestQueue;
        this.connectivityUtil = connectivityUtil;
    }

    @Override
    public void sync() {
        if (this.dataSyncCoordinator.canSyncUserProperties(((UserController)this.dataProvider).getCurrentUser().getIdentifier())) {
            this.dataProvider.setBatchSize(this.connectivityUtil.getBatchSize());
            Request newRequest = this.dataProvider.getRequest();
            if (newRequest != null) {
                this.requestQueue.add(newRequest);
            }
        }
    }
}

