/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.helpshift.campaigns.models.PropertyValue;
import com.helpshift.campaigns.storage.PropertyDbHelper;
import com.helpshift.campaigns.storage.PropertyStorage;
import com.helpshift.campaigns.util.constants.SyncStatus;
import com.helpshift.util.DatabaseUtils;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.StringUtil;
import java.util.HashMap;

public class PropertyDbStorage
implements PropertyStorage {
    private final PropertyDbHelper helper = new PropertyDbHelper(HelpshiftContext.getApplicationContext());
    private SQLiteDatabase database;

    private void read() {
        this.database = this.helper.getReadableDatabase();
    }

    private void write() {
        this.database = this.helper.getWritableDatabase();
    }

    private void close() {
        this.database.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initStorage(String identifier) {
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            this.write();
            this.helper.createIdentifierTable(this.database, identifier);
            this.close();
        }
    }

    @Override
    public void initSecondaryStorage(String identifier) {
        this.initStorage(this.getSecondaryName(identifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reinitStorage(String identifier) {
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            this.write();
            this.helper.dropIdentifierTable(this.database, identifier);
            this.helper.createIdentifierTable(this.database, identifier);
            this.close();
        }
    }

    @Override
    public void reinitSecondaryStorage(String identifier) {
        this.reinitStorage(this.getSecondaryName(identifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String key, PropertyValue value, String identifier) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null || TextUtils.isEmpty((CharSequence)identifier)) {
            return;
        }
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            this.write();
            this.database.beginTransaction();
            String whereClause = "key=?";
            String[] whereArgs = new String[]{key};
            if (DatabaseUtils.exists(this.database, StringUtil.escapeForSql("property_" + identifier), whereClause, whereArgs)) {
                this.database.update(StringUtil.escapeForSql("property_" + identifier), this.propertyToContentValues(key, value), whereClause, whereArgs);
            } else {
                this.database.insert(StringUtil.escapeForSql("property_" + identifier), null, this.propertyToContentValues(key, value));
            }
            this.database.setTransactionSuccessful();
            this.database.endTransaction();
            this.close();
        }
    }

    @Override
    public void setSecondaryProperty(String key, PropertyValue value, String identifier) {
        this.setProperty(key, value, this.getSecondaryName(identifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertyValue getProperty(String key, String identifier) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)identifier)) {
            return null;
        }
        PropertyValue value = null;
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            this.read();
            String whereClause = "key=?";
            String[] whereArgs = new String[]{key};
            Cursor cursor = this.database.query(StringUtil.escapeForSql("property_" + identifier), null, whereClause, whereArgs, null, null, null);
            if (cursor.moveToFirst()) {
                value = this.cursorToPropertyValue(cursor);
            }
            cursor.close();
            this.close();
        }
        return value;
    }

    @Override
    public PropertyValue getSecondaryProperty(String key, String identifier) {
        return this.getProperty(key, this.getSecondaryName(identifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSyncStatus(Integer syncStatus, String key, String identifier) {
        if (TextUtils.isEmpty((CharSequence)key) || TextUtils.isEmpty((CharSequence)identifier)) {
            return;
        }
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            this.write();
            this.database.beginTransaction();
            String whereClause = "key=?";
            String[] whereArgs = new String[]{key};
            ContentValues updateValues = new ContentValues();
            updateValues.put("sync_status", syncStatus);
            this.database.update(StringUtil.escapeForSql("property_" + identifier), updateValues, whereClause, whereArgs);
            this.database.setTransactionSuccessful();
            this.database.endTransaction();
            this.close();
        }
    }

    @Override
    public void setSecondaryPropertySyncStatus(Integer syncStatus, String key, String identifier) {
        this.setSyncStatus(syncStatus, key, this.getSecondaryName(identifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSyncStatus(Integer syncStatus, String[] keys, String identifier) {
        if (keys == null || keys.length == 0 || TextUtils.isEmpty((CharSequence)identifier)) {
            return;
        }
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            this.write();
            this.database.beginTransaction();
            String whereClause = "key in (" + DatabaseUtils.makePlaceholders(keys.length) + ")";
            ContentValues updateValues = new ContentValues();
            updateValues.put("sync_status", syncStatus);
            this.database.update(StringUtil.escapeForSql("property_" + identifier), updateValues, whereClause, keys);
            this.database.setTransactionSuccessful();
            this.database.endTransaction();
            this.close();
        }
    }

    @Override
    public void setSecondaryPropertySyncStatus(Integer syncStatus, String[] keys, String identifier) {
        this.setSyncStatus(syncStatus, keys, this.getSecondaryName(identifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, PropertyValue> getUnsyncedProperties(String identifier) {
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            return null;
        }
        HashMap<String, PropertyValue> unSyncedProperties = null;
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            this.read();
            String whereClause = "sync_status=?";
            String[] whereArgs = new String[]{"" + SyncStatus.UNSYNCED};
            Cursor cursor = this.database.query(StringUtil.escapeForSql("property_" + identifier), null, whereClause, whereArgs, null, null, null);
            if (cursor.moveToFirst()) {
                unSyncedProperties = new HashMap<String, PropertyValue>();
                while (!cursor.isAfterLast()) {
                    PropertyValue value = this.cursorToPropertyValue(cursor);
                    String key = cursor.getString(0);
                    unSyncedProperties.put(key, value);
                    cursor.moveToNext();
                }
            }
            cursor.close();
            this.close();
        }
        return unSyncedProperties;
    }

    @Override
    public HashMap<String, PropertyValue> getUnsyncedSecondaryProperties(String identifier) {
        return this.getUnsyncedProperties(this.getSecondaryName(identifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HashMap<String, PropertyValue> getAllProperties(String identifier) {
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            return null;
        }
        HashMap<String, PropertyValue> allProperties = null;
        PropertyDbHelper propertyDbHelper = this.helper;
        synchronized (propertyDbHelper) {
            this.read();
            Cursor cursor = this.database.query(StringUtil.escapeForSql("property_" + identifier), null, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                allProperties = new HashMap<String, PropertyValue>();
                while (!cursor.isAfterLast()) {
                    PropertyValue value = this.cursorToPropertyValue(cursor);
                    String key = cursor.getString(0);
                    allProperties.put(key, value);
                    cursor.moveToNext();
                }
            }
            cursor.close();
            this.close();
        }
        return allProperties;
    }

    @Override
    public HashMap<String, PropertyValue> getAllSecondaryProperties(String identifier) {
        return this.getAllProperties(this.getSecondaryName(identifier));
    }

    private ContentValues propertyToContentValues(String key, PropertyValue value) {
        ContentValues values = new ContentValues();
        values.put("key", key);
        values.put("value", value.toString());
        values.put("type", value.getType());
        values.put("sync_status", value.getIsSynced());
        values.put("extras", "");
        return values;
    }

    private PropertyValue cursorToPropertyValue(Cursor cursor) {
        PropertyValue newValue = new PropertyValue(cursor.getString(2), cursor.getString(1));
        newValue.setIsSynced(cursor.getInt(3));
        return newValue;
    }

    private String getSecondaryName(String identifier) {
        return identifier + "__hs_secondary_data";
    }
}

