/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.campaigns.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.helpshift.campaigns.models.SessionModel;
import com.helpshift.campaigns.models.SessionModelBuilder;
import com.helpshift.campaigns.storage.SessionDbStorageHelper;
import com.helpshift.campaigns.storage.SessionStorage;
import com.helpshift.util.ByteArrayUtil;
import com.helpshift.util.DatabaseUtils;
import com.helpshift.util.HelpshiftContext;
import java.io.IOException;
import java.util.ArrayList;

public class SessionDbStorage
implements SessionStorage {
    private static final String TAG = "HelpshiftDebug";
    private final SessionDbStorageHelper helper = new SessionDbStorageHelper(HelpshiftContext.getApplicationContext());
    private SQLiteDatabase database;

    private void read() {
        this.database = this.helper.getReadableDatabase();
    }

    private void write() {
        this.database = this.helper.getWritableDatabase();
    }

    private void close() {
        this.database.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeSession(SessionModel newSession) {
        if (newSession == null) {
            return;
        }
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            this.write();
            this.database.beginTransaction();
            String whereClause = "identifier=?";
            String[] whereArgs = new String[]{newSession.getIdentifier()};
            if (DatabaseUtils.exists(this.database, "sessions", whereClause, whereArgs)) {
                this.database.update("sessions", this.sessionToContentValues(newSession), whereClause, whereArgs);
            } else {
                this.database.insert("sessions", null, this.sessionToContentValues(newSession));
            }
            this.database.setTransactionSuccessful();
            this.database.endTransaction();
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateSession(SessionModel session) {
        if (session == null) {
            return;
        }
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            this.write();
            this.database.beginTransaction();
            String whereClause = "identifier=?";
            String[] whereArgs = new String[]{session.getIdentifier()};
            if (DatabaseUtils.exists(this.database, "sessions", whereClause, whereArgs)) {
                ContentValues updateValues = new ContentValues();
                updateValues.put("start_time", Long.valueOf(session.getStartTime()));
                updateValues.put("end_time", Long.valueOf(session.getEndTime() > 0L ? session.getEndTime() : 0L));
                try {
                    updateValues.put("durations", ByteArrayUtil.toByteArray(session.getDurations()));
                }
                catch (IOException e) {
                    updateValues.put("durations", "");
                }
                this.database.update("sessions", updateValues, whereClause, whereArgs);
            }
            this.database.setTransactionSuccessful();
            this.database.endTransaction();
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSyncStatus(Integer syncStatus, String[] sessionIds) {
        if (sessionIds == null) {
            return;
        }
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            this.write();
            this.database.beginTransaction();
            String whereClause = "identifier in (" + DatabaseUtils.makePlaceholders(sessionIds.length) + ")";
            ContentValues updateValues = new ContentValues();
            updateValues.put("sync_status", syncStatus);
            this.database.update("sessions", updateValues, whereClause, sessionIds);
            this.database.setTransactionSuccessful();
            this.database.endTransaction();
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSessions(String[] sessionIds) {
        if (sessionIds == null) {
            return;
        }
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            this.write();
            this.database.beginTransaction();
            String whereClause = "identifier in (" + DatabaseUtils.makePlaceholders(sessionIds.length) + ")";
            this.database.delete("sessions", whereClause, sessionIds);
            this.database.setTransactionSuccessful();
            this.database.endTransaction();
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<SessionModel> getAllSessions(Integer syncStatus) {
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            this.read();
            ArrayList<SessionModel> sessions = null;
            String whereClause = "sync_status=" + syncStatus;
            Cursor cursor = this.database.query("sessions", null, whereClause, null, null, null, null);
            if (cursor.moveToFirst()) {
                sessions = new ArrayList<SessionModel>();
                while (!cursor.isAfterLast()) {
                    sessions.add(this.cursorToSessionModel(cursor));
                    cursor.moveToNext();
                }
            }
            cursor.close();
            this.close();
            return sessions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int cleanUpInvalidSessions() {
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            this.write();
            String whereClause = "end_time=0";
            int num = this.database.delete("sessions", whereClause, null);
            this.close();
            return num;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionModel getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            this.read();
            SessionModel session = null;
            String whereClause = "identifier=?";
            String[] whereArgs = new String[]{sessionId};
            Cursor cursor = this.database.query("sessions", null, whereClause, whereArgs, null, null, null);
            if (cursor.moveToFirst()) {
                session = this.cursorToSessionModel(cursor);
            }
            cursor.close();
            this.close();
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reinitStorage() {
        SessionDbStorageHelper sessionDbStorageHelper = this.helper;
        synchronized (sessionDbStorageHelper) {
            this.write();
            this.database.delete("sessions", null, null);
            this.close();
        }
    }

    private ContentValues sessionToContentValues(SessionModel sessionModel) {
        ContentValues values = new ContentValues();
        values.put("identifier", sessionModel.getIdentifier());
        values.put("device_identifier", sessionModel.getDeviceIdentifier());
        values.put("user_identifier", sessionModel.getUserIdentifier());
        values.put("start_time", Long.valueOf(sessionModel.getStartTime()));
        values.put("end_time", Long.valueOf(sessionModel.getEndTime() > 0L ? sessionModel.getEndTime() : 0L));
        try {
            values.put("durations", ByteArrayUtil.toByteArray(sessionModel.getDurations()));
        }
        catch (IOException e) {
            values.put("durations", "");
        }
        values.put("sync_status", sessionModel.getSyncStatus());
        values.put("extras", "");
        return values;
    }

    private SessionModel cursorToSessionModel(Cursor cursor) {
        SessionModelBuilder builder = new SessionModelBuilder(cursor.getString(0), cursor.getString(1), cursor.getString(2), cursor.getLong(3)).setEndTime(cursor.getLong(4)).setSyncStatus(cursor.getInt(6));
        try {
            builder = builder.setDurations((ArrayList)ByteArrayUtil.toObject(cursor.getBlob(5)));
        }
        catch (IOException e) {
            builder = builder.setDurations(null);
            Log.d((String)TAG, (String)"IO Exception in retrieving session duration :", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            builder = builder.setDurations(null);
            Log.d((String)TAG, (String)"Class not found Exception in retrieving session duration :", (Throwable)e);
        }
        catch (ClassCastException e) {
            builder = builder.setDurations(null);
            Log.d((String)TAG, (String)"Class cast Exception in retrieving session duration :", (Throwable)e);
        }
        return builder.build();
    }
}

