/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.controllers;

import com.helpshift.app.LifecycleListener;
import com.helpshift.listeners.SyncListener;
import com.helpshift.specifications.SyncSpecification;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.HelpshiftConnectionUtil;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.TimeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;

public class SyncController
implements LifecycleListener {
    protected static final String COUNT = "count";
    protected static final String SYNC_TIME = "sync_time";
    private final TimeUtil timeUtil;
    private final KeyValueStorage keyValueStorage;
    private final LinkedBlockingQueue<SyncListener> syncListeners = new LinkedBlockingQueue();
    private final Map<String, SyncSpecification> syncSpecificationMap = new HashMap<String, SyncSpecification>();

    protected SyncController(KeyValueStorage keyValueStorage, TimeUtil timeUtil, SyncSpecification ... syncSpecifications) {
        this.keyValueStorage = keyValueStorage;
        this.timeUtil = timeUtil;
        for (SyncSpecification syncSpecification : syncSpecifications) {
            this.syncSpecificationMap.put(syncSpecification.getDataType(), syncSpecification);
        }
        HelpshiftContext.getMainLifecycleCallback().addLifecycleListener(this);
    }

    public void addSpecification(SyncSpecification syncSpecification) {
        this.syncSpecificationMap.put(syncSpecification.getDataType(), syncSpecification);
    }

    public void addSyncListeners(SyncListener ... listeners) {
        for (SyncListener listener : listeners) {
            if (!this.syncSpecificationMap.containsKey(listener.getDataType())) continue;
            this.syncListeners.add(listener);
        }
    }

    private void triggerSync(String ... dataTypes) {
        for (String dataType : dataTypes) {
            SyncSpecification specification = this.syncSpecificationMap.get(dataType);
            if (specification == null || !specification.isSatisfied(this.getDataChangeCount(dataType), this.getElapsedTimeSinceLastSync(dataType))) continue;
            this.dispatchSync(dataType);
        }
    }

    private void dispatchSync(String dataType) {
        for (SyncListener listener : this.syncListeners) {
            if (!listener.getDataType().equals(dataType)) continue;
            listener.sync();
        }
    }

    public void incrementDataChangeCount(String dataType, int count) {
        HashMap<String, String> information = this.getSyncInformation(dataType);
        int previousCount = Integer.valueOf(information.get(COUNT));
        information.put(COUNT, Integer.toString(previousCount + count));
        this.keyValueStorage.set(dataType, information);
    }

    public void setDataChangeCount(String dataType, int count) {
        HashMap<String, String> information = this.getSyncInformation(dataType);
        information.put(COUNT, Integer.toString(count));
        this.keyValueStorage.set(dataType, information);
    }

    public void dataSynced(String dataType) {
        HashMap<String, String> information = this.getSyncInformation(dataType);
        information.put(COUNT, Integer.toString(0));
        information.put(SYNC_TIME, Long.toString(this.timeUtil.elapsedTimeMillis()));
        this.keyValueStorage.set(dataType, information);
    }

    private int getDataChangeCount(String dataType) {
        return Integer.valueOf(this.getSyncInformation(dataType).get(COUNT));
    }

    private long getElapsedTimeSinceLastSync(String dataType) {
        return this.timeUtil.elapsedTimeMillis() - Long.valueOf(this.getSyncInformation(dataType).get(SYNC_TIME));
    }

    private HashMap<String, String> getSyncInformation(String dataType) {
        HashMap<String, String> information = (HashMap<String, String>)this.keyValueStorage.get(dataType);
        if (information == null) {
            information = new HashMap<String, String>();
            information.put(COUNT, Integer.toString(0));
            information.put(SYNC_TIME, Long.toString(0L));
        }
        return information;
    }

    @Override
    public void onForeground() {
    }

    @Override
    public void onBackground() {
        if (HelpshiftConnectionUtil.isOnline(HelpshiftContext.getApplicationContext())) {
            this.triggerSync("data_type_switch_user", "data_type_device", "data_type_user", "data_type_session", "data_type_analytics_event");
        }
    }

    public static class DataTypes {
        public static final String DEVICE = "data_type_device";
        public static final String USER = "data_type_user";
        public static final String SESSION = "data_type_session";
        public static final String SWITCH_USER = "data_type_switch_user";
        public static final String ANALYTICS_EVENT = "data_type_analytics_event";
    }
}

