/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network;

import com.helpshift.exceptions.InstallException;
import com.helpshift.network.Header;
import com.helpshift.network.HttpEntity;
import com.helpshift.network.HttpResponse;
import com.helpshift.network.HttpStack;
import com.helpshift.network.StatusLine;
import com.helpshift.network.request.Request;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class HurlStack
implements HttpStack {
    private static final String TAG = "HelpshiftDebug";

    @Override
    public HttpResponse performRequest(Request request) throws IOException, InstallException {
        URL url = request.getParsedURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        this.configureConnectionForRequest(connection, request);
        int responseCode = connection.getResponseCode();
        if (responseCode == -1) {
            throw new IOException("Could not retrieve response code from HttpUrlConnection.");
        }
        StatusLine responseStatus = new StatusLine(connection.getResponseCode(), connection.getResponseMessage());
        HttpResponse response = new HttpResponse(responseStatus);
        boolean isContentGzipd = false;
        for (Map.Entry<String, List<String>> header : connection.getHeaderFields().entrySet()) {
            if (header.getKey() == null) continue;
            if (header.getKey().equals("Content-Encoding") && header.getValue().get(0).equalsIgnoreCase("gzip")) {
                isContentGzipd = true;
            }
            Header h = new Header(header.getKey(), header.getValue().get(0));
            response.addHeader(h);
        }
        response.setEntity(HurlStack.entityFromConnection(connection, isContentGzipd));
        return response;
    }

    private static HttpEntity entityFromConnection(HttpURLConnection connection, boolean isContentGzipd) {
        InputStream inputStream;
        HttpEntity entity = new HttpEntity();
        try {
            inputStream = isContentGzipd ? new GZIPInputStream(new BufferedInputStream(connection.getInputStream())) : new BufferedInputStream(connection.getInputStream());
        }
        catch (IOException ioe) {
            inputStream = connection.getErrorStream();
        }
        entity.setContent(inputStream);
        entity.setContentLength(connection.getContentLength());
        entity.setContentEncoding(connection.getContentEncoding());
        entity.setContentType(connection.getContentType());
        return entity;
    }

    private void configureConnectionForRequest(HttpURLConnection connection, Request request) throws InstallException, IOException {
        Map<String, String> headerMap = request.getHeaders();
        for (String headerName : headerMap.keySet()) {
            connection.addRequestProperty(headerName, headerMap.get(headerName));
        }
        connection.setConnectTimeout(request.getConnectTimeout());
        connection.setReadTimeout(request.getReadTimeout());
        connection.setUseCaches(request.isUsingCache());
        connection.setDoInput(request.isDoInput());
        connection.setRequestProperty("User-Agent", request.getUserAgent());
        connection.setRequestMethod(request.getMethodString());
        if (request.getMethod() == 1) {
            connection.setDoOutput(request.isDoOutput());
            connection.setRequestProperty("Content-type", request.getContentType());
            OutputStream outputStream = connection.getOutputStream();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
            writer.write(request.getPOSTParametersQuery());
            writer.flush();
            writer.close();
            outputStream.close();
        }
    }
}

