/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network.request;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import com.helpshift.exceptions.InstallException;
import com.helpshift.model.InfoModelFactory;
import com.helpshift.network.NameValuePair;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.response.NetworkResponse;
import com.helpshift.network.response.Response;
import com.helpshift.network.response.ResponseParser;
import com.helpshift.network.util.HeaderUtil;
import com.helpshift.network.util.constants.NetworkConstants;
import com.helpshift.util.SchemaUtil;
import com.helpshift.util.SecurityUtil;
import com.helpshift.util.StringUtil;
import com.helpshift.util.TimeUtil;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class Request {
    private static final String TAG = "HelpshiftDebug";
    private static AtomicInteger sequenceGenerator = new AtomicInteger();
    private final int method;
    private final String url;
    private final Response.ErrorListener errorListener;
    private Future task;
    private Integer sequence;
    private boolean responseDelivered = false;
    private Map<String, String> requestData;
    private Response.Listener listener;
    private ResponseParser responseParser;

    public <T> Request(int method, String url, Map<String, String> requestData, Response.Listener<T> listener, Response.ErrorListener errorListener, ResponseParser<T> responseParser) {
        this.method = method;
        this.url = this.sanitiseUrl(url);
        this.listener = listener;
        this.errorListener = errorListener;
        this.requestData = requestData;
        this.sequence = sequenceGenerator.incrementAndGet();
        this.responseParser = responseParser;
    }

    public Map<String, String> getRequestData() {
        return this.requestData;
    }

    public Request setFutureTask(Future requestTask) {
        this.task = requestTask;
        return this;
    }

    private String sanitiseUrl(String url) {
        String sanitisedUrl = url;
        if (!url.startsWith("/")) {
            sanitisedUrl = "/" + url;
        }
        return sanitisedUrl;
    }

    public int getMethod() {
        return this.method;
    }

    public String getMethodString() {
        switch (this.method) {
            case 0: {
                return "GET";
            }
            case 1: {
                return "POST";
            }
        }
        return "";
    }

    public int getSequence() {
        if (this.sequence == null) {
            throw new IllegalStateException("getSequence called before setSequence");
        }
        return this.sequence;
    }

    public Map<String, String> getHeaders() {
        Map<String, String> headers = HeaderUtil.getCommonHeaders();
        if (this.method == 0) {
            String etag = InfoModelFactory.getInstance().sdkInfoModel.getEtag(this.url);
            if (!TextUtils.isEmpty((CharSequence)etag)) {
                headers.put("If-None-Match", etag);
            }
        } else if (this.method == 1) {
            headers.put("Content-type", "application/x-www-form-urlencoded");
        }
        return headers;
    }

    public String getUrl() {
        return this.url;
    }

    private String getApiUri() {
        return NetworkConstants.getApiBase() + NetworkConstants.getApiVersion() + this.url;
    }

    public String getFullUri() throws InstallException {
        if (!InfoModelFactory.getInstance().appInfoModel.isInstalled()) {
            throw new InstallException("Install information missing");
        }
        return NetworkConstants.getScheme() + InfoModelFactory.getInstance().appInfoModel.getDomainName() + this.getApiUri();
    }

    public URL getParsedURL() throws InstallException, MalformedURLException {
        String url = this.getFullUri();
        if (this.method == 0) {
            url = url + "?" + this.encodeGetParameters(this.addAuth());
        }
        return new URL(url);
    }

    private Map<String, String> addAuth() throws InstallException {
        String uriStr = this.getApiUri();
        HashMap<Object, Object> data = this.requestData != null ? new HashMap<String, String>(this.requestData) : new HashMap();
        if (!InfoModelFactory.getInstance().appInfoModel.isInstalled()) {
            throw new InstallException("appId Missing");
        }
        data.put("platform-id", InfoModelFactory.getInstance().appInfoModel.getPlatformId());
        data.put("method", this.getMethodString());
        data.put("uri", uriStr);
        String ts = TimeUtil.getCurrentTimestamp();
        if (SchemaUtil.validateTimestamp(ts)) {
            data.put("timestamp", ts);
        }
        ArrayList mapKeys = new ArrayList(data.keySet());
        ArrayList<String> dataList = new ArrayList<String>();
        Collections.sort(mapKeys);
        for (String key : mapKeys) {
            String dataString;
            if (key.equals("screenshot") || key.equals("meta") || (dataString = StringUtil.toString(data.get(key))) == null) continue;
            dataList.add(key + "=" + dataString);
        }
        try {
            data.put("signature", SecurityUtil.getSignature(TextUtils.join((CharSequence)"&", dataList)));
            data.remove("method");
            data.remove("uri");
        }
        catch (GeneralSecurityException e) {
            Log.d((String)TAG, (String)("Could not generate signature: " + e.getLocalizedMessage()), (Throwable)e);
            return data;
        }
        return data;
    }

    private String encodeGetParameters(Map<String, String> inputParams) {
        ArrayList<String> dataList = new ArrayList<String>();
        ArrayList<String> mapKeys = new ArrayList<String>(inputParams.keySet());
        for (String key : mapKeys) {
            dataList.add(key + "=" + Uri.encode((String)inputParams.get(key)));
        }
        return TextUtils.join((CharSequence)"&", dataList);
    }

    private List<NameValuePair> encodePostParameters(Map<String, String> inputParams) {
        ArrayList<String> mapKeys = new ArrayList<String>(inputParams.keySet());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(mapKeys.size());
        for (String key : mapKeys) {
            String dataString = StringUtil.toString(inputParams.get(key));
            if (dataString == null) continue;
            params.add(new NameValuePair(key, dataString));
        }
        return params;
    }

    public String getPOSTParametersQuery() throws InstallException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        List<NameValuePair> params = this.encodePostParameters(this.addAuth());
        for (NameValuePair pair : params) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            try {
                result.append(URLEncoder.encode(pair.getName(), "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(pair.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Log.d((String)TAG, (String)"Exception Unsupported Encoding", (Throwable)e);
            }
        }
        return result.toString();
    }

    public void markDelivered() {
        this.responseDelivered = true;
    }

    public boolean hasHadResponseDelivered() {
        return this.responseDelivered;
    }

    protected <T> Response<T> parseNetworkResponse(NetworkResponse response) {
        ResponseParser typedParser = this.responseParser;
        return typedParser.parseResponse(response);
    }

    protected NetworkError parseNetworkError(NetworkError networkError) {
        return networkError;
    }

    public <T> void deliverResponse(T response) {
        Response.Listener typedListener = this.listener;
        typedListener.onResponse(response, this.getSequence());
    }

    public void deliverError(NetworkError error) {
        if (this.errorListener != null) {
            this.errorListener.onErrorResponse(error, this.getSequence());
        }
    }

    public int getConnectTimeout() {
        return 5000;
    }

    public int getReadTimeout() {
        return 5000;
    }

    public boolean isUsingCache() {
        return false;
    }

    public boolean isDoInput() {
        return true;
    }

    public boolean isDoOutput() {
        return this.method == 1;
    }

    public String getUserAgent() {
        return NetworkConstants.getUserAgent();
    }

    public String getContentType() {
        return NetworkConstants.getContentType();
    }

    public String toString() {
        return this.url + " " + TAG + " " + " " + this.sequence;
    }

    public static interface Method {
        public static final int GET = 0;
        public static final int POST = 1;
    }
}

