/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network.request;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.util.Log;
import com.helpshift.network.Network;
import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.request.Request;
import com.helpshift.network.response.ExecutorDelivery;
import com.helpshift.network.response.NetworkResponse;
import com.helpshift.network.response.Response;
import com.helpshift.network.response.ResponseDelivery;
import com.helpshift.network.util.constants.NetworkConstants;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class RequestQueue {
    private static final String TAG = "HelpshiftDebug";
    private final Network network;
    private final ResponseDelivery delivery;
    private ExecutorService dispatcherPool;

    protected RequestQueue(Network network, ResponseDelivery delivery, ExecutorService dispatcherPool) {
        this.network = network;
        this.dispatcherPool = dispatcherPool;
        this.delivery = delivery;
    }

    public static RequestQueue getRequestQueue(Network network, Integer deliveryType, ExecutorService dispatcherPool) {
        ExecutorDelivery delivery;
        if (DeliveryType.ON_NEW_THREAD.equals(deliveryType)) {
            HandlerThread networkHandlerThread = new HandlerThread("ResponseThread");
            networkHandlerThread.start();
            Looper networkLooper = networkHandlerThread.getLooper();
            Handler networkHandler = new Handler(networkLooper);
            delivery = new ExecutorDelivery(networkHandler);
        } else {
            delivery = new ExecutorDelivery(new Handler(Looper.getMainLooper()));
        }
        return new RequestQueue(network, delivery, dispatcherPool);
    }

    public Future add(final Request request) {
        return this.dispatcherPool.submit(new Callable(){

            public Object call() throws Exception {
                try {
                    NetworkResponse networkResponse = RequestQueue.this.network.performRequest(request);
                    if (networkResponse.isNotModified()) {
                        if (request.hasHadResponseDelivered()) {
                            return null;
                        }
                        throw new NetworkError(NetworkConstants.ErrorCodes.CONTENT_UNCHANGED);
                    }
                    Response response = request.parseNetworkResponse(networkResponse);
                    RequestQueue.this.delivery.postResponse(request, response);
                    return response;
                }
                catch (NetworkError networkError) {
                    RequestQueue.this.parseAndDeliverNetworkError(request, networkError);
                    return networkError;
                }
            }
        });
    }

    protected void parseAndDeliverNetworkError(Request request, NetworkError error) {
        error = request.parseNetworkError(error);
        this.delivery.postError(request, error);
    }

    public void shutdown(boolean awaitTermination) {
        this.dispatcherPool.shutdown();
        if (awaitTermination) {
            try {
                this.dispatcherPool.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Log.d((String)TAG, (String)"Pool shutdown interrupted :", (Throwable)e);
            }
        }
    }

    public static class DeliveryType {
        public static final Integer ON_MAIN_THREAD = 0;
        public static final Integer ON_NEW_THREAD = 1;
    }
}

