/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network.response;

import com.helpshift.network.errors.NetworkError;
import com.helpshift.network.response.NetworkResponse;
import com.helpshift.network.response.Response;
import com.helpshift.network.response.ResponseParser;
import com.helpshift.network.util.HttpHeaderParser;
import com.helpshift.network.util.constants.NetworkConstants;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonObjectResponseParser
implements ResponseParser<JSONObject> {
    @Override
    public Response<JSONObject> parseResponse(NetworkResponse response) {
        try {
            String jsonString = new String(response.getData(), HttpHeaderParser.parseCharset(response.getHeaders(), "utf-8"));
            return Response.success(new JSONObject(jsonString), response.getRequestIdentifier());
        }
        catch (UnsupportedEncodingException e) {
            return Response.error(new NetworkError(NetworkConstants.ErrorCodes.PARSE_ERROR, (Throwable)e), response.getRequestIdentifier());
        }
        catch (JSONException je) {
            return Response.error(new NetworkError(NetworkConstants.ErrorCodes.PARSE_ERROR, (Throwable)je), response.getRequestIdentifier());
        }
    }
}

