/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class ByteArrayPool {
    private List<byte[]> buffersByLastUse = new LinkedList<byte[]>();
    private List<byte[]> buffersBySize = new ArrayList<byte[]>(64);
    private int currentSize = 0;
    private final int sizeLimit;
    protected static final Comparator<byte[]> BUF_COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] lhs, byte[] rhs) {
            return lhs.length - rhs.length;
        }
    };

    public ByteArrayPool(int sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public synchronized byte[] getBuf(int len) {
        for (int i = 0; i < this.buffersBySize.size(); ++i) {
            byte[] buf = this.buffersBySize.get(i);
            if (buf.length < len) continue;
            this.currentSize -= buf.length;
            this.buffersBySize.remove(i);
            this.buffersByLastUse.remove(buf);
            return buf;
        }
        return new byte[len];
    }

    public synchronized void returnBuf(byte[] buf) {
        if (buf == null || buf.length > this.sizeLimit) {
            return;
        }
        this.buffersByLastUse.add(buf);
        int pos = Collections.binarySearch(this.buffersBySize, buf, BUF_COMPARATOR);
        if (pos < 0) {
            pos = -pos - 1;
        }
        this.buffersBySize.add(pos, buf);
        this.currentSize += buf.length;
        this.trim();
    }

    private synchronized void trim() {
        while (this.currentSize > this.sizeLimit) {
            byte[] buf = this.buffersByLastUse.remove(0);
            this.buffersBySize.remove(buf);
            this.currentSize -= buf.length;
        }
    }
}

