/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.network.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadFactoryBuilder {
    private String name = null;
    private boolean daemon = false;
    private int priority = 5;

    public ThreadFactoryBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public ThreadFactoryBuilder setPriority(int priority) {
        if (priority > 10) {
            priority = 10;
        } else if (priority < 1) {
            priority = 1;
        }
        this.priority = priority;
        return this;
    }

    public ThreadFactory build() {
        return ThreadFactoryBuilder.build(this);
    }

    private static ThreadFactory build(ThreadFactoryBuilder builder) {
        final String namePrefix = builder.name;
        final Boolean daemon = builder.daemon;
        final Integer priority = builder.priority;
        final AtomicLong count = new AtomicLong(0L);
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                if (namePrefix != null) {
                    thread.setName(namePrefix + "-" + count.getAndIncrement());
                }
                thread.setDaemon(daemon);
                thread.setPriority(priority);
                return thread;
            }
        };
    }
}

