/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.storage;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import android.util.Log;
import com.helpshift.storage.KeyValueDbStorageHelper;
import com.helpshift.storage.KeyValueStorage;
import com.helpshift.util.ByteArrayUtil;
import com.helpshift.util.DBUtil;
import com.helpshift.util.DatabaseUtils;
import com.helpshift.util.HelpshiftContext;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KeyValueDbStorage
implements KeyValueStorage {
    private static final String TAG = "HelpshiftDebug";
    private static final String backupFileName = "__hs__kv_backup";
    private final KeyValueDbStorageHelper helper = new KeyValueDbStorageHelper(HelpshiftContext.getApplicationContext());
    private SQLiteDatabase database;
    private HashMap<String, Serializable> backupData = DBUtil.restoreHashMap("__hs__kv_backup");

    public KeyValueDbStorage() {
        if (this.backupData == null) {
            this.backupData = new HashMap();
        } else {
            for (Map.Entry<String, Serializable> entry : this.backupData.entrySet()) {
                this.set(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setWithBackup(String key, Serializable value) {
        if (this.set(key, value)) {
            KeyValueDbStorageHelper keyValueDbStorageHelper = this.helper;
            synchronized (keyValueDbStorageHelper) {
                this.backupData.put(key, value);
                DBUtil.backupHashMap(backupFileName, this.backupData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean set(String key, Serializable value) {
        if (TextUtils.isEmpty((CharSequence)key) || value == null) {
            return false;
        }
        boolean setValue = false;
        KeyValueDbStorageHelper keyValueDbStorageHelper = this.helper;
        synchronized (keyValueDbStorageHelper) {
            this.write();
            this.database.beginTransaction();
            String whereClause = "key=?";
            String[] whereArgs = new String[]{key};
            try {
                ContentValues values = new ContentValues();
                values.put("key", key);
                values.put("value", ByteArrayUtil.toByteArray(value));
                if (DatabaseUtils.exists(this.database, "key_value_store", whereClause, whereArgs)) {
                    this.database.update("key_value_store", values, whereClause, whereArgs);
                } else {
                    this.database.insert("key_value_store", null, values);
                }
                setValue = true;
            }
            catch (IOException ioException) {
                Log.d((String)TAG, (String)"IOException in clearing data : ", (Throwable)ioException);
            }
            finally {
                this.database.setTransactionSuccessful();
                this.database.endTransaction();
                this.close();
            }
        }
        return setValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        Object value = null;
        KeyValueDbStorageHelper keyValueDbStorageHelper = this.helper;
        synchronized (keyValueDbStorageHelper) {
            this.read();
            String whereClause = "key=?";
            String[] whereArgs = new String[]{key};
            Cursor cursor = this.database.query("key_value_store", null, whereClause, whereArgs, null, null, null);
            if (cursor.moveToFirst()) {
                try {
                    value = ByteArrayUtil.toObject(cursor.getBlob(1));
                }
                catch (Exception exception) {
                    value = null;
                }
            }
            cursor.close();
            this.close();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllKeys() {
        ArrayList<String> keys = new ArrayList<String>();
        KeyValueDbStorageHelper keyValueDbStorageHelper = this.helper;
        synchronized (keyValueDbStorageHelper) {
            this.read();
            Cursor cursor = this.database.query("key_value_store", new String[]{"key"}, null, null, null, null, null);
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    keys.add(cursor.getString(0));
                    cursor.moveToNext();
                }
            }
            cursor.close();
            this.close();
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeKey(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        KeyValueDbStorageHelper keyValueDbStorageHelper = this.helper;
        synchronized (keyValueDbStorageHelper) {
            this.write();
            this.database.beginTransaction();
            String whereClause = "key=?";
            String[] whereArgs = new String[]{key};
            if (DatabaseUtils.exists(this.database, "key_value_store", whereClause, whereArgs)) {
                this.database.delete("key_value_store", whereClause, whereArgs);
            }
            this.database.setTransactionSuccessful();
            this.database.endTransaction();
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllKeys() {
        KeyValueDbStorageHelper keyValueDbStorageHelper = this.helper;
        synchronized (keyValueDbStorageHelper) {
            this.write();
            this.database.beginTransaction();
            this.database.delete("key_value_store", null, null);
            this.database.setTransactionSuccessful();
            this.database.endTransaction();
            this.close();
        }
    }

    public void read() {
        this.database = this.helper.getReadableDatabase();
    }

    public void write() {
        this.database = this.helper.getWritableDatabase();
    }

    public void close() {
        this.database.close();
    }
}

