/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.content.Context;
import android.text.TextUtils;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSStorage;
import com.helpshift.support.SupportInternal;
import java.util.HashMap;

public final class ContactUsFilter {
    private static HSApiData data;
    private static HSStorage storage;
    private static Integer enableContactUs;

    private ContactUsFilter() {
    }

    public static void init(Context context) {
        if (data == null) {
            data = new HSApiData(context);
            storage = ContactUsFilter.data.storage;
        }
    }

    protected static void setConfig(HashMap configMap) {
        Object enableContactUsObj;
        if (configMap == null) {
            configMap = new HashMap();
        }
        if ((enableContactUsObj = configMap.get("enableContactUs")) instanceof Integer) {
            enableContactUs = (Integer)configMap.get("enableContactUs");
        } else if (enableContactUsObj instanceof Boolean) {
            enableContactUs = (Boolean)enableContactUsObj != false ? SupportInternal.EnableContactUs.ALWAYS : SupportInternal.EnableContactUs.NEVER;
        }
    }

    public static boolean showContactUs(LOCATION location) {
        switch (location) {
            case SEARCH_RESULT_ACTIVITY_HEADER: {
                return false;
            }
        }
        if (enableContactUs.equals(SupportInternal.EnableContactUs.ALWAYS)) {
            return true;
        }
        if (enableContactUs.equals(SupportInternal.EnableContactUs.NEVER)) {
            return false;
        }
        if (enableContactUs.equals(SupportInternal.EnableContactUs.AFTER_VIEWING_FAQS)) {
            switch (location) {
                case SEARCH_FOOTER: {
                    return true;
                }
                case QUESTION_FOOTER: {
                    return true;
                }
                case QUESTION_ACTION_BAR: {
                    return true;
                }
                case ACTION_BAR: {
                    String activeConversation = storage.getActiveConversation(data.getProfileId());
                    String archivedConversation = storage.getArchivedConversation(data.getProfileId());
                    return !TextUtils.isEmpty((CharSequence)activeConversation) || !TextUtils.isEmpty((CharSequence)archivedConversation);
                }
            }
            return true;
        }
        if (enableContactUs.equals(SupportInternal.EnableContactUs.AFTER_MARKING_ANSWER_UNHELPFUL)) {
            switch (location) {
                case SEARCH_FOOTER: {
                    return false;
                }
                case QUESTION_FOOTER: {
                    return true;
                }
                case QUESTION_ACTION_BAR: 
                case ACTION_BAR: {
                    String activeConversation = storage.getActiveConversation(data.getProfileId());
                    String archivedConversation = storage.getArchivedConversation(data.getProfileId());
                    return !TextUtils.isEmpty((CharSequence)activeConversation) || !TextUtils.isEmpty((CharSequence)archivedConversation);
                }
            }
            return true;
        }
        return true;
    }

    static {
        enableContactUs = SupportInternal.EnableContactUs.ALWAYS;
    }

    public static enum LOCATION {
        ACTION_BAR,
        SEARCH_FOOTER,
        QUESTION_FOOTER,
        QUESTION_ACTION_BAR,
        SEARCH_RESULT_ACTIVITY_HEADER;

    }
}

