/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.helpshift.support.DownloadTask;
import com.helpshift.support.DownloadTaskCallBacks;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSStorage;
import com.helpshift.support.Log;
import com.helpshift.util.HelpshiftContext;
import java.io.File;
import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;

public class DownloadManager {
    public static final String TAG = "HelpShiftDebug";
    static final int DOWNLOAD_FAILED = -1;
    static final int DOWNLOAD_STARTED = 1;
    static final int DOWNLOAD_PAUSED = 2;
    static final int DOWNLOAD_RESUMED = 3;
    static final int DOWNLOAD_COMPLETE = 4;
    static final int PROGRESS_CHANGED = 5;
    public static final int GENERIC = 6;
    public static final int IMAGE = 7;
    public static final int THUMBNAIL = 8;
    private static final int KEEP_ALIVE_TIME = 1;
    private static final TimeUnit KEEP_ALIVE_TIME_UNIT = TimeUnit.SECONDS;
    private static final int CORE_POOL_SIZE = 5;
    private static final int MAXIMUM_POOL_SIZE = 5;
    private final BlockingQueue<DownloadTask> downloadTasksQueue = new LinkedBlockingQueue<DownloadTask>();
    private final BlockingQueue<Runnable> downloadRunnableQueue = new LinkedBlockingQueue<Runnable>();
    private final ThreadPoolExecutor downloadThreadPool = new ThreadPoolExecutor(5, 5, 1L, KEEP_ALIVE_TIME_UNIT, this.downloadRunnableQueue);
    private Handler handler;
    private HSApiData hsApiData;
    private HSStorage hsStorage;
    private static DownloadTaskCallBacks downloadTaskCallBacks;

    public DownloadManager(Context context) {
        this.hsApiData = new HSApiData(context);
        this.hsStorage = this.hsApiData.storage;
        this.handler = new Handler(Looper.getMainLooper()){

            public void handleMessage(Message msg) {
                DownloadTask task = (DownloadTask)msg.obj;
                switch (msg.what) {
                    case 1: {
                        break;
                    }
                    case 5: {
                        if (downloadTaskCallBacks == null) break;
                        downloadTaskCallBacks.onProgressChanged(task.getProgress(), msg.arg1, task.getMsgId(), task.getIssueId(), task.getDownloadType());
                        break;
                    }
                    case 2: {
                        if (downloadTaskCallBacks == null) break;
                        downloadTaskCallBacks.onDownloadTaskPaused(msg.arg1, task.getMsgId(), task.getIssueId(), task.getDownloadType());
                        break;
                    }
                    case 3: {
                        if (downloadTaskCallBacks == null) break;
                        downloadTaskCallBacks.onDownloadTaskResumed(msg.arg1, task.getMsgId(), task.getIssueId(), task.getDownloadType());
                        break;
                    }
                    case 4: {
                        DownloadManager.this.removeFromCache(task.getMsgId());
                        if (downloadTaskCallBacks != null) {
                            downloadTaskCallBacks.onDownloadTaskComplete(task.getDownloadedFilePath(), msg.arg1, task.getMsgId(), task.getIssueId(), task.getDownloadType());
                        }
                        DownloadManager.this.recycleTask(task);
                        break;
                    }
                    case -1: {
                        if (downloadTaskCallBacks != null) {
                            downloadTaskCallBacks.onDownloadTaskFailed(msg.arg1, task.getMsgId(), task.getIssueId(), task.getDownloadType());
                        }
                        DownloadManager.this.recycleTask(task);
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }
        };
    }

    public static synchronized DownloadManager getInstance() {
        return Holder.INSTANCE;
    }

    public void handleState(DownloadTask downloadTask, int state, int position) {
        switch (state) {
            case 2: {
                Message msg = this.handler.obtainMessage(state, position, 0, (Object)downloadTask);
                msg.sendToTarget();
                break;
            }
            case 3: {
                Message msg = this.handler.obtainMessage(state, position, 0, (Object)downloadTask);
                msg.sendToTarget();
                break;
            }
            case 4: {
                Message msg = this.handler.obtainMessage(state, position, 0, (Object)downloadTask);
                msg.sendToTarget();
                break;
            }
            case 5: {
                Message msg = this.handler.obtainMessage(state, position, 0, (Object)downloadTask);
                msg.sendToTarget();
                break;
            }
            default: {
                this.handler.obtainMessage(state, position, 0, (Object)downloadTask).sendToTarget();
            }
        }
    }

    public static DownloadTask startDownload(JSONObject attachment, int position, String msgId, String issueId, int downloadType) {
        DownloadManager.getInstance().hsStorage.addToActiveDownloads(msgId, issueId);
        DownloadTask downloadTask = (DownloadTask)DownloadManager.getInstance().downloadTasksQueue.poll();
        if (downloadTask == null) {
            downloadTask = new DownloadTask();
        }
        downloadTask.initializeDownloaderTask(DownloadManager.getInstance(), attachment, position, msgId, issueId, downloadType);
        try {
            JSONObject cachedFiles = DownloadManager.getInstance().getCachedAttachmentFiles();
            if (cachedFiles.has(msgId)) {
                downloadTask.setTempFile(new File(cachedFiles.getString(msgId)));
            } else {
                DownloadManager.getInstance().addToCache(msgId, downloadTask.getTempFile().getAbsolutePath());
            }
        }
        catch (JSONException e) {
            Log.d(TAG, "Exception JSON", e);
        }
        if (downloadTask.getDownloadState() == 0 || downloadTask.getDownloadState() == 2) {
            DownloadManager.getInstance().downloadThreadPool.execute(downloadTask.getDownloadRunnable());
        } else {
            DownloadManager.getInstance().handleState(downloadTask, downloadTask.getDownloadState(), position);
        }
        return downloadTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeDownload(DownloadTask downloadTask, URL url, int position) {
        if (downloadTask != null && downloadTask.getDownloadUrl().equals(url)) {
            DownloadManager downloadManager = DownloadManager.getInstance();
            synchronized (downloadManager) {
                Thread thread = downloadTask.getCurrentThread();
                if (thread != null) {
                    thread.interrupt();
                }
            }
            downloadTask.getTempFile().delete();
            DownloadManager.getInstance().removeFromCache(downloadTask.getMsgId());
            DownloadManager.getInstance().downloadThreadPool.remove(downloadTask.getDownloadRunnable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pauseDownload(DownloadTask downloadTask, URL url, int position) {
        if (downloadTask != null && downloadTask.getDownloadUrl().equals(url)) {
            DownloadManager downloadManager = DownloadManager.getInstance();
            synchronized (downloadManager) {
                Thread thread = downloadTask.getCurrentThread();
                if (thread != null) {
                    downloadTask.setDownloadState(1);
                    thread.interrupt();
                }
                DownloadManager.getInstance().downloadThreadPool.remove(downloadTask.getDownloadRunnable());
                DownloadManager.getInstance().handleState(downloadTask, 2, position);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resumeDownload(DownloadTask downloadTask, URL url, int position) {
        if (downloadTask != null && downloadTask.getDownloadUrl().equals(url)) {
            DownloadManager downloadManager = DownloadManager.getInstance();
            synchronized (downloadManager) {
                downloadTask.setDownloadState(2);
                DownloadManager.getInstance().downloadThreadPool.execute(downloadTask.getDownloadRunnable());
                DownloadManager.getInstance().handleState(downloadTask, 3, position);
            }
        }
    }

    void recycleTask(DownloadTask downloadTask) {
        downloadTask.recycle();
        this.downloadTasksQueue.offer(downloadTask);
    }

    private JSONObject getCachedAttachmentFiles() {
        return this.hsStorage.getCachedAttachmentFiles();
    }

    private void removeFromCache(String msgId) {
        this.hsStorage.removeFromCachedAttachmentFiles(msgId);
    }

    private void addToCache(String msgId, String path) {
        this.hsStorage.addToCachedAttachmentFiles(msgId, path);
    }

    public static void registerDownloadTaskCallbacks(DownloadTaskCallBacks callBacks) {
        downloadTaskCallBacks = callBacks;
    }

    public static void deregisterDownloadTaskCallBacks() {
        downloadTaskCallBacks = null;
    }

    public static DownloadTaskCallBacks getDownloadTaskCallBacks() {
        return downloadTaskCallBacks;
    }

    private static class Holder {
        private static final DownloadManager INSTANCE = new DownloadManager(HelpshiftContext.getApplicationContext());

        private Holder() {
        }
    }
}

