/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.os.Build;
import android.os.Process;
import android.util.Log;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class DownloadRunnable
implements Runnable {
    static final String TAG = "HelpShiftDebug";
    static final int HTTP_STATE_FAILED = -1;
    static final int HTTP_STATE_STARTED = 0;
    static final int HTTP_STATE_PAUSED = 1;
    static final int HTTP_STATE_RESUMED = 2;
    static final int HTTP_STATE_COMPLETED = 3;
    static final int PROGRESS_CHANGED = 4;
    final DownloadRunnableMethods downloadTask;
    String userAgent = "Helpshift-Android/4.2.0/" + Build.VERSION.RELEASE;
    byte[] byteBuffer;
    private long downloadedBytes;
    private long totalBytes;

    public DownloadRunnable(DownloadRunnableMethods downloadTask) {
        this.downloadTask = downloadTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block27: {
            this.downloadTask.setDownloadThread(Thread.currentThread());
            Process.setThreadPriority((int)10);
            try {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                HttpURLConnection httpURLConnection = (HttpURLConnection)this.downloadTask.getDownloadUrl().openConnection();
                httpURLConnection.setRequestProperty("User-Agent", this.userAgent);
                File file = this.downloadTask.getTempFile();
                this.downloadedBytes = file.length();
                httpURLConnection.setRequestProperty("Range", "bytes=" + this.downloadedBytes + "-");
                this.downloadTask.handleDownloadState(this.downloadTask.getDownloadState());
                if (this.downloadTask.getDownloadState() != 0 && this.downloadTask.getDownloadState() != 2) break block27;
                InputStream byteStream = null;
                FileOutputStream fos = null;
                try {
                    int readResult;
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    byteStream = httpURLConnection.getInputStream();
                    if (Thread.interrupted()) {
                        throw new InterruptedException();
                    }
                    int contentSize = httpURLConnection.getContentLength();
                    this.totalBytes = this.downloadTask.getFileSize();
                    fos = new FileOutputStream(file, true);
                    this.byteBuffer = new byte[1024];
                    while ((readResult = byteStream.read(this.byteBuffer, 0, 1024)) != -1) {
                        if (readResult < 0) {
                            throw new EOFException();
                        }
                        fos.write(this.byteBuffer, 0, readResult);
                        this.downloadedBytes = file.length();
                        double progress = (double)this.downloadedBytes / (double)this.totalBytes * 10000.0;
                        this.downloadTask.setProgress(progress);
                        this.downloadTask.handleDownloadState(4);
                        if (!Thread.interrupted()) continue;
                        throw new InterruptedException();
                    }
                    if (this.downloadTask.getDownloadState() == 0 || this.downloadTask.getDownloadState() == 2) {
                        this.copy(this.downloadTask.getTempFile(), this.downloadTask.getFinalFile());
                        this.downloadTask.getTempFile().delete();
                        String filePath = this.downloadTask.getFinalFile().getAbsolutePath();
                        this.downloadTask.setDownloadedFilePath(filePath);
                        this.byteBuffer = null;
                        this.downloadTask.setDownloadThread(null);
                        Thread.interrupted();
                        this.downloadTask.setDownloadState(3);
                        this.downloadTask.handleDownloadState(3);
                    }
                }
                catch (IOException e) {
                    this.downloadTask.setDownloadState(-1);
                    Log.d((String)TAG, (String)"Exception IO", (Throwable)e);
                }
                finally {
                    if (byteStream != null) {
                        try {
                            byteStream.close();
                        }
                        catch (IOException e) {
                            this.downloadTask.setDownloadState(-1);
                            Log.d((String)TAG, (String)"Exception IO", (Throwable)e);
                        }
                    }
                    httpURLConnection.disconnect();
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            catch (InterruptedException e) {
                this.downloadTask.setDownloadState(-1);
                Log.d((String)TAG, (String)"Exception Interrupted", (Throwable)e);
            }
            catch (IOException e) {
                this.downloadTask.setDownloadState(-1);
                Log.d((String)TAG, (String)"Exception IO", (Throwable)e);
            }
            finally {
                if (this.downloadTask.getDownloadState() == -1) {
                    this.downloadTask.handleDownloadState(-1);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File src, File dst) {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = new FileInputStream(src);
            out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (FileNotFoundException e) {
            Log.d((String)TAG, (String)"Exception File Not Found", (Throwable)e);
        }
        catch (IOException e) {
            Log.d((String)TAG, (String)"Exception IO", (Throwable)e);
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
            }
            catch (IOException e) {}
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e) {}
        }
    }

    static interface DownloadRunnableMethods {
        public void setDownloadThread(Thread var1);

        public void handleDownloadState(int var1);

        public int getDownloadState();

        public void setDownloadState(int var1);

        public URL getDownloadUrl();

        public int getFileSize();

        public File getTempFile();

        public File getFinalFile();

        public void setDownloadedFilePath(String var1);

        public void setProgress(double var1);
    }
}

