/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.os.Environment;
import com.helpshift.support.DownloadManager;
import com.helpshift.support.DownloadRunnable;
import com.helpshift.support.DownloadTaskCallBacks;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSStorage;
import com.helpshift.support.Log;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HelpshiftContext;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONObject;

public class DownloadTask
implements DownloadRunnable.DownloadRunnableMethods {
    public static final String TAG = "HelpShiftDebug";
    private URL downloadURL;
    private URL thumbnailUrl;
    private String fileName;
    private String contentType;
    private String fileType;
    private int size;
    private long height;
    private long width;
    private double progress;
    private int position;
    private String msgId;
    private String issueId;
    private int downloadType;
    Thread currentThread;
    private int downloadState;
    private String downloadedFilePath;
    private DownloadTaskCallBacks downloadTaskCallBacks;
    private HSApiData hsApiData;
    private HSStorage hsStorage;
    private Runnable downloadRunnable = new DownloadRunnable(this);
    private final int TEMP_FILE = 0;
    private final int FINAL_FILE = 1;
    private File tempFile;
    private File finalFile;
    private static DownloadManager downloadManager;

    DownloadTask() {
        downloadManager = DownloadManager.getInstance();
    }

    void initializeDownloaderTask(DownloadManager downloadManager, JSONObject attachment, int position, String msgId, String issueId, int downloadType) {
        try {
            DownloadTask.downloadManager = downloadManager;
            this.downloadTaskCallBacks = DownloadManager.getDownloadTaskCallBacks();
            this.hsApiData = new HSApiData(HelpshiftContext.getApplicationContext());
            this.hsStorage = this.hsApiData.storage;
            this.downloadType = downloadType;
            this.downloadURL = new URL(attachment.optString("url", ""));
            this.fileName = attachment.optString("file-name", "");
            if (downloadType == 8) {
                this.downloadURL = this.thumbnailUrl = new URL(attachment.optString("thumbnail", ""));
            }
            this.contentType = attachment.optString("content-type", "");
            String[] split = this.contentType.split("\\/");
            this.fileType = split[split.length - 1];
            this.size = attachment.optInt("size", 0);
            this.downloadState = 0;
            this.tempFile = this.createFile(0);
            this.finalFile = this.createFile(1);
            this.position = position;
            this.msgId = msgId;
            this.issueId = issueId;
        }
        catch (MalformedURLException e) {
            Log.d(TAG, "Exception Malformed URL", e);
        }
    }

    void handleState(int state) {
        downloadManager.handleState(this, state, this.position);
    }

    @Override
    public void setDownloadThread(Thread currentThread) {
        this.setCurrentThread(currentThread);
    }

    @Override
    public void setDownloadedFilePath(String filePath) {
        this.downloadedFilePath = filePath;
    }

    @Override
    public void setProgress(double progress) {
        this.progress = progress;
    }

    @Override
    public void handleDownloadState(int state) {
        int outState;
        switch (state) {
            case 3: {
                this.hsStorage.removeFromActiveDownloads(this.msgId);
                switch (this.downloadType) {
                    case 6: {
                        this.hsStorage.addToDownloadedGenericFiles(this.msgId, this.downloadedFilePath);
                        break;
                    }
                    case 8: {
                        this.hsStorage.addToDownloadedThumbnailFiles(this.msgId, this.downloadedFilePath);
                        break;
                    }
                    case 7: {
                        this.hsStorage.addToDownloadedImageFiles(this.msgId, this.downloadedFilePath);
                        String thumbnailFilePath = this.hsStorage.getFilePathForThumbnail(this.msgId);
                        File file = new File(thumbnailFilePath);
                        if (file.exists()) {
                            file.delete();
                        }
                        this.hsStorage.removeFromDownloadedThumbnailFiles(this.msgId);
                    }
                }
                outState = 4;
                break;
            }
            case -1: {
                this.hsStorage.removeFromActiveDownloads(this.msgId);
                outState = -1;
                break;
            }
            case 2: {
                outState = 3;
                break;
            }
            case 1: {
                outState = 2;
                break;
            }
            case 4: {
                outState = 5;
                break;
            }
            case 0: {
                outState = 1;
                break;
            }
            default: {
                outState = 1;
            }
        }
        this.handleState(outState);
    }

    @Override
    public int getDownloadState() {
        return this.downloadState;
    }

    @Override
    public void setDownloadState(int state) {
        this.downloadState = state;
    }

    @Override
    public URL getDownloadUrl() {
        return this.downloadURL;
    }

    @Override
    public int getFileSize() {
        return this.size;
    }

    @Override
    public File getTempFile() {
        return this.tempFile;
    }

    public void setTempFile(File file) {
        this.tempFile = file;
    }

    @Override
    public File getFinalFile() {
        return this.finalFile;
    }

    public void setFinalFile(File file) {
        this.finalFile = file;
    }

    public double getProgress() {
        return this.progress;
    }

    public String getDownloadedFilePath() {
        return this.downloadedFilePath;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public String getIssueId() {
        return this.issueId;
    }

    public int getDownloadType() {
        return this.downloadType;
    }

    Runnable getDownloadRunnable() {
        return this.downloadRunnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Thread getCurrentThread() {
        DownloadManager downloadManager = DownloadTask.downloadManager;
        synchronized (downloadManager) {
            return this.currentThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCurrentThread(Thread thread) {
        DownloadManager downloadManager = DownloadTask.downloadManager;
        synchronized (downloadManager) {
            this.currentThread = thread;
        }
    }

    protected void recycle() {
        this.downloadedFilePath = null;
        this.tempFile = null;
        this.finalFile = null;
    }

    public DownloadTaskCallBacks getDownloadTaskCallBacks() {
        return this.downloadTaskCallBacks;
    }

    private File createFile(int type) {
        File dir = ApplicationUtil.isPermissionGranted(HelpshiftContext.getApplicationContext(), "android.permission.WRITE_EXTERNAL_STORAGE") ? Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS) : HelpshiftContext.getApplicationContext().getFilesDir();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = null;
        if (dir.canWrite()) {
            String fileName = "";
            switch (type) {
                case 0: {
                    fileName = "Support_Temp_" + System.currentTimeMillis() + this.fileName;
                    file = new File(dir, fileName);
                    break;
                }
                case 1: {
                    fileName = "Support_" + System.currentTimeMillis() + this.fileName;
                    file = new File(dir, fileName);
                }
            }
        }
        return file;
    }
}

