/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.support.v7.widget.CardView;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.helpshift.R;
import com.helpshift.exceptions.IdentityException;
import com.helpshift.support.D;
import com.helpshift.support.Faq;
import com.helpshift.support.HSApiClient;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSFunnel;
import com.helpshift.support.HSSearch;
import com.helpshift.support.HSStorage;
import com.helpshift.support.SupportInternal;
import com.helpshift.support.constants.GetSectionsCallBackStatus;
import com.helpshift.support.contracts.NewConversationListener;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.model.Message;
import com.helpshift.support.res.values.HSConfig;
import com.helpshift.support.storage.IssuesDataSource;
import com.helpshift.support.util.AttachmentUtil;
import com.helpshift.support.util.HSTransliterator;
import com.helpshift.support.util.IdentityFilter;
import com.helpshift.support.util.InputUtil;
import com.helpshift.support.util.Meta;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.support.viewstructs.HSMsg;
import com.helpshift.util.HSPattern;
import com.helpshift.util.HelpshiftContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HSAddIssueFragment
extends MainFragment {
    public static final String TAG = "HelpShiftDebug";
    private Bundle extras;
    private HSStorage hsStorage;
    private HSApiData hsApiData;
    private HSApiClient hsApiClient;
    private TextView desc;
    private EditText userNameField;
    private EditText emailField;
    private String userName;
    private String email;
    private Boolean requireEmail;
    private CardView screenshotContainer;
    private ImageView screenshot;
    private TextView screenshotFileName;
    private TextView screenshotFileSize;
    private String screenshotPath;
    private String issueId;
    private ImageButton clearBtn;
    private HSMsg msgData;
    private boolean sendAnyway = false;
    private boolean searchActivityShown = false;
    private boolean selectImage;
    private SupportInternal.Delegate helpshiftDelegate;
    private boolean selectingScreenshot = false;
    private boolean showAttachScreenshotMenu = true;
    private boolean showStartNewConversationMenu = true;
    private NewConversationListener newConversationListener;
    private ProgressBar progressBar;
    private boolean isChangingConfiguration = false;
    private Handler failureHandler = new Handler(){

        public void handleMessage(android.os.Message msg) {
            super.handleMessage(msg);
            HashMap result = (HashMap)msg.obj;
            Integer status = (Integer)result.get("status");
            if (!HSAddIssueFragment.this.isDetached()) {
                SnackbarUtil.showErrorSnackbar(status, HSAddIssueFragment.this.getView());
            }
            HSAddIssueFragment.this.setIsReportingIssue(false);
        }
    };
    public Handler reportHandler = new Handler(){

        public void handleMessage(android.os.Message msg) {
            try {
                HashMap result = (HashMap)msg.obj;
                JSONObject issue = (JSONObject)result.get("response");
                HSAddIssueFragment.this.issueId = issue.getString("id");
                JSONArray issues = new JSONArray();
                issues.put((Object)issue);
                HSAddIssueFragment.this.hsStorage.setIssuesTs(issue.getString("created_at"), HSAddIssueFragment.this.hsApiData.getProfileId());
                HSAddIssueFragment.this.hsStorage.storeIssues(issues, HSAddIssueFragment.this.hsApiData.getProfileId());
                HSAddIssueFragment.this.hsApiData.setUsername(HSAddIssueFragment.this.userName);
                HSAddIssueFragment.this.hsApiData.setEmail(HSAddIssueFragment.this.email);
                HSAddIssueFragment.this.hsStorage.storeReply("", HSAddIssueFragment.this.hsApiData.getProfileId());
                HSAddIssueFragment.this.hsStorage.storeConversationDetail("", HSAddIssueFragment.this.hsApiData.getLoginId());
                String newConversationMessage = HSAddIssueFragment.this.desc.getText().toString().trim();
                HSAddIssueFragment.this.desc.setText((CharSequence)"");
                HSFunnel.pushEvent("p");
                if (!TextUtils.isEmpty((CharSequence)HSAddIssueFragment.this.screenshotPath)) {
                    HSAddIssueFragment.this.hsStorage.setForegroundIssue(HSAddIssueFragment.this.issueId);
                    HSAddIssueFragment.this.msgData = AttachmentUtil.addAndGetLocalRscMsg(HSAddIssueFragment.this.hsStorage, HSAddIssueFragment.this.issueId, HSAddIssueFragment.this.screenshotPath, true);
                    HSAddIssueFragment.this.hsApiClient.addScMessage(HSAddIssueFragment.this.uploadSuccessHandler, HSAddIssueFragment.this.uploadFailHandler, HSAddIssueFragment.this.hsApiData.getProfileId(), HSAddIssueFragment.this.issueId, "", "sc", ((HSAddIssueFragment)HSAddIssueFragment.this).msgData.id, ((HSAddIssueFragment)HSAddIssueFragment.this).msgData.screenshot);
                } else {
                    HSAddIssueFragment.this.handleExit();
                }
                HSAddIssueFragment.this.hsApiData.startInAppService();
                if (HSAddIssueFragment.this.helpshiftDelegate != null) {
                    HSAddIssueFragment.this.helpshiftDelegate.newConversationStarted(newConversationMessage);
                }
            }
            catch (JSONException e) {
                Log.d((String)HSAddIssueFragment.TAG, (String)e.toString(), (Throwable)e);
            }
        }
    };
    private Handler getLatestIssuesHandler = new Handler(){

        public void handleMessage(android.os.Message msg) {
            HSAddIssueFragment.this.clearScreenshot();
            HSAddIssueFragment.this.handleExit();
        }
    };
    private Handler uploadSuccessHandler = new Handler(){

        public void handleMessage(android.os.Message msg) {
            HashMap result = (HashMap)msg.obj;
            JSONObject message = (JSONObject)result.get("response");
            try {
                JSONObject eventData = new JSONObject();
                eventData.put("type", (Object)"url");
                eventData.put("body", (Object)message.getJSONObject("meta").getJSONArray("attachments").getJSONObject(0).getString("url"));
                eventData.put("id", (Object)HSAddIssueFragment.this.issueId);
                HSFunnel.pushEvent("m", eventData);
                if (HSAddIssueFragment.this.helpshiftDelegate != null) {
                    HSAddIssueFragment.this.helpshiftDelegate.userRepliedToConversation("User sent a screenshot");
                }
                AttachmentUtil.copyAttachment(HSAddIssueFragment.this.getContext(), HSAddIssueFragment.this.hsApiData, HSAddIssueFragment.this.screenshotPath, message.getJSONObject("meta").getString("refers"), 0);
            }
            catch (IOException e) {
                Log.d((String)HSAddIssueFragment.TAG, (String)"Saving uploaded screenshot", (Throwable)e);
            }
            catch (JSONException e) {
                Log.d((String)HSAddIssueFragment.TAG, (String)"uploadSuccessHandler", (Throwable)e);
            }
            try {
                String refers = message.getJSONObject("meta").getString("refers");
                if (!TextUtils.isEmpty((CharSequence)refers)) {
                    IssuesDataSource.deleteMessage(refers);
                }
                HSAddIssueFragment.this.hsApiData.getLatestIssues(HSAddIssueFragment.this.getLatestIssuesHandler, HSAddIssueFragment.this.getLatestIssuesHandler);
            }
            catch (JSONException e) {
                Log.d((String)HSAddIssueFragment.TAG, (String)"uploadSuccessHandler", (Throwable)e);
            }
        }
    };
    private Handler uploadFailHandler = new Handler(){

        public void handleMessage(android.os.Message msg) {
            Message.setInProgress(((HSAddIssueFragment)HSAddIssueFragment.this).msgData.id, false);
            HSAddIssueFragment.this.clearScreenshot();
            HSAddIssueFragment.this.handleExit();
        }
    };
    public Handler existsHandler = new Handler(){

        public void handleMessage(android.os.Message msg) {
            try {
                HashMap result = (HashMap)msg.obj;
                JSONObject profileResult = (JSONObject)result.get("response");
                HSAddIssueFragment.this.hsApiData.setProfileId(profileResult.get("id").toString());
                HSAddIssueFragment.this.hsApiData.getIssues(new Handler(){

                    public void handleMessage(android.os.Message msg) {
                        try {
                            HSAddIssueFragment.this.hsApiData.createIssue(HSAddIssueFragment.this.reportHandler, HSAddIssueFragment.this.failureHandler, HSAddIssueFragment.this.getIssueText(), HSAddIssueFragment.this.getUserInfo());
                        }
                        catch (IdentityException e) {
                            Log.d((String)HSAddIssueFragment.TAG, (String)"Something really foul has happened", (Throwable)e);
                        }
                    }
                }, HSAddIssueFragment.this.failureHandler);
                HSAddIssueFragment.this.hsApiData.updateUAToken();
            }
            catch (JSONException e) {
                Log.d((String)HSAddIssueFragment.TAG, (String)e.getMessage(), (Throwable)e);
            }
        }
    };

    public static HSAddIssueFragment newInstance(Bundle bundle, NewConversationListener listener) {
        HSAddIssueFragment hsAddIssueFragment = new HSAddIssueFragment();
        hsAddIssueFragment.setArguments(bundle);
        hsAddIssueFragment.newConversationListener = listener;
        return hsAddIssueFragment;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.hsApiData = new HSApiData(context);
        this.hsStorage = this.hsApiData.storage;
        this.hsApiClient = this.hsApiData.client;
    }

    public void checkAndStartNewConversation() {
        if (this.isFormValid()) {
            ArrayList<Faq> questions;
            if (this.isSearchOnNewConversationEnabled() && (questions = this.getSearchResults(this.desc.getText().toString())).size() > 0) {
                this.newConversationListener.showSearchResultFragment(questions);
                return;
            }
            this.startNewConversation();
        }
    }

    private ArrayList<Faq> getSearchResults(String issueText) {
        return this.hsApiData.localFaqSearch(issueText, HSSearch.HS_SEARCH_OPTIONS.KEYWORD_SEARCH);
    }

    private void handleExit() {
        if (this.isResumed()) {
            boolean dia = (Boolean)HSConfig.configData.get("dia");
            boolean showConversationOnReportIssue = this.getArguments().getBoolean("showConvOnReportIssue", false);
            if (showConversationOnReportIssue && !dia) {
                this.newConversationListener.showConversationOnReportIssue();
            } else {
                this.showIssueFiledToast();
                this.newConversationListener.exitSdkSession();
            }
        }
    }

    private void showIssueFiledToast() {
        Toast toast = Toast.makeText((Context)this.getContext(), (CharSequence)this.getString(D.string.hs__conversation_started_message), (int)0);
        toast.setGravity(16, 0, 0);
        toast.show();
    }

    public void clearScreenshot() {
        this.screenshotContainer.setVisibility(8);
        this.screenshot.setVisibility(8);
        this.clearBtn.setVisibility(8);
        this.screenshotPath = "";
        this.hsStorage.setConversationScreenshot("", this.hsApiData.getLoginId());
        this.showAttachScreenshotMenu = true;
        this.newConversationListener.clear();
    }

    private String getIssueText() {
        return this.desc.getText().toString().trim();
    }

    private HashMap getUserInfo() {
        HashMap<String, String> data = null;
        if (IdentityFilter.sendNameEmail(this.hsStorage)) {
            data = new HashMap<String, String>();
            data.put("name", this.userName);
            if (this.email.trim().length() > 0) {
                data.put("email", this.email);
            }
        }
        return data;
    }

    public void onPause() {
        super.onPause();
        String prefillText = this.hsStorage.getConversationPrefillText();
        String activeConversation = this.hsStorage.getActiveConversation(this.hsApiData.getProfileId());
        if (TextUtils.isEmpty((CharSequence)activeConversation) && TextUtils.isEmpty((CharSequence)prefillText)) {
            this.hsStorage.storeConversationDetail(this.getIssueText(), this.hsApiData.getLoginId());
        } else if (!TextUtils.isEmpty((CharSequence)prefillText) && this.extras.getBoolean("dropMeta")) {
            Meta.setMetadataCallback(null);
        }
        this.saveScreenshot(this.screenshotPath);
        this.hsStorage.setForegroundIssue("");
        InputUtil.hideKeyboard(this.getContext(), (View)this.desc);
        this.setIsReportingIssue(false);
    }

    public void onDestroy() {
        super.onDestroy();
        HelpshiftContext.setViewState(null);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.extras = this.getArguments();
        this.helpshiftDelegate = SupportInternal.getDelegate();
        if (this.isSearchOnNewConversationEnabled()) {
            this.hsApiData.getSections(new Handler(){

                public void handleMessage(android.os.Message msg) {
                    if (msg.what != GetSectionsCallBackStatus.API_SUCCESS_NO_NEW_DATA) {
                        HSAddIssueFragment.this.hsApiData.loadIndex();
                        HSTransliterator.init();
                    }
                }
            }, new Handler(), null);
        }
        this.requireEmail = IdentityFilter.requireEmailFromUI(this.hsStorage);
        this.searchActivityShown = false;
        return inflater.inflate(D.layout.hs__new_conversation_fragment, container, false);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.desc = (EditText)view.findViewById(D.id.hs__conversationDetail);
        this.desc.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                HSAddIssueFragment.this.desc.setError(null);
            }
        });
        this.desc.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                if (view.getId() == R.id.hs__conversationDetail) {
                    view.getParent().requestDisallowInterceptTouchEvent(true);
                    switch (event.getAction() & 0xFF) {
                        case 1: {
                            view.getParent().requestDisallowInterceptTouchEvent(false);
                        }
                    }
                }
                return false;
            }
        });
        this.userNameField = (EditText)view.findViewById(D.id.hs__username);
        this.userNameField.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                HSAddIssueFragment.this.userNameField.setError(null);
            }
        });
        this.emailField = (EditText)view.findViewById(D.id.hs__email);
        this.emailField.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                HSAddIssueFragment.this.emailField.setError(null);
            }
        });
        if (this.requireEmail.booleanValue()) {
            this.emailField.setHint((CharSequence)this.getString(D.string.hs__email_required_hint));
        }
        if (!IdentityFilter.sendNameEmail(this.hsStorage)) {
            this.userNameField.setText((CharSequence)"Anonymous");
        }
        if (!IdentityFilter.showNameEmailForm(this.hsApiData)) {
            this.userNameField.setVisibility(8);
            this.emailField.setVisibility(8);
        } else {
            this.userNameField.setText((CharSequence)this.hsApiData.getUsername());
            this.emailField.setText((CharSequence)this.hsApiData.getEmail());
        }
        this.getActivity().getWindow().setSoftInputMode(4);
        this.screenshotContainer = (CardView)view.findViewById(R.id.screenshot_view_container);
        this.screenshot = (ImageView)view.findViewById(D.id.hs__screenshot);
        this.screenshot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HSAddIssueFragment.this.newConversationListener.startScreenshotPreviewFragment(HSAddIssueFragment.this.screenshotPath, 2);
            }
        });
        this.screenshotFileName = (TextView)view.findViewById(R.id.attachment_file_name);
        this.screenshotFileSize = (TextView)view.findViewById(R.id.attachment_file_size);
        this.clearBtn = (ImageButton)view.findViewById(16908314);
        this.clearBtn.setVisibility(8);
        this.clearBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HSAddIssueFragment.this.clearScreenshot();
            }
        });
        this.progressBar = (ProgressBar)view.findViewById(R.id.progress_bar);
    }

    private boolean isSearchOnNewConversationEnabled() {
        boolean searchPerformed = this.getArguments().getBoolean("search_performed", true);
        return !searchPerformed && this.hsStorage.getShowSearchOnNewConversation() != false;
    }

    public void startNewConversation() {
        try {
            this.setIsReportingIssue(true);
            this.hsApiData.createIssue(this.reportHandler, this.failureHandler, this.getIssueText(), this.getUserInfo());
        }
        catch (IdentityException e) {
            this.hsApiData.registerProfile(this.existsHandler, this.failureHandler, this.userName, this.email, this.hsApiData.getLoginId());
        }
    }

    private void setIsReportingIssue(boolean isReportingIssue) {
        boolean bl = this.showStartNewConversationMenu = !isReportingIssue;
        if (this.clearBtn != null) {
            this.clearBtn.setEnabled(!isReportingIssue);
        }
        if (this.screenshot != null) {
            this.screenshot.setEnabled(!isReportingIssue);
        }
        if (isReportingIssue || this.clearBtn != null && this.clearBtn.getVisibility() == 0) {
            this.showAttachScreenshotMenu = false;
        } else if (!this.hsStorage.getEnableFullPrivacy().booleanValue()) {
            this.showAttachScreenshotMenu = true;
        }
        if (this.newConversationListener != null) {
            this.newConversationListener.reportingIssue();
        }
        if (isReportingIssue) {
            this.progressBar.setVisibility(0);
        } else {
            this.progressBar.setVisibility(8);
        }
    }

    private void saveScreenshot(String screenshotPath) {
        if (!TextUtils.isEmpty((CharSequence)screenshotPath)) {
            this.hsStorage.setConversationScreenshot(screenshotPath, this.hsApiData.getLoginId());
        }
    }

    public void setScreenshot(String screenshotPath) {
        Bitmap screenshotBitmap = AttachmentUtil.getBitmap(screenshotPath, -1);
        if (screenshotBitmap != null) {
            this.screenshot.setImageBitmap(screenshotBitmap);
            this.screenshot.setVisibility(0);
            this.screenshotFileName.setText((CharSequence)AttachmentUtil.getFileName(screenshotPath));
            this.screenshotFileSize.setText((CharSequence)AttachmentUtil.getFileSizeString(screenshotPath));
            this.clearBtn.setVisibility(0);
            this.screenshotPath = screenshotPath;
            this.screenshotContainer.setVisibility(0);
            this.showAttachScreenshotMenu = false;
        }
        if (!TextUtils.isEmpty((CharSequence)screenshotPath)) {
            this.saveScreenshot(screenshotPath);
        }
    }

    private boolean isFormValid() {
        Boolean validForm = true;
        String issueText = this.desc.getText().toString();
        Boolean isNameEmailFormShown = IdentityFilter.showNameEmailForm(this.hsApiData);
        if (isNameEmailFormShown.booleanValue()) {
            this.userName = this.userNameField.getText().toString();
            this.email = this.emailField.getText().toString();
        } else {
            this.userName = this.hsApiData.getUsername();
            this.email = this.hsApiData.getEmail();
        }
        if (issueText.trim().length() == 0) {
            this.desc.setError((CharSequence)this.getString(D.string.hs__conversation_detail_error));
            validForm = false;
        } else {
            Resources resources = this.getResources();
            int descriptionMinLength = resources.getInteger(R.integer.hs__issue_description_min_chars);
            if (issueText.replaceAll("\\s+", "").length() < descriptionMinLength) {
                this.desc.setError((CharSequence)resources.getString(R.string.hs__description_invalid_length_error));
                validForm = false;
            } else if (HSPattern.checkSpecialCharacters(issueText)) {
                this.desc.setError((CharSequence)this.getString(D.string.hs__invalid_description_error));
                validForm = false;
            }
        }
        if (isNameEmailFormShown.booleanValue() && this.userName.trim().length() == 0 || HSPattern.checkSpecialCharacters(this.userName)) {
            this.userNameField.setError((CharSequence)this.getString(D.string.hs__username_blank_error));
            validForm = false;
        }
        if (this.requireEmail.booleanValue() && TextUtils.isEmpty((CharSequence)this.email) && !HSPattern.checkEmail(this.email)) {
            this.emailField.setError((CharSequence)this.getString(D.string.hs__invalid_email_error));
            validForm = false;
        } else if (!TextUtils.isEmpty((CharSequence)this.email) && !HSPattern.checkEmail(this.email)) {
            this.emailField.setError((CharSequence)this.getString(D.string.hs__invalid_email_error));
            validForm = false;
        }
        return validForm;
    }

    public void onStart() {
        super.onStart();
        this.isChangingConfiguration = this.isChangingConfigurations();
        this.addVisibleFragment();
    }

    @Override
    public void onStop() {
        super.onStop();
        this.removeVisibleFragment();
        this.setToolbarTitle(this.getString(R.string.hs__help_header));
    }

    public void onResume() {
        String input;
        super.onResume();
        HelpshiftContext.setViewState("issue-filing");
        if (!this.sendAnyway && !this.isChangingConfiguration) {
            HSFunnel.pushEvent("i");
        }
        String initText = "";
        String storedText = this.hsStorage.getConversationDetail(this.hsApiData.getLoginId());
        String prefillText = this.hsStorage.getConversationPrefillText();
        if (this.extras != null && (input = this.extras.getString("message")) != null && !input.trim().equals("")) {
            initText = input.substring(0, 1).toUpperCase() + input.substring(1);
        }
        if (!this.selectingScreenshot) {
            if (this.searchActivityShown) {
                this.desc.setText((CharSequence)storedText);
            } else if (!TextUtils.isEmpty((CharSequence)prefillText)) {
                this.desc.setText((CharSequence)prefillText);
            } else if (!TextUtils.isEmpty((CharSequence)initText)) {
                this.desc.setText((CharSequence)initText);
            } else {
                this.desc.setText((CharSequence)storedText);
            }
            this.selectingScreenshot = false;
        }
        this.sendAnyway = false;
        this.searchActivityShown = false;
        this.desc.requestFocus();
        this.setScreenshot(this.hsStorage.getConversationScreenshot(this.hsApiData.getLoginId()));
        InputUtil.showKeyboard(this.getContext(), (View)this.desc);
        this.newConversationListener.reloadMenu();
        this.setToolbarTitle(this.getString(R.string.hs__new_conversation_header));
    }

    public boolean isShowAttachScreenshotMenu() {
        return this.showAttachScreenshotMenu;
    }

    public boolean isShowStartNewConversationMenu() {
        return this.showStartNewConversationMenu;
    }
}

