/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import com.helpshift.exceptions.InstallException;
import com.helpshift.network.NameValuePair;
import com.helpshift.support.HSStorage;
import com.helpshift.support.util.LocaleUtil;
import com.helpshift.util.TimeUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.zip.GZIPInputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class HSApiClient {
    public static final String apiVersion = "2";
    public static final String libraryVersion = "4.2.0";
    static final String TAG = "HelpShiftDebug";
    static final int timeStampMaxRetries = 3;
    private static int timeStampErrorReplies = 0;
    final String apiBase = "/api/lib/";
    final String scheme = "https://";
    final String SOL_REJECTED = "Did not accept the solution";
    final String SOL_ACCEPT = "Accepted the solution";
    final String SOL_REVIEW = "Accepted review request";
    final String SC_SENT = "Screenshot sent";
    final String appId;
    final String domain;
    final String apiKey;
    private HSStorage storage;

    protected HSApiClient(String domain, String appId, String apiKey, HSStorage storage) {
        this.domain = domain;
        this.appId = appId;
        this.apiKey = apiKey;
        this.storage = storage;
    }

    private static void addHeadersToConnection(HttpURLConnection connection) {
        String userAgent = "Helpshift-Android/4.2.0/" + Build.VERSION.RELEASE;
        String acceptLangHead = String.format("%s;q=1.0", LocaleUtil.getAcceptLanguageHeader());
        connection.setConnectTimeout(5000);
        connection.setRequestProperty("User-Agent", userAgent);
        connection.setRequestProperty("Accept-Language", acceptLangHead);
        connection.setRequestProperty("Accept-Encoding", "gzip");
        connection.setRequestProperty("X-HS-V", "Helpshift-Android/4.2.0");
    }

    private static String constructPostParamsQuery(List<NameValuePair> params) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (NameValuePair pair : params) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            try {
                result.append(URLEncoder.encode(pair.getName(), "UTF-8"));
                result.append("=");
                result.append(URLEncoder.encode(pair.getValue(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                Log.d((String)TAG, (String)"Exception Unsupported Encoding", (Throwable)e);
            }
        }
        return result.toString();
    }

    private String bytesToHex(byte[] bytes) {
        char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private String getSignature(String sigString) throws GeneralSecurityException, InstallException {
        return this.getSignature(sigString, this.apiKey);
    }

    private String getSignature(String sigString, String key) throws GeneralSecurityException, InstallException {
        String data = sigString;
        if (TextUtils.isEmpty((CharSequence)key)) {
            throw new InstallException("apiKey Missing");
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes("UTF-8"), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(secretKey);
            byte[] hmacData = mac.doFinal(data.getBytes("UTF-8"));
            return this.bytesToHex(hmacData);
        }
        catch (UnsupportedEncodingException e) {
            throw new GeneralSecurityException(e);
        }
    }

    private String getApiUri(String route) {
        return "/api/lib/2" + route;
    }

    private String getApiUrl(String route) throws InstallException {
        if (TextUtils.isEmpty((CharSequence)this.domain)) {
            throw new InstallException("domain Missing");
        }
        return "https://" + this.domain + this.getApiUri(route);
    }

    private String constructGetParams(HashMap<String, String> data) {
        ArrayList<String> dataList = new ArrayList<String>();
        ArrayList<String> mapKeys = new ArrayList<String>(data.keySet());
        for (String key : mapKeys) {
            dataList.add(key + "=" + Uri.encode((String)data.get(key)));
        }
        return TextUtils.join((CharSequence)"&", dataList);
    }

    private String getStringValue(Object value) {
        String dataString = null;
        if (value instanceof String) {
            dataString = (String)value;
        } else if (value instanceof ArrayList) {
            dataString = new JSONArray((Collection)((ArrayList)value)).toString();
        }
        return dataString;
    }

    private List<NameValuePair> constructPostParams(HashMap<String, String> data) {
        ArrayList<String> mapKeys = new ArrayList<String>(data.keySet());
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>(mapKeys.size());
        for (String key : mapKeys) {
            String dataString = this.getStringValue(data.get(key));
            if (dataString == null) continue;
            params.add(new NameValuePair(key, dataString));
        }
        return params;
    }

    private HashMap<String, String> addAuthErrorLog(HashMap<String, String> data) throws InstallException {
        ArrayList<String> dataList = new ArrayList<String>();
        dataList.add("platform-id=sdk");
        String token = UUID.randomUUID().toString();
        dataList.add("token=" + token);
        data.put("token", token);
        try {
            data.put("signature", this.getSignature(TextUtils.join((CharSequence)"&", dataList), "sdk"));
        }
        catch (GeneralSecurityException e) {
            Log.d((String)TAG, (String)("Could not generate signature: " + e.getLocalizedMessage()), (Throwable)e);
            return data;
        }
        return data;
    }

    private HashMap<String, String> addAuth(HashMap<String, String> data, String route, String method) throws InstallException {
        String uriStr = this.getApiUri(route);
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            throw new InstallException("appId Missing");
        }
        data.put("platform-id", this.appId);
        data.put("method", method);
        data.put("uri", uriStr);
        String ts = TimeUtil.getAdjustedTimestamp(this.storage.getServerTimeDelta());
        data.put("timestamp", ts);
        ArrayList<String> mapKeys = new ArrayList<String>(data.keySet());
        ArrayList<String> dataList = new ArrayList<String>();
        Collections.sort(mapKeys);
        for (String key : mapKeys) {
            String dataString;
            if (key.equals("screenshot") || key.equals("meta") || (dataString = this.getStringValue(data.get(key))) == null) continue;
            dataList.add(key + "=" + dataString);
        }
        try {
            data.put("signature", this.getSignature(TextUtils.join((CharSequence)"&", dataList)));
            data.remove("method");
            data.remove("uri");
        }
        catch (GeneralSecurityException e) {
            Log.d((String)TAG, (String)("Could not generate signature: " + e.getLocalizedMessage()), (Throwable)e);
            return data;
        }
        return data;
    }

    private void sendFailMessage(Handler failure, int status) {
        Message result = failure.obtainMessage();
        HashMap<String, Integer> messageResponse = new HashMap<String, Integer>();
        messageResponse.put("status", status);
        result.obj = messageResponse;
        failure.sendMessage(result);
    }

    private void makeRequest(String method, String route, HashMap data, Handler success, Handler failure) {
        this.makeRequest(method, route, data, success, failure, false);
    }

    private void makeRequest(final String method, final String route, final HashMap data, final Handler success, final Handler failure, final boolean forErrorLog) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block37: {
                    try {
                        URL urlObj;
                        HashMap dataCopy = new HashMap(data);
                        String url = HSApiClient.this.getApiUrl(route);
                        HttpURLConnection connection = null;
                        if (method == "GET") {
                            String requestStr = HSApiClient.this.constructGetParams(HSApiClient.this.addAuth(data, route, method));
                            urlObj = new URL(url + "?" + requestStr);
                            connection = (HttpURLConnection)urlObj.openConnection();
                            connection.setRequestMethod("GET");
                            HSApiClient.addHeadersToConnection(connection);
                            String etag = HSApiClient.this.storage.getEtag(route);
                            if (!TextUtils.isEmpty((CharSequence)etag)) {
                                connection.setRequestProperty("If-None-Match", etag);
                            }
                        } else if (method == "POST") {
                            List params = forErrorLog ? HSApiClient.this.constructPostParams(HSApiClient.this.addAuthErrorLog(data)) : HSApiClient.this.constructPostParams(HSApiClient.this.addAuth(data, route, method));
                            urlObj = new URL(url);
                            connection = (HttpURLConnection)urlObj.openConnection();
                            connection.setRequestMethod("POST");
                            connection.setDoOutput(true);
                            connection.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
                            HSApiClient.addHeadersToConnection(connection);
                            OutputStream outputStream = connection.getOutputStream();
                            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
                            writer.write(HSApiClient.constructPostParamsQuery(params));
                            writer.flush();
                            writer.close();
                            outputStream.close();
                        }
                        try {
                            if (connection != null) {
                                Message result;
                                int status = connection.getResponseCode();
                                Set<Map.Entry<String, List<String>>> headers = connection.getHeaderFields().entrySet();
                                for (Map.Entry<String, List<String>> header : headers) {
                                    if (header.getKey() == null || !header.getKey().equals("ETag")) continue;
                                    HSApiClient.this.storage.setEtag(route, header.getValue().get(0));
                                }
                                String line = "";
                                StringBuilder responseStr = new StringBuilder();
                                if (status >= 200 && status < 300) {
                                    FilterInputStream response = new BufferedInputStream(connection.getInputStream());
                                    for (Map.Entry<String, List<String>> header : headers) {
                                        if (header.getKey() == null || !header.getKey().equals("Content-Encoding") || !header.getValue().get(0).equalsIgnoreCase("gzip")) continue;
                                        response = new GZIPInputStream(response);
                                    }
                                    InputStreamReader inputStream = new InputStreamReader(response);
                                    BufferedReader rd = new BufferedReader(inputStream);
                                    try {
                                        while ((line = rd.readLine()) != null) {
                                            responseStr.append(line);
                                        }
                                    }
                                    catch (IOException ex) {
                                        Log.d((String)HSApiClient.TAG, (String)"IO Exception ex", (Throwable)ex);
                                    }
                                }
                                HashMap<String, Integer> messageResponse = new HashMap<String, Integer>();
                                messageResponse.put("status", status);
                                if (status >= 200 && status < 300) {
                                    timeStampErrorReplies = 0;
                                    try {
                                        messageResponse.put("response", (Integer)new JSONArray(responseStr.toString()));
                                    }
                                    catch (JSONException earr) {
                                        messageResponse.put("response", (Integer)new JSONObject(responseStr.toString()));
                                    }
                                    result = success.obtainMessage();
                                    result.obj = messageResponse;
                                    success.sendMessage(result);
                                } else if (status == 304) {
                                    timeStampErrorReplies++;
                                    result = success.obtainMessage();
                                    result.obj = null;
                                    success.sendMessage(result);
                                } else if (status == 422) {
                                    timeStampErrorReplies++;
                                    if (timeStampErrorReplies <= 3) {
                                        for (Map.Entry<String, List<String>> header : headers) {
                                            if (header.getKey() == null || !header.getKey().equals("HS-UEpoch")) continue;
                                            HSApiClient.this.storage.setServerTimeDelta(TimeUtil.calculateTimeAdjustment(header.getValue().get(0)));
                                            HSApiClient.this.makeRequest(method, route, dataCopy, success, failure);
                                        }
                                    } else {
                                        timeStampErrorReplies = 0;
                                        result = failure.obtainMessage();
                                        result.obj = messageResponse;
                                        failure.sendMessage(result);
                                    }
                                } else {
                                    timeStampErrorReplies = 0;
                                    result = failure.obtainMessage();
                                    result.obj = messageResponse;
                                    failure.sendMessage(result);
                                }
                                connection.disconnect();
                                break block37;
                            }
                            HSApiClient.this.sendFailMessage(failure, 3);
                        }
                        catch (JSONException e) {
                            HSApiClient.this.sendFailMessage(failure, 1);
                            Log.d((String)HSApiClient.TAG, (String)"Exception JSON", (Throwable)e);
                        }
                        catch (UnknownHostException e) {
                            HSApiClient.this.sendFailMessage(failure, 3);
                            Log.d((String)HSApiClient.TAG, (String)"Exception Unknown Host", (Throwable)e);
                        }
                        catch (SocketException e) {
                            HSApiClient.this.sendFailMessage(failure, 0);
                            Log.d((String)HSApiClient.TAG, (String)"Exception cannot connect Host", (Throwable)e);
                        }
                        catch (SocketTimeoutException e) {
                            Log.d((String)HSApiClient.TAG, (String)"Exception Socket timeout", (Throwable)e);
                        }
                        catch (SSLPeerUnverifiedException e) {
                            Log.d((String)HSApiClient.TAG, (String)"Exception SSL Peer Unverified", (Throwable)e);
                        }
                        catch (IOException e) {
                            HSApiClient.this.sendFailMessage(failure, 1);
                            Log.d((String)HSApiClient.TAG, (String)"Exception IO", (Throwable)e);
                        }
                    }
                    catch (InstallException e) {
                        Log.e((String)HSApiClient.TAG, (String)"install() not called", (Throwable)e);
                        HSApiClient.this.sendFailMessage(failure, 1);
                    }
                    catch (MalformedURLException e) {
                        Log.d((String)HSApiClient.TAG, (String)"Exception Malformed URL", (Throwable)e);
                        HSApiClient.this.sendFailMessage(failure, 1);
                    }
                    catch (ProtocolException e) {
                        Log.d((String)HSApiClient.TAG, (String)"Exception Protocol", (Throwable)e);
                        HSApiClient.this.sendFailMessage(failure, 1);
                    }
                    catch (UnknownHostException e) {
                        Log.d((String)HSApiClient.TAG, (String)"Exception Unknown Host", (Throwable)e);
                        HSApiClient.this.sendFailMessage(failure, 3);
                    }
                    catch (IOException e) {
                        Log.d((String)HSApiClient.TAG, (String)"Exception IO", (Throwable)e);
                        HSApiClient.this.sendFailMessage(failure, 1);
                    }
                }
            }
        }).start();
    }

    private String getMimeType(String url) {
        String type = null;
        try {
            FileInputStream is = new FileInputStream(url);
            type = URLConnection.guessContentTypeFromStream(is);
            if (type == null) {
                type = URLConnection.guessContentTypeFromName(url);
            }
            ((InputStream)is).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return type;
    }

    private void uploadImage(final String method, final String route, final HashMap plainData, final Handler success, final Handler failure) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                block19: {
                    try {
                        HashMap data = HSApiClient.this.addAuth(plainData, route, method);
                        File screenshotFile = new File((String)data.get("screenshot"));
                        String screenshotMimeType = HSApiClient.this.getMimeType(screenshotFile.getPath());
                        String[] includeExts = new String[]{"image/jpeg", "image/png", "image/gif", "image/x-png", "image/x-citrix-pjpeg", "image/x-citrix-gif", "image/pjpeg"};
                        HashSet<String> allowedMimeTypes = new HashSet<String>(Arrays.asList(includeExts));
                        if (!allowedMimeTypes.contains(screenshotMimeType)) {
                            HashMap<String, Integer> messageResponse = new HashMap<String, Integer>();
                            messageResponse.put("status", -1);
                            Message result = success.obtainMessage();
                            result.obj = messageResponse;
                            failure.sendMessage(result);
                            return;
                        }
                        URL postUrl = null;
                        try {
                            postUrl = new URL(HSApiClient.this.getApiUrl(route));
                        }
                        catch (MalformedURLException e) {
                            Log.d((String)HSApiClient.TAG, (String)e.getMessage(), (Throwable)e);
                            HSApiClient.this.sendFailMessage(failure, 2);
                        }
                        String lineEnd = "\r\n";
                        String twoHyphens = "--";
                        String boundary = "*****";
                        HttpURLConnection conn = null;
                        try {
                            if (postUrl != null) {
                                conn = (HttpURLConnection)postUrl.openConnection();
                                conn.setDoInput(true);
                                conn.setDoOutput(true);
                                conn.setUseCaches(false);
                                conn.setRequestMethod("POST");
                                conn.setConnectTimeout(30000);
                                conn.setReadTimeout(30000);
                                conn.setRequestProperty("Connection", "Keep-Alive");
                                conn.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + boundary);
                                DataOutputStream dos = new DataOutputStream(conn.getOutputStream());
                                dos.writeBytes(twoHyphens + boundary + lineEnd);
                                ArrayList mapKeys = new ArrayList(data.keySet());
                                for (String key : mapKeys) {
                                    if (key.equals("screenshot")) continue;
                                    String value = (String)data.get(key);
                                    dos.writeBytes("Content-Disposition: form-data; name=\"" + key + "\"; " + lineEnd);
                                    dos.writeBytes("Content-Type: text/plain;charset=UTF-8" + lineEnd);
                                    dos.writeBytes("Content-Length: " + value.length() + lineEnd);
                                    dos.writeBytes(lineEnd);
                                    dos.writeBytes(value + lineEnd);
                                    dos.writeBytes(twoHyphens + boundary + lineEnd);
                                }
                                FileInputStream fileInputStream = new FileInputStream(screenshotFile);
                                dos.writeBytes(twoHyphens + boundary + lineEnd);
                                dos.writeBytes("Content-Disposition: form-data; name=\"screenshot\"; filename=\"" + screenshotFile.getName() + "\"" + lineEnd);
                                dos.writeBytes("Content-Type: " + screenshotMimeType + lineEnd);
                                dos.writeBytes("Content-Length: " + screenshotFile.length() + lineEnd);
                                dos.writeBytes(lineEnd);
                                int maxBufferSize = 0x100000;
                                int bytesAvailable = fileInputStream.available();
                                int bufferSize = Math.min(bytesAvailable, maxBufferSize);
                                byte[] buffer = new byte[bufferSize];
                                int bytesRead = fileInputStream.read(buffer, 0, bufferSize);
                                while (bytesRead > 0) {
                                    dos.write(buffer, 0, bufferSize);
                                    bytesAvailable = fileInputStream.available();
                                    bufferSize = Math.min(bytesAvailable, maxBufferSize);
                                    bytesRead = fileInputStream.read(buffer, 0, bufferSize);
                                }
                                dos.writeBytes(lineEnd);
                                dos.writeBytes(twoHyphens + boundary + twoHyphens + lineEnd);
                                fileInputStream.close();
                                int status = conn.getResponseCode();
                                StringBuilder responseStr = new StringBuilder();
                                InputStream responseStream = conn.getInputStream();
                                InputStreamReader inputStream = new InputStreamReader(responseStream);
                                BufferedReader rd = new BufferedReader(inputStream);
                                try {
                                    String line;
                                    while ((line = rd.readLine()) != null) {
                                        responseStr.append(line);
                                    }
                                }
                                catch (IOException ex) {
                                    Log.d((String)HSApiClient.TAG, (String)"IO Exception ex", (Throwable)ex);
                                    HSApiClient.this.sendFailMessage(failure, 2);
                                }
                                String response = responseStr.toString();
                                HashMap<String, Integer> messageResponse = new HashMap<String, Integer>();
                                messageResponse.put("status", status);
                                if (status >= 200 && status < 300) {
                                    try {
                                        messageResponse.put("response", (Integer)new JSONArray(response));
                                    }
                                    catch (JSONException earr) {
                                        messageResponse.put("response", (Integer)new JSONObject(response));
                                    }
                                    Message result = success.obtainMessage();
                                    result.obj = messageResponse;
                                    success.sendMessage(result);
                                } else {
                                    Message result = failure.obtainMessage();
                                    result.obj = messageResponse;
                                    failure.sendMessage(result);
                                }
                                conn.disconnect();
                                dos.flush();
                                dos.close();
                                break block19;
                            }
                            HSApiClient.this.sendFailMessage(failure, 2);
                        }
                        catch (Exception e) {
                            Log.d((String)HSApiClient.TAG, (String)e.getMessage(), (Throwable)e);
                            HSApiClient.this.sendFailMessage(failure, 2);
                        }
                    }
                    catch (InstallException e) {
                        Log.e((String)HSApiClient.TAG, (String)"Error : ", (Throwable)e);
                        HSApiClient.this.sendFailMessage(failure, 1);
                    }
                }
            }
        }).start();
    }

    protected void fetchFaqs(Handler success, Handler failure) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("edfl", String.valueOf(LocaleUtil.isDefaultFallbackLanguageEnabled()));
        this.makeRequest("GET", "/faqs/", data, success, failure);
    }

    protected void registerProfile(Handler success, Handler failure, String username, String email, String identifier, String crittercismId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("displayname", username);
        data.put("email", email);
        data.put("identifier", identifier);
        if (crittercismId != null) {
            data.put("crittercism-id", crittercismId);
        }
        this.makeRequest("POST", "/profiles/", data, success, failure);
    }

    protected void updateUAToken(Handler success, Handler failure, String deviceToken, String profileId) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("token", deviceToken);
        data.put("profile-id", profileId);
        this.makeRequest("POST", "/update-ua-token/", data, success, failure);
    }

    protected void fetchMyIssues(Handler success, Handler failure, String profileId, String since, String mc, String chatLaunchSource) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("profile-id", profileId);
        data.put("since", since);
        data.put("mc", mc);
        if (chatLaunchSource != null) {
            data.put("chat-launch-source", chatLaunchSource);
        }
        this.makeRequest("POST", "/my-issues/", data, success, failure);
    }

    protected void createIssue(Handler success, Handler failure, String profileId, String messageText, String meta) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("profile-id", profileId);
        data.put("message-text", messageText);
        data.put("meta", meta);
        this.makeRequest("POST", "/issues/", data, success, failure);
    }

    protected void addMessage(Handler success, Handler failure, String profileId, String issueId, String messageText, String type, String refers, String messageMeta) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (type == "ca") {
            messageText = "Accepted the solution";
        } else if (type == "ncr") {
            messageText = "Did not accept the solution";
        } else if (type == "ar") {
            messageText = "Accepted review request";
        }
        data.put("profile-id", profileId);
        data.put("message-text", messageText);
        data.put("type", type);
        data.put("refers", refers);
        data.put("message-meta", messageMeta);
        this.makeRequest("POST", "/issues/" + issueId + "/messages/", data, success, failure);
    }

    public void addScMessage(Handler success, Handler failure, String profileId, String issueId, String messageText, String type, String refers, String imageUri) {
        HashMap<String, String> data = new HashMap<String, String>();
        if (type == "sc") {
            messageText = "Screenshot sent";
        }
        data.put("profile-id", profileId);
        data.put("message-text", messageText);
        data.put("type", type);
        data.put("refers", refers);
        data.put("screenshot", imageUri);
        this.uploadImage("POST", "/issues/" + issueId + "/messages/", data, success, failure);
    }

    protected void fetchMessages(Handler success, Handler failure, String profileId, String issueId, String since, String chatLaunchSource) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("profile-id", profileId);
        data.put("since", since);
        if (chatLaunchSource != null) {
            data.put("chat-launch-source", chatLaunchSource);
        }
        this.makeRequest("GET", "/issues/" + issueId + "/messages/", data, success, failure);
    }

    protected void markHelpful(Handler success, Handler failure, String faqId) {
        HashMap data = new HashMap();
        this.makeRequest("POST", "/faqs/" + faqId + "/helpful/", data, success, failure);
    }

    protected void markUnhelpful(Handler success, Handler failure, String faqId) {
        HashMap data = new HashMap();
        this.makeRequest("POST", "/faqs/" + faqId + "/unhelpful/", data, success, failure);
    }

    protected void getConfig(Handler success, Handler failure) {
        HashMap data = new HashMap();
        this.makeRequest("GET", "/config/", data, success, failure);
    }

    protected void sendErrorReport(Handler success, Handler failure, HashMap data) {
        this.makeRequest("POST", "/events/log", data, success, failure, true);
    }

    protected void reportActionEvents(Handler success, Handler failure, HashMap data) {
        this.makeRequest("POST", "/events/", data, success, failure);
    }

    protected void getQuestion(String publishId, Handler success, Handler failure) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("edfl", String.valueOf(LocaleUtil.isDefaultFallbackLanguageEnabled()));
        this.makeRequest("GET", "/faqs/" + publishId + "/", data, success, failure);
    }

    protected void updateMessageSeenState(JSONArray messageIds, String source, String readAt, Handler success, Handler failure) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("message-ids", messageIds.toString());
        data.put("source", source);
        data.put("read-at", readAt);
        this.makeRequest("POST", "/events/messages/seen/", data, success, failure);
    }

    protected void sendCustomerSatisfactionRating(Integer rating, String feedback, String issueId, Handler success, Handler failure) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("rating", "" + rating);
        if (!TextUtils.isEmpty((CharSequence)feedback)) {
            data.put("feedback", feedback);
        }
        this.makeRequest("POST", "/issues/" + issueId + "/customer-survey/", data, success, failure);
    }
}

