/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.app.NotificationManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.database.SQLException;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import com.helpshift.exceptions.IdentityException;
import com.helpshift.support.Faq;
import com.helpshift.support.FaqTagFilter;
import com.helpshift.support.HSApiClient;
import com.helpshift.support.HSFaqSyncStatusEvents;
import com.helpshift.support.HSFunnel;
import com.helpshift.support.HSSearch;
import com.helpshift.support.HSService;
import com.helpshift.support.HSStorage;
import com.helpshift.support.ProfilesManager;
import com.helpshift.support.Section;
import com.helpshift.support.constants.GetSectionsCallBackStatus;
import com.helpshift.support.fragments.SupportFragment;
import com.helpshift.support.model.ErrorReport;
import com.helpshift.support.model.Issue;
import com.helpshift.support.model.Message;
import com.helpshift.support.res.values.HSConfig;
import com.helpshift.support.res.values.HSConsts;
import com.helpshift.support.storage.ErrorReportsDataSource;
import com.helpshift.support.storage.FaqDAO;
import com.helpshift.support.storage.FaqsDataSource;
import com.helpshift.support.storage.IssuesDataSource;
import com.helpshift.support.storage.SectionDAO;
import com.helpshift.support.storage.SectionsDataSource;
import com.helpshift.support.util.HSNotification;
import com.helpshift.support.util.IssuesUtil;
import com.helpshift.support.util.Meta;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSFormat;
import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HelpshiftContext;
import com.helpshift.util.TimeUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class HSApiData {
    public static final String TAG = "HelpShiftDebug";
    public static final int MARK_QUESTION = 0;
    public static final int PUSH_TOKEN = 1;
    public static final int ACTION_EVENTS = 2;
    public static final int MESSAGE_SEEN = 3;
    public static final int CSAT_REQUEST = 4;
    public static final int HIGHEST_RATING = 5;
    public static ArrayList<HSFaqSyncStatusEvents> observers = null;
    protected static boolean faqsSyncing = false;
    private final int FILE_STORE_LIMIT = 10;
    public HSStorage storage;
    public HSApiClient client;
    Iterator failedApiKeys = null;
    private ProfilesManager profilesManager;
    private SectionDAO sectionDAO;
    private FaqDAO faqDAO;
    private ArrayList<Faq> flatFaqList = null;
    private Context c;

    public HSApiData(Context c) {
        this.c = c;
        this.storage = new HSStorage(c);
        this.client = new HSApiClient(this.storage.getDomain(), this.storage.getAppId(), this.storage.getApiKey(), this.storage);
        this.sectionDAO = new SectionsDataSource();
        this.faqDAO = new FaqsDataSource();
        this.profilesManager = ProfilesManager.getInstance();
    }

    protected static void addFaqSyncStatusObserver(HSFaqSyncStatusEvents observer) {
        if (observers == null) {
            observers = new ArrayList();
        }
        observers.add(observer);
    }

    protected static void removeFaqSyncStatusObserver(HSFaqSyncStatusEvents observer) {
        if (observers != null) {
            observers.remove(observer);
        }
    }

    protected static void signalFaqsUpdated() {
        faqsSyncing = false;
        if (observers != null) {
            for (int i = 0; i < observers.size(); ++i) {
                HSFaqSyncStatusEvents observer = observers.get(i);
                if (observer == null) continue;
                observer.faqsUpdated();
            }
        }
    }

    protected static void signalSearchIndexesUpdated() {
        if (observers != null) {
            for (int i = 0; i < observers.size(); ++i) {
                HSFaqSyncStatusEvents observer = observers.get(i);
                if (observer == null) continue;
                observer.searchIndexesUpdated();
            }
        }
    }

    private void sendErrorReportsBatch(String reportType, JSONArray errorReports, final List<String> reportIds) {
        Handler.Callback handlerCallbackSuccess = new Handler.Callback(){

            public boolean handleMessage(android.os.Message message) {
                ErrorReportsDataSource.deleteErrorReports(reportIds);
                return true;
            }
        };
        Handler.Callback handlerCallbackFailure = new Handler.Callback(){

            public boolean handleMessage(android.os.Message message) {
                long currentElapsedTime = TimeUtil.getAdjustedTimeInMillis(HSApiData.this.storage.getServerTimeDelta());
                HSApiData.this.storage.setLastErrorReportedTime(currentElapsedTime - 86400000L - 1L);
                return true;
            }
        };
        Handler success = new Handler(handlerCallbackSuccess);
        Handler failure = new Handler(handlerCallbackFailure);
        HSApiData hsApiData = new HSApiData(HelpshiftContext.getApplicationContext());
        HashMap<String, String> hashMapData = new HashMap<String, String>();
        hashMapData.put("elv", "1");
        hashMapData.put("platform", "android");
        hashMapData.put("library-version", this.storage.getLibraryVersion());
        hashMapData.put("domain", this.storage.getDomain());
        hashMapData.put("report_type", reportType);
        hashMapData.put("reports", errorReports.toString());
        hsApiData.client.sendErrorReport(success, failure, hashMapData);
    }

    protected void install(String apiKey, String domain, String appId) {
        this.storage.setApiKey(apiKey);
        this.storage.setDomain(domain);
        this.storage.setAppId(appId);
        this.client = new HSApiClient(domain, appId, apiKey, this.storage);
    }

    private void updateFlatList() {
        ArrayList<Section> sections = this.getSections();
        this.flatFaqList = new ArrayList();
        for (int i = 0; i < sections.size(); ++i) {
            Section sectionItem = sections.get(i);
            ArrayList faqs = this.getFaqsDataForSection(sectionItem.getPublishId());
            for (int j = 0; j < faqs.size(); ++j) {
                Faq faq = (Faq)faqs.get(j);
                this.flatFaqList.add(faq);
            }
        }
    }

    private void getAndStoreSections(final Handler callback, final Handler failure, final FaqTagFilter faqTagFilter) throws SQLException {
        Handler localSuccess = new Handler(){

            public void handleMessage(android.os.Message msg) {
                HashMap result = (HashMap)msg.obj;
                if (result != null) {
                    JSONArray faqs = (JSONArray)result.get("response");
                    HSApiData.this.sectionDAO.clearSectionsData();
                    HSApiData.this.sectionDAO.storeSections(faqs);
                    android.os.Message msgToPost = callback.obtainMessage();
                    msgToPost.obj = HSApiData.this.sectionDAO.getAllSections(faqTagFilter);
                    msgToPost.what = GetSectionsCallBackStatus.API_SUCCESS_NEW_DATA;
                    callback.sendMessage(msgToPost);
                    Thread indexThread = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            HSApiData.this.updateIndex();
                            HSApiData.signalSearchIndexesUpdated();
                        }
                    });
                    indexThread.setDaemon(true);
                    indexThread.start();
                } else {
                    android.os.Message msgToPost = callback.obtainMessage();
                    msgToPost.what = GetSectionsCallBackStatus.API_SUCCESS_NO_NEW_DATA;
                    callback.sendMessage(msgToPost);
                }
                HSApiData.signalFaqsUpdated();
            }
        };
        Handler localFailure = new Handler(){

            public void handleMessage(android.os.Message msg) {
                HashMap result = (HashMap)msg.obj;
                faqsSyncing = false;
                android.os.Message msgToPost = failure.obtainMessage();
                msgToPost.obj = result;
                msgToPost.what = GetSectionsCallBackStatus.API_FAILURE;
                failure.sendMessage(msgToPost);
            }
        };
        faqsSyncing = true;
        this.client.fetchFaqs(localSuccess, localFailure);
    }

    private void getAndStoreConfig(final Handler callback, Handler failure) throws JSONException {
        Handler localSuccess = new Handler(){

            public void handleMessage(android.os.Message msg) {
                HashMap result = (HashMap)msg.obj;
                if (result != null) {
                    JSONObject config = (JSONObject)result.get("response");
                    if (HSApiData.this.storage.getBreadCrumbsLimit().intValue() != config.optInt("bcl", 10)) {
                        HSApiData.this.storage.updateBreadCrumbsLimit(config.optInt("bcl", 10));
                    }
                    try {
                        JSONObject storedConfig = HSApiData.this.storage.getConfig();
                        JSONObject storedReviewConfig = storedConfig.optJSONObject("pr");
                        JSONObject reviewConfig = config.optJSONObject("pr");
                        if (storedReviewConfig != null && !storedReviewConfig.getString("t").equals(reviewConfig.getString("t"))) {
                            HSApiData.this.resetReviewCounter();
                        }
                    }
                    catch (JSONException e) {
                        Log.d((String)HSApiData.TAG, (String)"Reseting counter", (Throwable)e);
                    }
                    HSApiData.this.storage.setConfig(config);
                    android.os.Message msgToPost = callback.obtainMessage();
                    msgToPost.obj = config;
                    callback.sendMessage(msgToPost);
                }
            }
        };
        this.client.getConfig(localSuccess, failure);
    }

    public void getSections(Handler callback, Handler failure, FaqTagFilter faqTagFilter) {
        ArrayList sections = null;
        try {
            sections = (ArrayList)this.sectionDAO.getAllSections(faqTagFilter);
        }
        catch (SQLException s) {
            Log.d((String)TAG, (String)"Database exception in getting sections data ", (Throwable)s);
        }
        if (sections != null) {
            android.os.Message result = callback.obtainMessage();
            result.what = GetSectionsCallBackStatus.DATABASE_SUCCESS;
            result.obj = sections;
            callback.sendMessage(result);
        } else {
            android.os.Message result = failure.obtainMessage();
            result.what = GetSectionsCallBackStatus.DATABASE_FAILURE;
            failure.sendMessage(result);
        }
        this.getAndStoreSections(callback, failure, faqTagFilter);
    }

    protected ArrayList<Section> getSections() {
        ArrayList sections = null;
        try {
            sections = (ArrayList)this.sectionDAO.getAllSections();
        }
        catch (SQLException s) {
            Log.d((String)TAG, (String)"Database exception in getting sections data ", (Throwable)s);
        }
        return sections;
    }

    public ArrayList<Section> getPopulatedSections(ArrayList<Section> sections, FaqTagFilter faqTagFilter) {
        ArrayList<Section> sectionsList = new ArrayList<Section>();
        for (int i = 0; i < sections.size(); ++i) {
            if (this.isSectionEmpty(sections.get(i), faqTagFilter)) continue;
            sectionsList.add(sections.get(i));
        }
        return sectionsList;
    }

    protected ArrayList<Section> getPopulatedSections(FaqTagFilter faqTagFilter) {
        ArrayList sections = null;
        ArrayList<Section> sectionsList = new ArrayList();
        try {
            sections = (ArrayList)this.sectionDAO.getAllSections(faqTagFilter);
        }
        catch (SQLException s) {
            Log.d((String)TAG, (String)"Database exception in getting sections data ", (Throwable)s);
        }
        sectionsList = this.getPopulatedSections(sections, faqTagFilter);
        return sectionsList;
    }

    protected boolean isSectionEmpty(Section section, FaqTagFilter faqTagFilter) {
        ArrayList faqs = this.getFaqsForSection(section.getPublishId(), faqTagFilter);
        return faqs.isEmpty();
    }

    public ArrayList getFaqsForSection(String publishId, FaqTagFilter faqTagFilter) {
        ArrayList faqs = new ArrayList();
        try {
            faqs = (ArrayList)this.faqDAO.getFaqsForSection(publishId, faqTagFilter);
        }
        catch (SQLException s) {
            Log.d((String)TAG, (String)"Database exception in getting faqs for section", (Throwable)s);
        }
        return faqs;
    }

    protected ArrayList getFaqsDataForSection(String publishId) {
        ArrayList faqs = new ArrayList();
        try {
            faqs = (ArrayList)this.faqDAO.getFaqsDataForSection(publishId);
        }
        catch (SQLException s) {
            Log.d((String)TAG, (String)"Database exception in getting faqs for section", (Throwable)s);
        }
        return faqs;
    }

    protected void getConfig(Handler callback, Handler failure) throws JSONException {
        JSONObject storedConfig = this.storage.getConfig();
        if (storedConfig.length() != 0) {
            android.os.Message msgToPost = callback.obtainMessage();
            msgToPost.obj = storedConfig;
            callback.sendMessage(msgToPost);
        }
        this.getAndStoreConfig(callback, failure);
    }

    private void getAndStoreIssues(Handler callback, Handler failure, String identity, String lastTs, String mc, Boolean onlyNew) throws JSONException {
        this.getAndStoreIssues(callback, failure, identity, lastTs, mc, onlyNew, null);
    }

    private void getAndStoreIssues(final Handler callback, final Handler failure, String identity, String lastTs, String mc, final Boolean onlyNew, String chatLaunchSource) throws JSONException {
        Handler localSuccess = new Handler(){

            public void handleMessage(android.os.Message msg) {
                try {
                    HashMap result = (HashMap)msg.obj;
                    JSONObject issuesResult = (JSONObject)result.get("response");
                    String dateStr = issuesResult.getString("timestamp");
                    JSONArray issues = issuesResult.getJSONArray("issues");
                    JSONArray issuesWithSplitMessages = new JSONArray();
                    int numOfIssues = issues.length();
                    if (numOfIssues > 0) {
                        for (int i = 0; i < numOfIssues; ++i) {
                            JSONObject issue = issues.getJSONObject(i);
                            JSONArray messages = issue.getJSONArray("messages");
                            int messagesLength = messages.length();
                            JSONArray splitMessages = new JSONArray();
                            for (int j = 0; j < messagesLength; ++j) {
                                JSONObject message = messages.getJSONObject(j);
                                JSONObject metaObj = message.optJSONObject("meta");
                                JSONArray adminAttachments = new JSONArray();
                                if (metaObj != null && metaObj.has("attachments") && !message.getString("type").equals("sc")) {
                                    adminAttachments = metaObj.getJSONArray("attachments");
                                    metaObj.put("attachments", (Object)new JSONArray());
                                    message.put("meta", (Object)metaObj);
                                }
                                splitMessages.put((Object)message);
                                int numOfAttachments = adminAttachments.length();
                                if (numOfAttachments <= 0) continue;
                                for (int k = 0; k < numOfAttachments; ++k) {
                                    JSONObject attachmentObject = adminAttachments.getJSONObject(k);
                                    JSONObject attachmentMessage = new JSONObject();
                                    attachmentMessage.put("issue_id", (Object)message.getString("issue_id"));
                                    attachmentMessage.put("author", (Object)message.getJSONObject("author"));
                                    attachmentMessage.put("meta", (Object)new JSONObject());
                                    attachmentMessage.put("id", (Object)(message.getString("id") + "_" + k));
                                    attachmentMessage.put("body", (Object)attachmentObject.toString());
                                    attachmentMessage.put("origin", (Object)message.getString("origin"));
                                    String date = message.getString("created_at");
                                    date = HSFormat.addMilliSeconds(HSFormat.inputMsgFormatter, date, k + 1);
                                    attachmentMessage.put("created_at", (Object)date);
                                    Boolean imageType = attachmentObject.optBoolean("image", false);
                                    if (imageType.booleanValue()) {
                                        attachmentMessage.put("type", (Object)"admin_attachment_image");
                                    } else {
                                        attachmentMessage.put("type", (Object)"admin_attachment_generic");
                                    }
                                    splitMessages.put((Object)attachmentMessage);
                                }
                            }
                            messages = new JSONArray(splitMessages.toString());
                            issue.put("messages", (Object)messages);
                            issuesWithSplitMessages.put((Object)issue);
                        }
                    }
                    issues = new JSONArray(issuesWithSplitMessages.toString());
                    HSApiData.this.storage.setIssuesTs(dateStr, HSApiData.this.getProfileId());
                    if (issues.length() > 0) {
                        HSApiData.this.storage.storeIssues(issues, HSApiData.this.getProfileId());
                    }
                    android.os.Message msgToPost = callback.obtainMessage();
                    if (onlyNew.booleanValue()) {
                        msgToPost.obj = issues;
                        if (issues.length() > 0) {
                            callback.sendMessage(msgToPost);
                        } else {
                            HSApiData.this.sendFailMessage(failure, -1);
                        }
                    } else {
                        msgToPost.obj = IssuesDataSource.getIssues(HSApiData.this.getProfileId());
                        callback.sendMessage(msgToPost);
                    }
                    HSApiData.this.rfrCheck(issues);
                }
                catch (JSONException e) {
                    Log.d((String)HSApiData.TAG, (String)"JSON Exception!!!", (Throwable)e);
                }
            }
        };
        this.client.fetchMyIssues(localSuccess, failure, identity, lastTs, mc, chatLaunchSource);
    }

    private void rfrCheck(JSONArray issues) {
        try {
            for (int i = 0; i < issues.length(); ++i) {
                JSONObject lastMessage;
                JSONObject issue = issues.getJSONObject(i);
                JSONArray messages = issue.getJSONArray("messages");
                if (messages.length() <= 0 || !(lastMessage = messages.getJSONObject(messages.length() - 1)).getString("origin").equals("admin") || !lastMessage.getString("type").equals("rfr")) continue;
                this.rfrRequested(issue.getString("id"), lastMessage);
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"rfrCheck", (Throwable)e);
        }
    }

    private void rfrRequested(String issueId, JSONObject message) {
        String viewState = HelpshiftContext.getViewState();
        String activeConversationId = this.storage.getActiveConversation(this.getProfileId());
        if ("issue-filing".equals(viewState)) {
            this.rfrRejected(issueId, message, this.getRfrFailedMessageMeta(1, null));
        } else if ("message-filing".equals(viewState)) {
            this.rfrRejected(issueId, message, this.getRfrFailedMessageMeta(3, null));
        } else if (!TextUtils.isEmpty((CharSequence)activeConversationId) && !activeConversationId.equals(issueId)) {
            this.rfrRejected(issueId, message, this.getRfrFailedMessageMeta(2, activeConversationId));
        } else {
            this.rfrAccepted(issueId, message);
        }
    }

    private JSONObject getRfrFailedMessageMeta(int reason, String openIssueId) {
        JSONObject messageMeta = new JSONObject();
        try {
            switch (reason) {
                case 1: {
                    messageMeta.put("reason", reason);
                    break;
                }
                case 2: {
                    messageMeta.put("reason", reason);
                    messageMeta.put("open-issue-id", (Object)openIssueId);
                    break;
                }
                case 3: {
                    messageMeta.put("reason", reason);
                }
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"getRfrFailedMessageMeta", (Throwable)e);
        }
        return messageMeta;
    }

    private void rfrAccepted(final String issueId, JSONObject message) {
        String messageId = null;
        try {
            messageId = message.getString("id");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"rfrAccepted", (Throwable)e);
        }
        Handler localSuccess = new Handler(){

            public void handleMessage(android.os.Message msg) {
                super.handleMessage(msg);
                try {
                    Issue issue = IssuesDataSource.getIssue(issueId);
                    int messageCount = issue.getNewMessagesCount();
                    if (messageCount != 0 && !issueId.equals(HSApiData.this.storage.getForegroundIssue())) {
                        int ts = (int)HSFormat.issueTsFormat.parse(issue.getCreatedAt()).getTime();
                        HSNotification.showNotif(HSApiData.this.c, issueId, ts, messageCount, "inapp", HSNotification.getApplicationName(HSApiData.this.c));
                    }
                }
                catch (ParseException e) {
                    Log.d((String)HSApiData.TAG, (String)"rfrAccepted", (Throwable)e);
                }
            }
        };
        Issue.openIssue(issueId);
        this.addMessage(localSuccess, new Handler(), issueId, "Accepted the follow-up", "ra", messageId);
    }

    private void rfrRejected(String issueId, JSONObject message, JSONObject messageMeta) {
        String messageId = null;
        try {
            messageId = message.getString("id");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"rfrRejected", (Throwable)e);
        }
        this.addMessage(new Handler(), new Handler(), issueId, "Rejected the follow-up", "rj", messageId, messageMeta);
    }

    private String generateMC() throws JSONException {
        JSONObject mc = new JSONObject();
        List<Issue> issueList = IssuesDataSource.getIssues(this.getProfileId());
        block0: for (Issue issue : issueList) {
            List<Message> messageList = issue.getMessageList();
            for (int i = messageList.size() - 1; i > 0; --i) {
                Message message = messageList.get(i);
                if (message.getMessageId().startsWith("localRscMessage_")) continue;
                mc.put(issue.getIssueId(), (Object)message.getCreatedAt());
                continue block0;
            }
        }
        return mc.toString();
    }

    private void sendFailMessage(Handler failure, int status) {
        android.os.Message result = failure.obtainMessage();
        HashMap<String, Integer> messageResponse = new HashMap<String, Integer>();
        messageResponse.put("status", status);
        result.obj = messageResponse;
        failure.sendMessage(result);
    }

    public void getLatestIssues(Handler callback, Handler failure) throws JSONException {
        this.getLatestIssues(callback, failure, null);
    }

    protected void getLatestIssues(Handler callback, Handler failure, String chatLaunchSource) throws JSONException {
        HashMap ts = this.storage.getIssuesTs(this.getProfileId());
        String profileId = this.getProfileId();
        if (!TextUtils.isEmpty((CharSequence)profileId)) {
            if (ts.containsKey("success")) {
                String dateStr = (String)ts.get("ts");
                this.getAndStoreIssues(callback, failure, profileId, dateStr, this.generateMC(), true, chatLaunchSource);
            } else {
                this.getAndStoreIssues(callback, failure, profileId, "", "", true, chatLaunchSource);
            }
        } else {
            this.sendFailMessage(failure, 403);
        }
    }

    protected void getAllIssues(Handler callback, Handler failure) throws JSONException {
        String profileId = this.getProfileId();
        if (!TextUtils.isEmpty((CharSequence)profileId)) {
            this.getAndStoreIssues(callback, failure, profileId, "", "", false);
        } else {
            this.sendFailMessage(failure, 403);
        }
    }

    public void getIssues(Handler callback, Handler failure) throws JSONException {
        String profileId = this.getProfileId();
        HashMap ts = this.storage.getIssuesTs(profileId);
        if (!TextUtils.isEmpty((CharSequence)profileId)) {
            if (ts.containsKey("success")) {
                List<Issue> issueList = IssuesDataSource.getIssues(this.getProfileId());
                android.os.Message issuesMess = callback.obtainMessage();
                issuesMess.obj = issueList;
                callback.sendMessage(issuesMess);
            } else {
                this.getAndStoreIssues(callback, failure, profileId, "", "", false);
            }
        } else {
            this.sendFailMessage(failure, 403);
        }
    }

    protected JSONObject getMetaInfo(Boolean isAddInfo) {
        if (this.isCustomIdentifier().booleanValue()) {
            return Meta.getMetaInfo(this.c, isAddInfo, this.getDeviceIdentifier());
        }
        return Meta.getMetaInfo(this.c, isAddInfo, null);
    }

    private JSONObject filterForPrivateData(JSONObject input) {
        try {
            JSONObject deviceInfo = input.getJSONObject("device_info");
            deviceInfo.remove("country-code");
            JSONObject customMeta = input.getJSONObject("custom_meta");
            customMeta.remove("private-data");
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"Exception is filtering metaData ", (Throwable)e);
        }
        return input;
    }

    protected JSONObject getFilteredMetaData(Boolean isAddInfo, HashMap userInfo) {
        JSONObject metaInfo = this.getMetaInfo(isAddInfo);
        if (userInfo != null) {
            try {
                metaInfo.put("user_info", (Object)new JSONObject((Map)userInfo));
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"userInfo JSONException", (Throwable)e);
            }
        }
        if (this.storage.getEnableFullPrivacy().booleanValue()) {
            this.filterForPrivateData(metaInfo);
        }
        return metaInfo;
    }

    public void createIssue(final Handler success, final Handler failure, final String messageText, HashMap userInfo) throws IdentityException {
        final String profileId = this.getProfileId();
        if (TextUtils.isEmpty((CharSequence)profileId)) {
            throw new IdentityException("Identity not found");
        }
        final JSONObject metaInfo = this.getFilteredMetaData(true, userInfo);
        Handler localFailure = new Handler(){

            public void handleMessage(android.os.Message msg) {
                HashMap result = (HashMap)msg.obj;
                Integer status = (Integer)result.get("status");
                if (status == 413) {
                    metaInfo.remove("custom_meta");
                    HSApiData.this.client.createIssue(success, failure, profileId, messageText, metaInfo.toString());
                } else {
                    android.os.Message fmsg = failure.obtainMessage();
                    fmsg.obj = result;
                    failure.sendMessage(fmsg);
                }
            }
        };
        this.client.createIssue(success, localFailure, profileId, messageText, metaInfo.toString());
    }

    protected void addMessage(Handler success, Handler failure, String issueId, String messageText, String type, String refers, JSONObject messageMeta) {
        this.addMessage(success, failure, issueId, messageText, type, refers, -1, messageMeta.toString());
    }

    protected void addMessage(Handler success, Handler failure, String issueId, String messageText, String type, String refers) {
        this.addMessage(success, failure, issueId, messageText, type, refers, -1, null);
    }

    protected void addMessage(Handler success, Handler failure, String issueId, String messageText, String type, String refers, int failedState) {
        this.addMessage(success, failure, issueId, messageText, type, refers, failedState, null);
    }

    protected void addMessage(Handler success, final Handler failure, final String issueId, final String messageText, final String type, final String refers, final int failedState, String messageMeta) {
        final String profileId = this.getProfileId();
        Handler localFailure = new Handler(){

            public void handleMessage(android.os.Message msg) {
                try {
                    HSApiData.this.storage.storeFailedMessage(issueId, messageText, type, refers, failedState, profileId);
                }
                catch (JSONException e) {
                    Log.d((String)HSApiData.TAG, (String)"JSON Exception", (Throwable)e);
                }
                android.os.Message fmsg = failure.obtainMessage();
                fmsg.obj = (HashMap)msg.obj;
                failure.sendMessage(fmsg);
            }
        };
        this.client.addMessage(success, localFailure, profileId, issueId, messageText, type, refers, messageMeta);
    }

    public void markQuestion(final Handler success, final Handler failure, final String faqId, final Boolean helpful) {
        Handler localSuccess = new Handler(){

            public void handleMessage(android.os.Message msg) {
                try {
                    HashMap result = (HashMap)msg.obj;
                    JSONObject markResult = (JSONObject)result.get("response");
                    if (markResult.getString("status").equals("marked")) {
                        HSApiData.this.faqDAO.setIsHelpful(faqId, helpful);
                        android.os.Message msgToPost = success.obtainMessage();
                        msgToPost.obj = helpful;
                        success.sendMessage(msgToPost);
                    }
                }
                catch (JSONException e) {
                    android.os.Message msgToPost = failure.obtainMessage();
                    failure.sendMessage(msgToPost);
                    Log.d((String)HSApiData.TAG, (String)"JSON Exception", (Throwable)e);
                }
            }
        };
        Handler localFailure = new Handler(){

            public void handleMessage(android.os.Message msg) {
                HSApiData.this.faqDAO.setIsHelpful(faqId, helpful);
                android.os.Message msgToPost = failure.obtainMessage();
                msgToPost.obj = msg.obj;
                failure.sendMessage(msgToPost);
            }
        };
        if (helpful.booleanValue()) {
            this.client.markHelpful(localSuccess, localFailure, faqId);
        } else {
            this.client.markUnhelpful(localSuccess, localFailure, faqId);
        }
    }

    public ArrayList localFaqSearch(String query, HSSearch.HS_SEARCH_OPTIONS options) {
        return this.localFaqSearch(query, options, null);
    }

    public ArrayList localFaqSearch(String query, HSSearch.HS_SEARCH_OPTIONS options, FaqTagFilter faqTagFilter) {
        if (this.flatFaqList == null) {
            this.updateFlatList();
        } else {
            for (Faq faq : this.flatFaqList) {
                faq.clearSearchTerms();
            }
        }
        LinkedHashSet<Faq> result = new LinkedHashSet<Faq>();
        String lcQuery = query.toLowerCase();
        if (this.storage.getDBFlag().booleanValue()) {
            Faq faq;
            int docIdValue;
            String docId;
            HashMap fullIndex = this.storage.readIndex();
            HashMap tfidf = null;
            HashMap fuzzyIndex = null;
            if (fullIndex != null) {
                tfidf = (HashMap)fullIndex.get("i");
                fuzzyIndex = (HashMap)fullIndex.get("f");
            }
            ArrayList<HashMap> tfidfResults = HSSearch.queryDocs(query, tfidf, options);
            ArrayList<HashMap> fuzzyMatches = HSSearch.getFuzzyMatches(query, fuzzyIndex);
            for (HashMap docIdTermsMap : tfidfResults) {
                docId = (String)docIdTermsMap.get("f");
                docIdValue = Integer.decode(docId);
                if (docIdValue >= this.flatFaqList.size()) continue;
                faq = this.flatFaqList.get(docIdValue);
                faq.addSearchTerms((ArrayList)docIdTermsMap.get("t"));
                result.add(faq);
            }
            for (HashMap docIdTermsMap : fuzzyMatches) {
                docId = (String)docIdTermsMap.get("f");
                docIdValue = Integer.decode(docId);
                if (docIdValue >= this.flatFaqList.size()) continue;
                faq = this.flatFaqList.get(docIdValue);
                faq.addSearchTerms((ArrayList)docIdTermsMap.get("t"));
                result.add(faq);
            }
        } else {
            for (int i = 0; i < this.flatFaqList.size(); ++i) {
                Faq faq = this.flatFaqList.get(i);
                String title = faq.getTitle().toLowerCase();
                if (title.indexOf(lcQuery) == -1) continue;
                result.add(faq);
            }
        }
        if (faqTagFilter != null) {
            return new ArrayList<Faq>(this.faqDAO.getFilteredFaqs(new ArrayList<Faq>(result), faqTagFilter));
        }
        return new ArrayList(result);
    }

    public ArrayList getAllFaqs(FaqTagFilter faqTagFilter) {
        if (this.flatFaqList == null) {
            this.updateFlatList();
        } else {
            for (Faq faq : this.flatFaqList) {
                faq.clearSearchTerms();
            }
        }
        if (faqTagFilter != null) {
            return new ArrayList<Faq>(this.faqDAO.getFilteredFaqs(new ArrayList<Faq>(this.flatFaqList), faqTagFilter));
        }
        return this.flatFaqList;
    }

    protected void getNotificationCount(final Handler success, Handler failure) {
        try {
            Handler localSuccess = new Handler(){

                public void handleMessage(android.os.Message msg) {
                    Integer activeCnt = HSApiData.this.storage.getActiveNotifCnt(HSApiData.this.getProfileId());
                    android.os.Message msgToPost = success.obtainMessage();
                    Bundle countData = new Bundle();
                    countData.putInt("value", activeCnt.intValue());
                    countData.putBoolean("cache", false);
                    msgToPost.obj = countData;
                    success.sendMessage(msgToPost);
                }
            };
            this.getLatestIssues(localSuccess, failure);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)e.toString(), (Throwable)e);
        }
    }

    protected void getNotificationData(Handler success, Handler failure) {
        try {
            this.getLatestIssues(success, failure);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)e.toString(), (Throwable)e);
        }
    }

    protected void reportAppStartEvent() {
        JSONArray actions = new JSONArray();
        JSONObject eventObj = new JSONObject();
        try {
            eventObj.put("ts", (Object)HSFormat.tsSecFormatter.format((double)System.currentTimeMillis() / 1000.0));
            eventObj.put("t", (Object)"a");
            actions.put((Object)eventObj);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSONException", (Throwable)e);
        }
        this.reportActionEvents(actions);
    }

    public void reportActionEvents() {
        JSONArray actions = HSFunnel.takeActions();
        this.reportActionEvents(actions);
    }

    private void reportActionEvents(JSONArray actions) {
        String identifier = this.getLoggedInHSId();
        String profileId = this.getProfileId();
        String libraryVersion = "4.2.0";
        String sdkType = this.storage.getSdkType();
        String deviceId = this.getDeviceIdentifier();
        String uid = null;
        String deviceModel = Build.MODEL;
        String os = Build.VERSION.RELEASE;
        String appVersion = ApplicationUtil.getApplicationVersion(this.c);
        String rom = System.getProperty("os.version") + ":" + Build.FINGERPRINT;
        TelephonyManager tm = (TelephonyManager)this.c.getSystemService("phone");
        String cc = tm.getSimCountryIso();
        String ln = Locale.getDefault().getLanguage();
        if (!identifier.equals(deviceId)) {
            uid = deviceId;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", identifier);
        if (uid != null) {
            params.put("uid", uid);
        }
        if (!TextUtils.isEmpty((CharSequence)profileId)) {
            params.put("profile-id", profileId);
        }
        params.put("v", libraryVersion);
        params.put("e", actions.toString());
        params.put("s", sdkType);
        params.put("dm", deviceModel);
        params.put("os", os);
        params.put("av", appVersion);
        params.put("rs", rom);
        if (!TextUtils.isEmpty((CharSequence)cc)) {
            params.put("cc", cc);
        }
        params.put("ln", ln);
        String key = "action_event_" + Long.toString(System.currentTimeMillis());
        Handler apiFailHandler = this.getApiFailHandler(new Handler(), key, 2, new JSONObject(params));
        this.reportActionEvents(new Handler(), apiFailHandler, params);
    }

    private void reportActionEvents(Handler success, Handler failure, HashMap<String, String> params) {
        this.client.reportActionEvents(success, failure, params);
    }

    protected Boolean showReviewP() {
        if (this.storage.getReviewed() == 0) {
            JSONObject pr = (JSONObject)HSConfig.configData.get("pr");
            String rurl = (String)HSConfig.configData.get("rurl");
            if (pr != null && pr.optBoolean("s", false) && !TextUtils.isEmpty((CharSequence)rurl)) {
                int reviewCount = this.storage.getReviewCounter();
                String counterType = pr.optString("t", "");
                int counterInterval = pr.optInt("i", 0);
                if (counterInterval > 0) {
                    if (counterType.equals("l") && reviewCount >= counterInterval) {
                        return true;
                    }
                    if (counterType.equals("s") && reviewCount != 0 && new Date().getTime() / 1000L - (long)reviewCount >= (long)counterInterval) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected void loadConfig() {
        try {
            JSONObject pr = (JSONObject)HSConfig.configData.get("pr");
            JSONObject storedConfig = this.storage.getConfig();
            if (pr == null && storedConfig.length() != 0) {
                HSConfig.updateConfig(storedConfig);
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)("JSON Exception:" + e.toString()));
        }
    }

    protected void updateReviewCounter() {
        String counterType;
        int reviewCounter = this.storage.getReviewCounter();
        int launchReviewCounter = this.storage.getLaunchReviewCounter();
        if (reviewCounter == 0) {
            launchReviewCounter = reviewCounter;
            reviewCounter = (int)(new Date().getTime() / 1000L);
        }
        this.storage.setLaunchReviewCounter(++launchReviewCounter);
        this.loadConfig();
        JSONObject pr = (JSONObject)HSConfig.configData.get("pr");
        if (pr != null && (counterType = pr.optString("t", "")).equals("l")) {
            reviewCounter = this.storage.getLaunchReviewCounter();
        }
        this.storage.setReviewCounter(reviewCounter);
    }

    protected void resetReviewCounter() {
        int reviewCounter = this.storage.getReviewCounter();
        try {
            JSONObject pr = this.storage.getConfig().optJSONObject("pr");
            if (pr != null) {
                String counterType = pr.optString("t", "");
                if (counterType.equals("s")) {
                    reviewCounter = (int)(new Date().getTime() / 1000L);
                } else if (counterType.equals("l")) {
                    reviewCounter = 0;
                }
                this.storage.setReviewCounter(reviewCounter);
                this.storage.setLaunchReviewCounter(0);
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"Reseting review counter", (Throwable)e);
        }
    }

    protected void enableReview() {
        this.storage.enableReview();
    }

    protected void disableReview() {
        this.storage.setReviewed();
    }

    protected void getAndStoreMessages(String issueId, final Handler success, Handler failure, String chatLaunchSource) throws JSONException {
        String profileId = this.getProfileId();
        Issue issue = IssuesDataSource.getIssue(issueId);
        List<Message> messageList = issue.getMessageList();
        Message lastMessage = messageList.size() == 0 ? messageList.get(0) : messageList.get(messageList.size() - 1);
        Handler localSuccess = new Handler(){

            public void handleMessage(android.os.Message msg) {
                HashMap result = (HashMap)msg.obj;
                JSONArray messages = (JSONArray)result.get("response");
                IssuesDataSource.storeMessages(IssuesUtil.jsonArrayToMessageList(messages));
                android.os.Message msgToPost = success.obtainMessage();
                msgToPost.obj = messages;
                success.sendMessage(msgToPost);
            }
        };
        this.client.fetchMessages(localSuccess, failure, profileId, issueId, lastMessage.getCreatedAt(), chatLaunchSource);
    }

    protected String getDeviceIdentifier() {
        String deviceId = this.storage.getDeviceIdentifier();
        if (!TextUtils.isEmpty((CharSequence)deviceId)) {
            return deviceId;
        }
        return this.getHSId();
    }

    protected String getUUID() {
        String id2 = this.storage.getUUID();
        if (TextUtils.isEmpty((CharSequence)id2)) {
            id2 = UUID.randomUUID().toString();
            this.storage.setUUID(id2);
        }
        return id2;
    }

    protected String getLoggedInHSId() {
        String id2 = this.storage.getLoginIdentifier();
        id2 = TextUtils.isEmpty((CharSequence)id2) ? this.getHSId() : this.profilesManager.getProfile(id2).getSaltedIdentifier();
        return id2;
    }

    protected String getHSId() {
        String profile_id = this.storage.getIdentity();
        String uuid = this.storage.getUUID();
        String id2 = null;
        id2 = !TextUtils.isEmpty((CharSequence)profile_id) && TextUtils.isEmpty((CharSequence)uuid) ? Settings.Secure.getString((ContentResolver)this.c.getContentResolver(), (String)"android_id") : this.getUUID();
        return id2;
    }

    protected void deleteFiles(List<String> filenames) {
        for (int i = 0; i < filenames.size(); ++i) {
            File file = new File(this.c.getFilesDir(), filenames.get(i));
            file.delete();
        }
    }

    public void storeFile(String fileName) {
        try {
            JSONArray fileJsonList = this.storage.getStoredFiles();
            ArrayList<String> fileArrayList = new ArrayList<String>();
            for (int i = 0; i < fileJsonList.length(); ++i) {
                fileArrayList.add(fileJsonList.getString(i));
            }
            fileArrayList.add(0, fileName);
            if (fileArrayList.size() > 10) {
                List finalFileArrayList = fileArrayList.subList(0, 10);
                JSONArray finalFileJsonList = new JSONArray();
                for (int i = 0; i < finalFileArrayList.size(); ++i) {
                    finalFileJsonList.put(finalFileArrayList.get(i));
                }
                this.deleteFiles(fileArrayList.subList(10, fileArrayList.size()));
                this.storage.setStoredFiles(finalFileJsonList);
            } else {
                JSONArray finalFileJsonList = new JSONArray();
                for (int i = 0; i < fileArrayList.size(); ++i) {
                    finalFileJsonList.put(fileArrayList.get(i));
                }
                this.storage.setStoredFiles(finalFileJsonList);
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"storeFile", (Throwable)e);
        }
    }

    public void registerProfile(final Handler success, Handler failure, String username, String email, String identifier) {
        String crittercismId = null;
        try {
            Class<?> Crittercism = Class.forName("com.crittercism.app.Crittercism");
            Method getUserUUID = Crittercism.getMethod("getUserUUID", null);
            crittercismId = (String)getUserUUID.invoke(null, (Object[])null);
        }
        catch (ClassNotFoundException cnfe) {
            Log.d((String)TAG, (String)"If you are not using Crittercism. Please ignore this", (Throwable)cnfe);
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"If you are not using Crittercism. Please ignore this", (Throwable)e);
        }
        Handler localSuccess = new Handler(){

            public void handleMessage(android.os.Message msg) {
                android.os.Message msgToPost = success.obtainMessage();
                msgToPost.obj = msg.obj;
                success.sendMessage(msgToPost);
            }
        };
        this.client.registerProfile(localSuccess, failure, username, email, identifier, crittercismId);
    }

    public void updateUAToken() {
        String profileId = this.getProfileId();
        String deviceToken = this.storage.getDeviceToken();
        JSONObject params = new JSONObject();
        try {
            params.put("profile-id", (Object)profileId);
            params.put("device-token", (Object)deviceToken);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSONException", (Throwable)e);
        }
        Handler apiFailHandler = this.getApiFailHandler(new Handler(), "push_token_" + profileId, 1, params);
        this.updateUAToken(new Handler(), apiFailHandler, profileId, deviceToken);
    }

    private void updateUAToken(final Handler success, final Handler failure, String profileId, String deviceToken) {
        if (!TextUtils.isEmpty((CharSequence)deviceToken)) {
            Handler localSuccess = new Handler(){

                public void handleMessage(android.os.Message msg) {
                    android.os.Message msgToPost = success.obtainMessage();
                    msgToPost.obj = msg.obj;
                    success.sendMessage(msgToPost);
                    HSApiData.this.stopInAppService();
                }
            };
            Handler localFailure = new Handler(){

                public void handleMessage(android.os.Message msg) {
                    android.os.Message msgToPost = failure.obtainMessage();
                    msgToPost.obj = msg.obj;
                    failure.sendMessage(msgToPost);
                }
            };
            this.client.updateUAToken(localSuccess, localFailure, deviceToken, profileId);
        }
    }

    protected Boolean isCustomIdentifier() {
        return !TextUtils.isEmpty((CharSequence)this.storage.getDeviceIdentifier());
    }

    private void updateIndex() {
        this.storage.deleteIndex();
        this.updateFlatList();
        HashMap index = HSSearch.indexDocuments(new ArrayList<Faq>(this.flatFaqList));
        if (index != null) {
            this.storage.storeIndex(index);
        }
    }

    public void loadIndex() {
        Thread loadIndexThread = new Thread(new Runnable(){

            @Override
            public void run() {
                HSApiData.this.storage.loadIndex();
            }
        });
        loadIndexThread.setDaemon(true);
        loadIndexThread.start();
    }

    public void getSection(final String publishId, final Handler success, Handler failure, FaqTagFilter faqTagFilter) {
        try {
            Section section = this.sectionDAO.getSection(publishId);
            if (section != null) {
                android.os.Message msgToPost = success.obtainMessage();
                msgToPost.obj = section;
                success.sendMessage(msgToPost);
            }
            Handler localSuccess = new Handler(){

                public void handleMessage(android.os.Message msg) {
                    super.handleMessage(msg);
                    ArrayList sections = (ArrayList)msg.obj;
                    Section toReturn = HSApiData.this.sectionDAO.getSection(publishId);
                    android.os.Message msgToPost = success.obtainMessage();
                    msgToPost.obj = toReturn;
                    success.sendMessage(msgToPost);
                }
            };
            this.getAndStoreSections(localSuccess, failure, faqTagFilter);
        }
        catch (SQLException s) {
            Log.d((String)TAG, (String)"Database exception in getting section data ", (Throwable)s);
        }
    }

    public Section getSection(String publishId) {
        return this.sectionDAO.getSection(publishId);
    }

    public void getSectionSync(String publishId, Handler success, Handler failure) {
        try {
            Section section = this.sectionDAO.getSection(publishId);
            if (section != null) {
                android.os.Message msgToPost = success.obtainMessage();
                msgToPost.obj = section;
                success.sendMessage(msgToPost);
            } else {
                android.os.Message msgToPost = failure.obtainMessage();
                failure.sendMessage(msgToPost);
            }
        }
        catch (SQLException s) {
            Log.d((String)TAG, (String)"Database exception in getting section data ", (Throwable)s);
        }
    }

    private String getPublishIdFromSectionId(String sectionId) {
        ArrayList<Section> sections = this.getSections();
        String sectionPublishId = "";
        for (int i = 0; i < sections.size(); ++i) {
            Section sectionItem = sections.get(i);
            if (!sectionItem.getSectionId().equals(sectionId)) continue;
            sectionPublishId = sectionItem.getPublishId();
        }
        return sectionPublishId;
    }

    private void getQuestionAsync(String publishId, final Handler success, Handler failure) {
        Handler localSuccess = new Handler(){

            public void handleMessage(android.os.Message msg) {
                android.os.Message msgToPost = success.obtainMessage();
                HashMap result = (HashMap)msg.obj;
                try {
                    if (result != null) {
                        JSONObject question = (JSONObject)result.get("response");
                        Faq newFaq = new Faq(0L, question.getString("id"), question.getString("publish_id"), HSApiData.this.getPublishIdFromSectionId(question.getString("section_id")), question.getString("title"), question.getString("body"), 0, question.getString("is_rtl") == "true", question.has("stags") ? HSJSONUtils.jsonToStringArrayList(question.getString("stags")) : new ArrayList(), question.has("issue_tags") ? HSJSONUtils.jsonToStringArrayList(question.getString("issue_tags")) : new ArrayList());
                        msgToPost.obj = newFaq;
                        success.sendMessage(msgToPost);
                        HSApiData.this.faqDAO.addFaq(newFaq);
                    }
                }
                catch (JSONException e) {
                    Log.d((String)HSApiData.TAG, (String)("Exception in getting question " + (Object)((Object)e)));
                }
            }
        };
        this.client.getQuestion(publishId, localSuccess, failure);
    }

    public void getQuestion(String publishId, Handler success, Handler failure) {
        Faq question = null;
        try {
            question = this.faqDAO.getFaq(publishId);
        }
        catch (SQLException s) {
            Log.d((String)TAG, (String)"Database exception in getting faq ", (Throwable)s);
        }
        if (question == null) {
            this.getQuestionAsync(publishId, success, failure);
        } else {
            android.os.Message msgToPost = success.obtainMessage();
            msgToPost.obj = question;
            success.sendMessage(msgToPost);
            this.getQuestionAsync(publishId, success, failure);
        }
    }

    protected void resetServiceInterval() {
        HSService.resetInterval();
    }

    protected void stopInAppService() {
        Intent service = new Intent(this.c, HSService.class);
        this.c.stopService(service);
    }

    public void startInAppService() {
        Boolean enableInAppNotification = true;
        JSONObject config = new JSONObject();
        String deviceToken = this.storage.getDeviceToken();
        try {
            config = this.storage.getAppConfig();
            if (config.has("enableInAppNotification")) {
                enableInAppNotification = (Boolean)config.get("enableInAppNotification");
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"startInAppService JSONException", (Throwable)e);
        }
        if (enableInAppNotification.booleanValue() && (deviceToken.equals("") || deviceToken.equals("unreg"))) {
            String profileId = this.getProfileId();
            String conversation = this.storage.getActiveConversation(this.getProfileId());
            if (!TextUtils.isEmpty((CharSequence)profileId) && !TextUtils.isEmpty((CharSequence)conversation)) {
                Intent service = new Intent(this.c, HSService.class);
                if (!this.storage.getLibraryVersion().equals("4.2.0")) {
                    this.stopInAppService();
                }
                this.c.startService(service);
            }
        } else {
            this.stopInAppService();
        }
    }

    protected JSONArray getMessagesWithFails(String issueId) {
        try {
            List<Message> messageList = IssuesDataSource.getIssue(issueId).getMessageList();
            return this.storage.mergeMessages(this.storage.getFailedMessages(issueId, this.getProfileId()), IssuesUtil.messageListToJSONArray(messageList));
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSONException", (Throwable)e);
            return new JSONArray();
        }
    }

    protected void sendFailedMessages() {
        try {
            JSONObject failedMessage = this.storage.popFailedMessage(this.getProfileId());
            if (failedMessage == null) {
                return;
            }
            Handler localSuccess = new Handler(){

                public void handleMessage(android.os.Message msg) {
                    HSApiData.this.sendFailedMessages();
                    Intent i = new Intent("com.helpshift.failedMessageRequest");
                    HSApiData.this.c.sendBroadcast(i);
                }
            };
            this.addMessage(localSuccess, localSuccess, failedMessage.getString("issue_id"), failedMessage.getString("body"), failedMessage.getString("type"), failedMessage.getString("refers"), failedMessage.optInt("state", 0) - 1);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"SendfailedMessages failed", (Throwable)e);
        }
    }

    private Boolean isStatusCodeRetriable(Integer status) {
        if (status >= 400 && status < 600 && status != 503 && status != 504) {
            return false;
        }
        return true;
    }

    public Handler getApiFailHandler(final Handler failure, final String key, final int type, final JSONObject params) {
        Handler apiFailHandler = new Handler(){

            public void handleMessage(android.os.Message msg) {
                android.os.Message msgToPost = failure.obtainMessage();
                msgToPost.obj = msg.obj;
                failure.sendMessage(msgToPost);
                try {
                    HashMap result = (HashMap)msg.obj;
                    Integer status = (Integer)result.get("status");
                    Boolean shouldRetry = HSApiData.this.isStatusCodeRetriable(status);
                    if (shouldRetry.booleanValue()) {
                        JSONObject failedApiCall = new JSONObject();
                        failedApiCall.put("t", type);
                        failedApiCall.put("p", (Object)params);
                        HSApiData.this.storage.storeFailedApiCall(key, failedApiCall);
                    } else {
                        HSApiData.this.storage.storeFailedApiCall(key, null);
                    }
                }
                catch (JSONException e) {
                    Log.d((String)HSApiData.TAG, (String)"JSONException", (Throwable)e);
                }
            }
        };
        return apiFailHandler;
    }

    protected Handler getApiSuccessHandler(final Handler success, final String key, int type, JSONObject params) {
        Handler apiSuccessHandler = new Handler(){

            public void handleMessage(android.os.Message msg) {
                android.os.Message msgToPost = success.obtainMessage();
                msgToPost.obj = msg.obj;
                success.sendMessage(msgToPost);
                try {
                    HSApiData.this.storage.storeFailedApiCall(key, null);
                }
                catch (JSONException e) {
                    Log.d((String)HSApiData.TAG, (String)"JSONException", (Throwable)e);
                }
            }
        };
        return apiSuccessHandler;
    }

    protected synchronized void sendFailedApiCalls() {
        Handler localHandler = new Handler(){

            public void handleMessage(android.os.Message msg) {
                HSApiData.this.sendFailedApiCalls();
            }
        };
        try {
            JSONObject failedApiCalls = this.storage.getFailedApiCalls();
            if (this.failedApiKeys == null) {
                this.failedApiKeys = failedApiCalls.keys();
            }
            if (this.failedApiKeys.hasNext()) {
                String key = (String)this.failedApiKeys.next();
                JSONObject failedApiCall = (JSONObject)failedApiCalls.get(key);
                JSONObject params = failedApiCall.getJSONObject("p");
                int type = failedApiCall.getInt("t");
                Handler apiSuccessHandler = this.getApiSuccessHandler(localHandler, key, type, params);
                Handler apiFailHandler = this.getApiFailHandler(localHandler, key, type, params);
                switch (type) {
                    case 0: {
                        this.markQuestion(apiSuccessHandler, apiFailHandler, params.getString("f"), params.getBoolean("h"));
                        break;
                    }
                    case 1: {
                        this.updateUAToken(apiSuccessHandler, apiFailHandler, params.getString("profile-id"), params.getString("device-token"));
                    }
                    case 2: {
                        this.reportActionEvents(apiSuccessHandler, apiFailHandler, HSJSONUtils.toStringHashMap(params));
                        break;
                    }
                    case 3: {
                        this.updateMessageSeenState(apiSuccessHandler, apiFailHandler, params.getJSONArray("mids"), params.getString("src"), params.getString("at"));
                        break;
                    }
                    case 4: {
                        this.sendCustomerSatisfactionSurvey(params.getInt("r"), params.getString("f"), params.getString("id"), apiSuccessHandler, apiFailHandler);
                    }
                }
            } else {
                this.failedApiKeys = null;
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSONException", (Throwable)e);
        }
    }

    protected void updateMessageSeenState(String issueId, String chatLaunchSource) {
        List<String> messageIdList = Message.updateMessagesSeenState(issueId);
        JSONArray messageIds = new JSONArray(messageIdList);
        String readAt = HSFormat.tsSecFormatter.format((double)System.currentTimeMillis() / 1000.0);
        JSONObject params = new JSONObject();
        try {
            params.put("mids", (Object)messageIds);
            params.put("src", (Object)chatLaunchSource);
            params.put("at", (Object)readAt);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSONException", (Throwable)e);
        }
        String key = "msg_seen_" + Long.toString(System.currentTimeMillis());
        Handler apiFailHandler = this.getApiFailHandler(new Handler(), key, 3, params);
        this.updateMessageSeenState(new Handler(), apiFailHandler, messageIds, chatLaunchSource, readAt);
    }

    private void updateMessageSeenState(Handler success, Handler failure, JSONArray messageIds, String source, String readAt) {
        this.client.updateMessageSeenState(messageIds, source, readAt, success, failure);
    }

    protected Boolean isCSatEnabled() {
        return (Boolean)HSConfig.configData.get("csat");
    }

    protected void sendCustomerSatisfactionSurvey(Integer rating, String feedback, final String issueId, final Handler success, Handler failure) {
        if (rating > 0 && rating <= 5) {
            feedback = feedback.trim();
            HS_ISSUE_CSAT_STATE hasCSatSurveyBeenSent = this.getCSatState(issueId);
            if (hasCSatSurveyBeenSent == HS_ISSUE_CSAT_STATE.CSAT_REQUESTED || hasCSatSurveyBeenSent == HS_ISSUE_CSAT_STATE.CSAT_RETRYING) {
                Handler localSuccess = new Handler(){

                    public void handleMessage(android.os.Message msg) {
                        if (msg.obj != null) {
                            android.os.Message result = success.obtainMessage();
                            HashMap<String, Object> successMessage = new HashMap<String, Object>();
                            successMessage.put("status", 200);
                            successMessage.put("id", issueId);
                            result.obj = successMessage;
                            success.sendMessage(result);
                        }
                    }
                };
                this.setCSatState(issueId, HS_ISSUE_CSAT_STATE.CSAT_DONE);
                JSONObject requestObject = new JSONObject();
                try {
                    requestObject.put("r", (Object)rating);
                    requestObject.put("f", (Object)feedback);
                    requestObject.put("id", (Object)issueId);
                }
                catch (JSONException e) {
                    Log.d((String)TAG, (String)"JSONException : ", (Throwable)e);
                }
                final Handler apiFailHandler = this.getApiFailHandler(failure, "csat_" + issueId, 4, requestObject);
                Handler localFailure = new Handler(){

                    public void handleMessage(android.os.Message msg) {
                        if (msg.obj != null) {
                            HSApiData.this.setCSatState(issueId, HS_ISSUE_CSAT_STATE.CSAT_RETRYING);
                            android.os.Message result = success.obtainMessage();
                            HashMap<String, Object> failureMessage = new HashMap<String, Object>();
                            failureMessage.put("status", 0);
                            failureMessage.put("id", issueId);
                            result.obj = failureMessage;
                            apiFailHandler.sendMessage(result);
                        }
                    }
                };
                this.client.sendCustomerSatisfactionRating(rating, feedback, issueId, localSuccess, localFailure);
            } else {
                android.os.Message result = failure.obtainMessage();
                HashMap<String, Object> failureMessage = new HashMap<String, Object>();
                failureMessage.put("status", 400);
                failureMessage.put("reason", "CSat survey already done for " + issueId);
                result.obj = failureMessage;
                failure.sendMessage(result);
            }
        } else {
            android.os.Message result = failure.obtainMessage();
            HashMap<String, Object> failureMessage = new HashMap<String, Object>();
            failureMessage.put("status", 400);
            failureMessage.put("reason", "Rating not in range");
            result.obj = failureMessage;
            failure.sendMessage(result);
        }
    }

    protected HS_ISSUE_CSAT_STATE getCSatState(String issueId) {
        JSONObject issueCSatStates;
        if (this.isCSatEnabled().booleanValue() && (issueCSatStates = this.storage.getIssueCSatStates()) != null) {
            try {
                if (issueCSatStates.has(issueId)) {
                    int state = issueCSatStates.getInt(issueId);
                    return HS_ISSUE_CSAT_STATE.values()[state];
                }
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"JSONException : ", (Throwable)e);
            }
        }
        return HS_ISSUE_CSAT_STATE.CSAT_NOT_APPLICABLE;
    }

    protected Boolean setCSatState(String issueId, HS_ISSUE_CSAT_STATE state) {
        JSONObject issueCSatStates = this.storage.getIssueCSatStates();
        Boolean status = false;
        if (issueCSatStates == null) {
            issueCSatStates = new JSONObject();
        }
        try {
            if (state == HS_ISSUE_CSAT_STATE.CSAT_RETRYING || state == HS_ISSUE_CSAT_STATE.CSAT_DONE || !issueCSatStates.has(issueId) || issueCSatStates.getInt(issueId) != HS_ISSUE_CSAT_STATE.CSAT_DONE.ordinal() && issueCSatStates.getInt(issueId) != HS_ISSUE_CSAT_STATE.CSAT_RETRYING.ordinal()) {
                issueCSatStates.put(issueId, state.ordinal());
                status = true;
                this.storage.setIssueCSatStates(issueCSatStates);
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSONException : ", (Throwable)e);
        }
        return status;
    }

    protected Boolean storeCSatDraft(String issueId, Integer rating, String feedback) {
        Boolean state = false;
        JSONObject csatDraft = new JSONObject();
        feedback = feedback.trim();
        try {
            csatDraft.put("id", (Object)issueId);
            csatDraft.put("rating", (Object)rating);
            csatDraft.put("feedback", (Object)feedback);
            this.storage.setCSatDraft(csatDraft);
            this.setCSatState(issueId, HS_ISSUE_CSAT_STATE.CSAT_INPROGRESS);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSONException : ", (Throwable)e);
        }
        return state;
    }

    protected JSONObject getCSatDraft() {
        return this.storage.getCSatDraft();
    }

    protected void clearNotifications(String profileId) {
        if (!TextUtils.isEmpty((CharSequence)profileId)) {
            NotificationManager notificationManager = (NotificationManager)this.c.getSystemService("notification");
            JSONObject notifications = this.storage.getNotifications(profileId);
            Iterator iterator = notifications.keys();
            while (iterator.hasNext()) {
                String issueId = (String)iterator.next();
                notificationManager.cancel(issueId, 1);
            }
        }
    }

    protected void showNotifications() {
        String profileId = this.getProfileId();
        if (!TextUtils.isEmpty((CharSequence)profileId)) {
            JSONObject notifications = this.storage.getNotifications(profileId);
            Iterator iterator = notifications.keys();
            while (iterator.hasNext()) {
                String issueId = (String)iterator.next();
                try {
                    JSONObject notification = notifications.getJSONObject(issueId);
                    int issueTs = notification.getInt("issueTs");
                    int newMessageCount = notification.getInt("newMessageCount");
                    String chatLaunchSource = notification.getString("chatLaunchSource");
                    String contentTitle = notification.getString("contentTitle");
                    HSNotification.showNotif(this.c, issueId, issueTs, newMessageCount, chatLaunchSource, contentTitle);
                }
                catch (JSONException e) {
                    Log.d((String)TAG, (String)"showNotifications", (Throwable)e);
                }
            }
        }
    }

    protected boolean login(String identifier) {
        if (SupportFragment.isForeground()) {
            Log.d((String)TAG, (String)"Login should be called before starting a Helpshift session");
            return false;
        }
        if (Arrays.asList(HSConsts.invalidLogins).contains(identifier)) {
            this.logout();
            return false;
        }
        this.clearNotifications(this.getProfileId());
        String previousLogin = this.storage.getLoginIdentifier();
        if (!previousLogin.equals(identifier)) {
            this.storage.setLoginIdentifier(identifier);
            Handler success = new Handler(){

                public void handleMessage(android.os.Message msg) {
                    super.handleMessage(msg);
                    HSApiData.this.showNotifications();
                }
            };
            this.getNotificationData(success, new Handler());
        }
        return true;
    }

    protected void logout() {
        if (SupportFragment.isForeground()) {
            Log.d((String)TAG, (String)"Logout should be called before starting a Helpshift session");
            return;
        }
        this.clearNotifications(this.getProfileId());
        this.storage.setLoginIdentifier(null);
        this.showNotifications();
    }

    public String getLoginId() {
        String id2 = this.storage.getLoginIdentifier();
        id2 = TextUtils.isEmpty((CharSequence)id2) ? this.getUUID() : this.profilesManager.getProfile(id2).getSaltedIdentifier();
        return id2;
    }

    public String getProfileId() {
        String id2 = this.storage.getLoginIdentifier();
        String profileId = TextUtils.isEmpty((CharSequence)id2) ? this.storage.getIdentity() : this.profilesManager.getProfileId(id2);
        return profileId;
    }

    public void setProfileId(String profileId) {
        String id2 = this.storage.getLoginIdentifier();
        if (TextUtils.isEmpty((CharSequence)id2)) {
            this.storage.setIdentity(profileId);
        } else {
            this.profilesManager.setProfileId(id2, profileId);
        }
    }

    public String getUsername() {
        String id2 = this.storage.getLoginIdentifier();
        String username = TextUtils.isEmpty((CharSequence)id2) ? this.storage.getUsername() : this.profilesManager.getName(id2);
        return username;
    }

    public void setUsername(String username) {
        String id2 = this.storage.getLoginIdentifier();
        if (TextUtils.isEmpty((CharSequence)id2)) {
            this.storage.setUsername(username);
        } else {
            this.profilesManager.setName(id2, username);
        }
    }

    public String getEmail() {
        String id2 = this.storage.getLoginIdentifier();
        String email = TextUtils.isEmpty((CharSequence)id2) ? this.storage.getEmail() : this.profilesManager.getEmail(id2);
        return email;
    }

    public void setEmail(String email) {
        String id2 = this.storage.getLoginIdentifier();
        if (TextUtils.isEmpty((CharSequence)id2)) {
            this.storage.setEmail(email);
        } else {
            this.profilesManager.setEmail(id2, email);
        }
    }

    protected void sendErrorReports(String reportType) {
        List<ErrorReport> errorReports = ErrorReportsDataSource.getErrorReportsByType(reportType);
        if (errorReports.isEmpty()) {
            return;
        }
        int BATCH_SIZE = 10;
        int currentItem = 0;
        int batchItem = 0;
        ArrayList<String> reportIdsConsumed = new ArrayList<String>();
        JSONArray jsonArrayReports = new JSONArray();
        while (currentItem < errorReports.size()) {
            ErrorReport errorReport = errorReports.get(currentItem);
            jsonArrayReports.put((Object)errorReport.getJSONObject());
            reportIdsConsumed.add(errorReport.getReportId());
            if (++batchItem != BATCH_SIZE && ++currentItem != errorReports.size()) continue;
            try {
                this.sendErrorReportsBatch(reportType, new JSONArray(jsonArrayReports.toString()), new ArrayList<String>(reportIdsConsumed));
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)("Error parsing JSONArray " + jsonArrayReports), (Throwable)e);
            }
            batchItem = 0;
            reportIdsConsumed = new ArrayList();
            jsonArrayReports = new JSONArray();
        }
    }

    public static enum HS_ISSUE_CSAT_STATE {
        CSAT_NOT_APPLICABLE,
        CSAT_APPLICABLE,
        CSAT_REQUESTED,
        CSAT_INPROGRESS,
        CSAT_DONE,
        CSAT_RETRYING;

    }
}

