/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSRetryService;
import com.helpshift.support.HSReview;
import com.helpshift.support.HSStorage;
import com.helpshift.support.Log;
import com.helpshift.support.constants.ErrorReportTypes;
import com.helpshift.support.res.values.HSConfig;
import com.helpshift.support.storage.ErrorReportsDataSource;
import com.helpshift.util.HelpshiftConnectionUtil;
import com.helpshift.util.TimeUtil;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=14)
final class HSLifecycleCallbacks
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "HelpShiftDebug";
    private static HSLifecycleCallbacks instance = null;
    private static HSApiData data = null;
    private static HSStorage storage = null;
    private static int started;
    private static int stopped;
    private static boolean isForeground;
    private static boolean isConfigurationChanged;

    private HSLifecycleCallbacks() {
    }

    public static HSLifecycleCallbacks getInstance() {
        if (instance == null) {
            instance = new HSLifecycleCallbacks();
        }
        return instance;
    }

    public static boolean isForeground() {
        return isForeground;
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onActivityStarted(Activity activity) {
        if (!isConfigurationChanged) {
            if (data == null) {
                data = new HSApiData((Context)activity.getApplication());
                storage = HSLifecycleCallbacks.data.storage;
            }
            ++started;
            if (!isForeground) {
                data.updateReviewCounter();
                Context c = activity.getApplicationContext();
                if (data.showReviewP().booleanValue()) {
                    Intent i = new Intent(c, HSReview.class);
                    i.setFlags(0x10000000);
                    c.startActivity(i);
                }
                try {
                    data.getConfig(new Handler(){

                        public void handleMessage(Message msg) {
                            HSConfig.updateConfig((JSONObject)msg.obj);
                            String profileId = data.getProfileId();
                            if (!TextUtils.isEmpty((CharSequence)profileId)) {
                                storage.updateActiveConversation(profileId);
                            }
                        }
                    }, new Handler());
                }
                catch (JSONException e) {
                    Log.d(TAG, e.toString(), e);
                }
                if (HelpshiftConnectionUtil.isOnline(c)) {
                    c.startService(new Intent(c, HSRetryService.class));
                }
                data.startInAppService();
                data.reportAppStartEvent();
                HSLifecycleCallbacks hSLifecycleCallbacks = this;
                synchronized (hSLifecycleCallbacks) {
                    if (ErrorReportsDataSource.hasReports()) {
                        long lastReportedTime = storage.getLastErrorReportedTime();
                        long currentElapsedTime = TimeUtil.getAdjustedTimeInMillis(storage.getServerTimeDelta());
                        if (currentElapsedTime - lastReportedTime > 86400000L) {
                            storage.setLastErrorReportedTime(currentElapsedTime);
                            data.sendErrorReports(ErrorReportTypes.RUNTIME_ERROR);
                        }
                    }
                }
            }
            isForeground = true;
        }
        isConfigurationChanged = false;
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
        if (activity != null && activity.isChangingConfigurations()) {
            isConfigurationChanged = true;
        } else {
            isConfigurationChanged = false;
            if (started == ++stopped) {
                isForeground = false;
            }
        }
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    static {
        isConfigurationChanged = false;
    }
}

