/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.annotation.TargetApi;
import android.app.DownloadManager;
import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.design.widget.Snackbar;
import android.support.v4.content.ContextCompat;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.ContextMenu;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStub;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.helpshift.R;
import com.helpshift.support.D;
import com.helpshift.support.DownloadManager;
import com.helpshift.support.DownloadTaskCallBacks;
import com.helpshift.support.HSApiClient;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSFunnel;
import com.helpshift.support.HSStorage;
import com.helpshift.support.SupportInternal;
import com.helpshift.support.contracts.HSMessagesListener;
import com.helpshift.support.customadapters.MessagesAdapter;
import com.helpshift.support.fragments.ConversationFlowFragment;
import com.helpshift.support.fragments.MainFragment;
import com.helpshift.support.model.Issue;
import com.helpshift.support.model.Message;
import com.helpshift.support.storage.IssuesDataSource;
import com.helpshift.support.util.AttachmentUtil;
import com.helpshift.support.util.InputUtil;
import com.helpshift.support.util.IssuesUtil;
import com.helpshift.support.util.MessagesUtil;
import com.helpshift.support.util.PermissionUtil;
import com.helpshift.support.util.SnackbarUtil;
import com.helpshift.support.util.Styles;
import com.helpshift.support.viewstructs.HSMsg;
import com.helpshift.support.widget.CSATView;
import com.helpshift.util.ApplicationUtil;
import com.helpshift.util.HSJSONUtils;
import com.helpshift.util.HelpshiftContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HSMessagesFragment
extends MainFragment
implements CSATView.CSATListener,
DownloadTaskCallBacks {
    private final BroadcastReceiver failedMessageRequestChecker = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            HSMessagesFragment.this.refreshMessages();
        }
    };
    private final BroadcastReceiver connChecker = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            HSMessagesFragment.this.startPoller();
        }
    };
    public static final String TAG = "HelpShiftDebug";
    private Bundle extras;
    private String issueId;
    private MessagesAdapter adapter;
    private ArrayList<HSMsg> messagesList = new ArrayList();
    private ListView messagesListView;
    private HSStorage hsStorage;
    private HSApiClient hsClient;
    private HSApiData hsApiData;
    private String chatLaunchSource;
    private HashSet<String> messageIdsSet = new HashSet();
    private HashSet<String> scReferIdsSet = new HashSet();
    private final int MESSAGE_POLL_DURATION = 3;
    private Handler pollerThreadHandler;
    private boolean selectImage = false;
    private EditText replyField;
    private LinearLayout confirmationBox;
    private LinearLayout newConversationBox;
    private LinearLayout messageBox;
    private Button newConversationBtn;
    private boolean persistMessageBox = false;
    private boolean enableNCRMessage = true;
    private boolean newActivity = true;
    private ViewStub csatViewStub;
    private LinearLayout messagesListFooterView;
    private TextView footerMessage;
    private CSATView csatView = null;
    private boolean showingNewConversationBox = false;
    private SupportInternal.Delegate helpshiftDelegate;
    private boolean showAgentName;
    private Snackbar showRationaleSnackbar;
    private Snackbar permissionDeniedSnackbar;
    private HashMap<String, Object> pendingDownloadInfo;
    private HSMessagesListener hsMessagesListener;
    private Integer issueStatus;
    private Handler fetchMessagesSuccess = new Handler(){

        public void handleMessage(android.os.Message msg) {
            super.handleMessage(msg);
            JSONArray messages = (JSONArray)msg.obj;
            if (messages.length() > 0) {
                HSMessagesFragment.this.showAgentName = Issue.isShowAgentNameEnabled(HSMessagesFragment.this.issueId);
                HSMessagesFragment.this.refreshMessages();
                HSMessagesFragment.this.refreshStatus();
                HSMessagesFragment.this.messagesListView.setSelection(HSMessagesFragment.this.adapter.getCount() - 1);
            }
        }
    };
    private Handler fetchMessagesFailure = new Handler(){

        public void handleMessage(android.os.Message msg) {
            super.handleMessage(msg);
            HashMap result = (HashMap)msg.obj;
            Integer status = (Integer)result.get("status");
            if (status != -1 && HSMessagesFragment.this.pollerThreadHandler != null) {
                HSMessagesFragment.this.pollerThreadHandler.getLooper().quit();
            }
            if (!HSMessagesFragment.this.isDetached()) {
                SnackbarUtil.showErrorSnackbar(status, HSMessagesFragment.this.getView());
            }
        }
    };
    private Handler replyHandler = new Handler(){

        public void handleMessage(android.os.Message msg) {
            HSMessagesFragment.this.renderReplyMsg(msg);
        }
    };
    private Handler replyFailHandler = new Handler(){

        public void handleMessage(android.os.Message msg) {
            super.handleMessage(msg);
            if (HSMessagesFragment.this.pollerThreadHandler != null) {
                HSMessagesFragment.this.pollerThreadHandler.getLooper().quit();
            }
            HSMessagesFragment.this.refreshMessages();
        }
    };

    public static HSMessagesFragment newInstance(Bundle bundle) {
        HSMessagesFragment hsMessagesFragment = new HSMessagesFragment();
        hsMessagesFragment.setArguments(bundle);
        return hsMessagesFragment;
    }

    private void gotoApp(String marketUrl) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(Uri.parse((String)marketUrl));
        if (this.isResumed() && intent.resolveActivity(this.getContext().getPackageManager()) != null) {
            this.startActivity(intent);
        } else if (!this.isDetached()) {
            SnackbarUtil.showErrorSnackbar(4, this.getView());
        }
    }

    private void renderReplyMsg(android.os.Message msg) {
        HashMap result = (HashMap)msg.obj;
        JSONObject message = (JSONObject)result.get("response");
        JSONArray messages = new JSONArray();
        messages.put((Object)message);
        IssuesDataSource.storeMessages(IssuesUtil.jsonArrayToMessageList(messages));
        this.refreshMessages();
    }

    public boolean isIssueRejected() {
        return this.issueStatus.equals(3);
    }

    private void refreshStatus() {
        Integer status;
        List<String> openConversations = this.hsStorage.getOpenConversations(this.hsApiData.getProfileId());
        Issue issue = IssuesDataSource.getIssue(this.issueId);
        this.issueStatus = status = Integer.valueOf(issue.getStatus());
        int replyLength = this.hsStorage.getReply(this.hsApiData.getProfileId()).trim().length();
        if (status.equals(0) || status.equals(1)) {
            this.showMessageBox();
            this.persistMessageBox = false;
        } else if (status.equals(2)) {
            if (openConversations.contains(this.issueId)) {
                boolean showConfirmationBox = this.hsStorage.getShowConversationResolutionQuestion();
                if (showConfirmationBox) {
                    this.showConfirmationBox();
                } else {
                    this.resolutionAccepted();
                }
            } else if (this.persistMessageBox || replyLength != 0 || this.hsStorage.getScreenShotDraft().booleanValue()) {
                this.showMessageBox();
            } else {
                this.showNewConversationBox();
            }
        } else if (status.equals(3)) {
            this.hsMessagesListener.reloadMenu();
        }
    }

    private void showConfirmationBox() {
        this.adapter.enableButtons(false);
        this.messageBox.setVisibility(8);
        InputUtil.hideKeyboard(this.getContext(), (View)this.replyField);
        this.confirmationBox.setVisibility(0);
        this.newConversationBox.setVisibility(8);
        this.setMessagesListViewFooter(D.string.hs__confirmation_footer_msg);
        this.hsMessagesListener.showResolutionRequest();
    }

    private void showNewConversationBox() {
        this.enableNCRMessage = false;
        this.adapter.enableButtons(false);
        InputUtil.hideKeyboard(this.getContext(), (View)this.replyField);
        this.confirmationBox.setVisibility(8);
        this.newConversationBox.setVisibility(0);
        this.messageBox.setVisibility(8);
        HSApiData.HS_ISSUE_CSAT_STATE state = this.hsApiData.getCSatState(this.issueId);
        if (state == HSApiData.HS_ISSUE_CSAT_STATE.CSAT_APPLICABLE || state == HSApiData.HS_ISSUE_CSAT_STATE.CSAT_REQUESTED) {
            this.csatView = this.inflateCSATView();
            this.setMessagesListViewFooter(D.string.hs__confirmation_footer_msg);
        } else {
            this.setMessagesListViewFooter(D.string.hs__conversation_end_msg);
        }
        this.showingNewConversationBox = true;
    }

    private CSATView inflateCSATView() {
        CSATView rView = null;
        if (this.csatViewStub != null) {
            rView = (CSATView)this.csatViewStub.inflate();
            rView.setCSATListener(this);
            this.csatViewStub = null;
            this.hsApiData.setCSatState(this.issueId, HSApiData.HS_ISSUE_CSAT_STATE.CSAT_REQUESTED);
        }
        return rView;
    }

    @Override
    public void csatViewDissmissed() {
        this.setMessagesListViewFooter(D.string.hs__conversation_end_msg);
    }

    @Override
    public void sendCSATSurvey(int rating, String feedback) {
        feedback = feedback.trim();
        this.hsApiData.sendCustomerSatisfactionSurvey(rating, feedback, this.issueId, new Handler(), new Handler());
        if (this.helpshiftDelegate != null) {
            this.helpshiftDelegate.userCompletedCustomerSatisfactionSurvey(rating, feedback);
        }
    }

    private void setMessagesListViewFooter(int resId) {
        this.messagesListView.removeFooterView((View)this.messagesListFooterView);
        if (resId != -1) {
            this.addListViewBottomPadding(false);
            this.footerMessage.setVisibility(0);
            this.footerMessage.setText(resId);
            this.messagesListView.addFooterView((View)this.messagesListFooterView);
        }
    }

    private void showMessageBox() {
        this.adapter.enableButtons(true);
        this.confirmationBox.setVisibility(8);
        this.newConversationBox.setVisibility(8);
        this.messageBox.setVisibility(0);
        this.hsMessagesListener.reloadMenu();
        this.setMessagesListViewFooter(-1);
    }

    private void showKeyboard(View v) {
        v.requestFocus();
        InputMethodManager imm = (InputMethodManager)this.getContext().getSystemService("input_method");
        imm.showSoftInput(v, 0);
    }

    private void refreshMessages() {
        JSONArray messages = this.hsApiData.getMessagesWithFails(this.issueId);
        this.refreshMessages(messages);
    }

    private void refreshMessages(JSONArray messages) {
        try {
            this.messagesList.clear();
            this.messageIdsSet.clear();
            this.scReferIdsSet.clear();
            int messagesLength = messages.length();
            for (int i = 0; i < messagesLength; ++i) {
                JSONObject author;
                JSONObject messageMeta;
                JSONObject message = messages.getJSONObject(i);
                String id2 = message.getString("id");
                String type = message.getString("type");
                if (type.equals("admin_attachment_generic")) {
                    String filePath = this.hsStorage.getFilePathForGenericAttachment(id2);
                    File file = new File(filePath);
                    if (file.exists()) {
                        message.put("state", 3);
                    } else {
                        if (!filePath.equals("")) {
                            this.hsStorage.removeFromDownloadedGenericFiles(id2);
                        }
                        if (this.hsStorage.isDownloadActive(id2)) {
                            message.put("state", 1);
                        }
                    }
                } else if (type.equals("admin_attachment_image")) {
                    String imagePath = this.hsStorage.getFilePathForImage(id2);
                    File imageFile = new File(imagePath);
                    if (imageFile.exists()) {
                        message.put("screenshot", (Object)imagePath);
                        message.put("state", 3);
                    } else {
                        String thumbnailPath;
                        File thumbnailFile;
                        if (!imagePath.equals("")) {
                            this.hsStorage.removeFromDownloadedImageFiles(id2);
                        }
                        if ((thumbnailFile = new File(thumbnailPath = this.hsStorage.getFilePathForThumbnail(id2))).exists()) {
                            message.put("screenshot", (Object)thumbnailPath);
                            if (this.hsStorage.isDownloadActive(id2)) {
                                message.put("state", 2);
                            } else {
                                message.put("state", 1);
                            }
                        } else if (!thumbnailPath.equals("")) {
                            this.hsStorage.removeFromDownloadedThumbnailFiles(id2);
                        }
                    }
                }
                String origin = message.getString("origin");
                String body = message.getString("body");
                String date = message.getString("created_at");
                int state = message.optInt("state", 0);
                Boolean inProgress = message.optBoolean("inProgress", false);
                if (origin.equals("mobile") && type.equals("ncr") && !this.enableNCRMessage && i == messagesLength - 1) continue;
                String screenshot = message.optString("screenshot", "");
                if (type.equals("rsc")) {
                    screenshot = message.optString("screenshot", "");
                    if (id2.startsWith("localRscMessage_") && this.scReferIdsSet.contains(id2)) {
                        IssuesDataSource.deleteMessage(id2);
                        continue;
                    }
                }
                if (origin.equals("admin") && type.equals("rfr") && !MessagesUtil.isRfrAccepted(messages, i, id2)) continue;
                Boolean metaResponse = false;
                JSONObject meta = message.optJSONObject("meta");
                if (meta != null && (messageMeta = meta.optJSONObject("response")) != null) {
                    metaResponse = messageMeta.optBoolean("state");
                }
                String agentName = "";
                if (this.showAgentName && (author = message.optJSONObject("author")) != null) {
                    agentName = author.optString("name");
                }
                Boolean invisible = message.optBoolean("invisible") || metaResponse != false;
                if (!MessagesUtil.isMessageSupported(origin, type) || this.messageIdsSet.contains(id2)) continue;
                this.messageIdsSet.add(id2);
                HSMsg msgData = new HSMsg(id2, type, origin, body, date, invisible, screenshot, state, inProgress, agentName);
                if (type.equals("rsc") && inProgress.booleanValue() && ApplicationUtil.getDeviceApiVersion() > 22 && ContextCompat.checkSelfPermission((Context)this.getContext(), (String)"android.permission.READ_EXTERNAL_STORAGE") != 0) {
                    msgData.clickable = true;
                    msgData.inProgress = false;
                    Message.setInProgress(msgData.id, false);
                }
                this.messagesList.add(msgData);
                if (!type.equals("sc")) continue;
                meta = null;
                meta = message.optJSONObject("meta");
                if (meta == null) continue;
                JSONArray attachments = meta.optJSONArray("attachments");
                String refers = meta.optString("refers", id2);
                if (refers.startsWith("localRscMessage_")) {
                    if (this.messageIdsSet.contains(refers)) {
                        this.removeMessage(refers);
                        IssuesDataSource.deleteMessage(refers);
                    } else {
                        this.scReferIdsSet.add(refers);
                    }
                }
                if (attachments != null && attachments.length() > 0 && refers != null) {
                    JSONObject attachment = attachments.optJSONObject(0);
                    if (attachment == null) continue;
                    String url = attachment.optString("url", "");
                    HashMap<String, Object> imgData = new HashMap<String, Object>();
                    imgData.put("url", url);
                    imgData.put("messageId", refers);
                    imgData.put("attachId", 0);
                    imgData.put("position", this.messagesList.size() - 1);
                    new DownloadImagesTask().execute(new HashMap[]{imgData});
                    continue;
                }
                if (attachments != null) continue;
                this.removeMessage(id2);
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"Slug in get(\"slug\") no found", (Throwable)e);
        }
        if (messages.length() > 0) {
            this.adapter.notifyDataSetChanged();
        }
    }

    private void removeMessage(String messageId) {
        Iterator<HSMsg> it = this.messagesList.iterator();
        while (it.hasNext()) {
            HSMsg msg = it.next();
            if (!msg.id.equals(messageId)) continue;
            it.remove();
        }
        this.messageIdsSet.remove(messageId);
    }

    public void onPause() {
        super.onPause();
        if (this.pollerThreadHandler != null) {
            this.pollerThreadHandler.getLooper().quit();
        }
        try {
            this.hsStorage.resetIssueCount(this.issueId);
            if (this.helpshiftDelegate != null) {
                this.helpshiftDelegate.didReceiveNotification(0);
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)e.getMessage(), (Throwable)e);
        }
        this.hsStorage.setForeground(false);
        this.hsStorage.setForegroundIssue("");
        this.hsApiData.resetServiceInterval();
        try {
            this.getContext().unregisterReceiver(this.connChecker);
            this.getContext().unregisterReceiver(this.failedMessageRequestChecker);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        DownloadManager.deregisterDownloadTaskCallBacks();
        this.hsStorage.storeReply(this.replyField.getText().toString().trim(), this.hsApiData.getProfileId());
        if (this.showRationaleSnackbar != null && this.showRationaleSnackbar.isShown()) {
            this.showRationaleSnackbar.dismiss();
        }
        if (this.permissionDeniedSnackbar != null && this.permissionDeniedSnackbar.isShown()) {
            this.permissionDeniedSnackbar.dismiss();
        }
        InputUtil.hideKeyboard(this.getContext(), (View)this.replyField);
    }

    public void onDestroy() {
        super.onDestroy();
        HelpshiftContext.setViewState(null);
    }

    public void startPoller() {
        if (this.pollerThreadHandler != null) {
            this.pollerThreadHandler.getLooper().quit();
            Object var1_1 = null;
        }
        String conversation = this.hsStorage.getActiveConversation(this.hsApiData.getProfileId());
        String archivedConversation = this.hsStorage.getArchivedConversation(this.hsApiData.getProfileId());
        if (TextUtils.isEmpty((CharSequence)conversation) && TextUtils.isEmpty((CharSequence)archivedConversation)) {
            return;
        }
        Thread pollerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Looper.prepare();
                HSMessagesFragment.this.pollerThreadHandler = new Handler(){

                    public void handleMessage(android.os.Message msg) {
                        android.os.Message newMsg = HSMessagesFragment.this.fetchMessagesSuccess.obtainMessage();
                        newMsg.obj = msg.obj;
                        HSMessagesFragment.this.fetchMessagesSuccess.sendMessage(newMsg);
                    }
                };
                Runnable m_handlerTask = new Runnable(){

                    @Override
                    public void run() {
                        try {
                            HSMessagesFragment.this.hsApiData.getLatestIssues(HSMessagesFragment.this.pollerThreadHandler, HSMessagesFragment.this.fetchMessagesFailure, HSMessagesFragment.this.chatLaunchSource);
                        }
                        catch (JSONException e) {
                            Log.d((String)HSMessagesFragment.TAG, (String)"get issues", (Throwable)e);
                        }
                        HSMessagesFragment.this.pollerThreadHandler.postDelayed((Runnable)this, 3000L);
                    }
                };
                m_handlerTask.run();
                Looper.loop();
            }
        });
        pollerThread.start();
    }

    public void onResume() {
        super.onResume();
        this.selectImage = false;
        NotificationManager notificationManager = (NotificationManager)this.getContext().getSystemService("notification");
        notificationManager.cancel(this.issueId, 1);
        this.hsStorage.clearNotification(this.issueId);
        IntentFilter connFilter = new IntentFilter();
        connFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.getContext().registerReceiver(this.connChecker, connFilter);
        IntentFilter failFilter = new IntentFilter();
        failFilter.addAction("com.helpshift.failedMessageRequest");
        this.getContext().registerReceiver(this.failedMessageRequestChecker, failFilter);
        this.startPoller();
        try {
            this.hsStorage.resetIssueCount(this.issueId);
            if (this.helpshiftDelegate != null) {
                this.helpshiftDelegate.didReceiveNotification(0);
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)e.toString(), (Throwable)e);
        }
        this.hsStorage.setForeground(true);
        this.hsStorage.setForegroundIssue(this.issueId);
        this.hsApiData.updateMessageSeenState(this.issueId, this.chatLaunchSource);
        String replyText = this.hsStorage.getReply(this.hsApiData.getProfileId());
        if (!this.showingNewConversationBox) {
            this.replyField.setText((CharSequence)replyText);
        }
        if (this.newActivity && TextUtils.isEmpty((CharSequence)replyText)) {
            this.persistMessageBox = false;
        }
        this.newActivity = false;
        DownloadManager.registerDownloadTaskCallbacks(this);
        this.setToolbarTitle(this.getString(R.string.hs__conversation_header));
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        this.hsApiData = new HSApiData(context);
        this.hsStorage = this.hsApiData.storage;
        this.hsClient = this.hsApiData.client;
        this.hsMessagesListener = ((ConversationFlowFragment)this.getParentFragment()).getConversationFlowController();
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.extras = this.getArguments();
        this.extras.remove("message");
        this.chatLaunchSource = this.extras.getString("chatLaunchSource");
        this.helpshiftDelegate = SupportInternal.getDelegate();
        this.messagesListFooterView = (LinearLayout)inflater.inflate(D.layout.hs__messages_list_footer, null);
        this.footerMessage = (TextView)this.messagesListFooterView.findViewById(R.id.footer_message);
        return inflater.inflate(D.layout.hs__messages_fragment, container, false);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    @Override
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.messagesListView = (ListView)view.findViewById(D.id.hs__messagesList);
        this.replyField = (EditText)view.findViewById(D.id.hs__messageText);
        final ImageButton addReply = (ImageButton)view.findViewById(D.id.hs__sendMessageBtn);
        this.confirmationBox = (LinearLayout)view.findViewById(D.id.hs__confirmation);
        this.newConversationBox = (LinearLayout)this.messagesListFooterView.findViewById(D.id.hs__new_conversation);
        this.messageBox = (LinearLayout)view.findViewById(D.id.relativeLayout1);
        Button solvedBtn = (Button)view.findViewById(16908313);
        Button unsolvedBtn = (Button)view.findViewById(16908314);
        this.newConversationBtn = (Button)this.messagesListFooterView.findViewById(D.id.hs__new_conversation_btn);
        this.csatViewStub = (ViewStub)this.messagesListFooterView.findViewById(D.id.csat_view_stub);
        solvedBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HSMessagesFragment.this.resolutionAccepted();
            }
        });
        unsolvedBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HelpshiftContext.setViewState("message-filing");
                HSMessagesFragment.this.refreshMessages();
                HSMessagesFragment.this.persistMessageBox = true;
                HSMessagesFragment.this.showMessageBox();
                if (HSMessagesFragment.this.replyField.getText().toString().trim().length() == 0) {
                    HSMessagesFragment.this.showKeyboard((View)HSMessagesFragment.this.replyField);
                }
                HSMessagesFragment.this.sendResolutionEvent(false);
                HSMessagesFragment.this.hsMessagesListener.rejectResolution();
                if (HSMessagesFragment.this.helpshiftDelegate != null) {
                    HSMessagesFragment.this.helpshiftDelegate.userRepliedToConversation("User rejected the solution");
                }
            }
        });
        this.newConversationBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                HSMessagesFragment.this.addListViewBottomPadding(true);
                HSMessagesFragment.this.hsStorage.setArchivedConversation("", HSMessagesFragment.this.hsApiData.getProfileId());
                HSMessagesFragment.this.hsMessagesListener.startNewConversation();
            }
        });
        this.messagesListView.setDivider(null);
        this.adapter = new MessagesAdapter(this, 17367043, this.messagesList);
        TextView dummyTextView = new TextView(this.getContext());
        this.messagesListView.addFooterView((View)dummyTextView);
        this.messagesListView.setAdapter((ListAdapter)this.adapter);
        this.messagesListView.removeFooterView((View)dummyTextView);
        this.issueId = this.extras.getString("issueId");
        this.showAgentName = Issue.isShowAgentNameEnabled(this.issueId);
        this.refreshStatus();
        this.refreshMessages();
        this.messagesListView.setSelection(this.adapter.getCount() - 1);
        if (this.replyField.getText().length() == 0) {
            addReply.setEnabled(false);
            addReply.setAlpha(64);
            Styles.setSendMessageButtonIconColor(this.getContext(), addReply.getDrawable());
        } else {
            addReply.setEnabled(true);
            addReply.setAlpha(255);
            Styles.setSendMessageButtonActiveIconColor(this.getContext(), addReply.getDrawable());
        }
        addReply.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                String replyText = HSMessagesFragment.this.replyField.getText().toString().trim();
                if (!TextUtils.isEmpty((CharSequence)replyText)) {
                    HSMessagesFragment.this.replyField.setText((CharSequence)"");
                    HSMessagesFragment.this.addMessage(HSMessagesFragment.this.replyHandler, HSMessagesFragment.this.replyFailHandler, HSMessagesFragment.this.issueId, replyText, "txt", "");
                    if (HSMessagesFragment.this.helpshiftDelegate != null) {
                        HSMessagesFragment.this.helpshiftDelegate.userRepliedToConversation(replyText);
                    }
                    try {
                        JSONObject eventData = new JSONObject();
                        eventData.put("type", (Object)"txt");
                        eventData.put("body", (Object)replyText);
                        eventData.put("id", (Object)HSMessagesFragment.this.issueId);
                        HSFunnel.pushEvent("m", eventData);
                    }
                    catch (JSONException e) {
                        Log.d((String)HSMessagesFragment.TAG, (String)"JSONException", (Throwable)e);
                    }
                }
            }
        });
        this.replyField.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 4) {
                    addReply.performClick();
                }
                return false;
            }
        });
        this.replyField.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
                if (start != 0 || before != 0 || count != 0) {
                    HSMessagesFragment.this.persistMessageBox = true;
                }
                if (s.length() == 0) {
                    addReply.setEnabled(false);
                    addReply.setAlpha(64);
                    Styles.setSendMessageButtonIconColor(HSMessagesFragment.this.getContext(), addReply.getDrawable());
                } else {
                    addReply.setEnabled(true);
                    addReply.setAlpha(255);
                    Styles.setSendMessageButtonActiveIconColor(HSMessagesFragment.this.getContext(), addReply.getDrawable());
                }
            }
        });
    }

    private void addListViewBottomPadding(boolean add) {
        if (this.messagesListView != null) {
            int topPadding = (int)(Styles.dpToPx(this.getContext(), this.getResources().getDimension(R.dimen.activity_vertical_margin_small)) + 0.5f);
            int bottomPadding = 0;
            if (add) {
                bottomPadding = (int)((float)((int)Styles.dpToPx(this.getContext(), this.getResources().getDimension(R.dimen.activity_vertical_margin_medium))) + 0.5f);
            }
            this.messagesListView.setPadding(0, topPadding, 0, bottomPadding);
            this.messagesListView.invalidate();
        }
    }

    private void resolutionAccepted() {
        this.replyField.setText((CharSequence)"");
        this.hsStorage.storeReply("", this.hsApiData.getProfileId());
        this.sendResolutionEvent(true);
        this.persistMessageBox = false;
        this.refreshStatus();
        this.hsMessagesListener.acceptResolution();
        if (this.helpshiftDelegate != null) {
            this.helpshiftDelegate.userRepliedToConversation("User accepted the solution");
        }
    }

    private void sendResolutionEvent(Boolean accepted) {
        this.hsStorage.clearAndUpdateActiveConversation(this.issueId, this.hsApiData.getProfileId());
        try {
            JSONObject eventData = new JSONObject();
            eventData.put("id", (Object)this.issueId);
            String messageType = "";
            if (accepted.booleanValue()) {
                HSFunnel.pushEvent("y", eventData);
                messageType = "ca";
            } else {
                HSFunnel.pushEvent("n", eventData);
                messageType = "ncr";
            }
            this.addMessage(this.replyHandler, this.replyFailHandler, this.issueId, "", messageType, "");
            this.hsApiData.setCSatState(this.issueId, HSApiData.HS_ISSUE_CSAT_STATE.CSAT_APPLICABLE);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSONException", (Throwable)e);
        }
    }

    public void onStart() {
        super.onStart();
        this.addVisibleFragment();
        if (!this.selectImage && !this.isChangingConfigurations()) {
            try {
                JSONObject eventData = new JSONObject();
                eventData.put("id", (Object)this.issueId);
                HSFunnel.pushEvent("c", eventData);
            }
            catch (JSONException e) {
                Log.d((String)TAG, (String)"JSONException", (Throwable)e);
            }
        }
    }

    @Override
    public void onStop() {
        super.onStop();
        this.removeVisibleFragment();
        this.setToolbarTitle(this.getString(R.string.hs__help_header));
    }

    public void replyConfirmation(String messageId, Boolean accepted, final int position) {
        HSMsg msgData = this.messagesList.get(position);
        msgData.clickable = false;
        msgData.inProgress = true;
        Message.setInProgress(msgData.id, true);
        this.adapter.notifyDataSetChanged();
        Handler replySysHandler = new Handler(){

            public void handleMessage(android.os.Message msg) {
                HSMsg msgData = (HSMsg)HSMessagesFragment.this.messagesList.get(position);
                msgData.clickable = false;
                msgData.invisible = true;
                msgData.inProgress = false;
                HSMessagesFragment.this.adapter.notifyDataSetChanged();
                Message.setInvisible(msgData.id, true);
                Message.setInProgress(msgData.id, false);
                HSMessagesFragment.this.renderReplyMsg(msg);
            }
        };
        Handler replySysFailHandler = new Handler(){

            public void handleMessage(android.os.Message msg) {
                HSMsg msgData = (HSMsg)HSMessagesFragment.this.messagesList.get(position);
                msgData.clickable = true;
                msgData.inProgress = false;
                Message.setInProgress(msgData.id, false);
                HSMessagesFragment.this.adapter.notifyDataSetChanged();
                HashMap result = (HashMap)msg.obj;
                Integer status = (Integer)result.get("status");
                if (!HSMessagesFragment.this.isDetached()) {
                    SnackbarUtil.showErrorSnackbar(status, HSMessagesFragment.this.getView());
                }
            }
        };
        if (accepted.booleanValue()) {
            this.addMessage(replySysHandler, replySysFailHandler, this.issueId, "", "ca", messageId);
        } else {
            this.addMessage(replySysHandler, replySysFailHandler, this.issueId, "", "ncr", messageId);
        }
        try {
            JSONObject eventData = new JSONObject();
            eventData.put("id", (Object)this.issueId);
            if (accepted.booleanValue()) {
                HSFunnel.pushEvent("y", eventData);
            } else {
                HSFunnel.pushEvent("n", eventData);
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"JSONException", (Throwable)e);
        }
    }

    public void replyReview(String messageId, final int position) {
        HSMsg msgData = this.messagesList.get(position);
        msgData.clickable = false;
        msgData.inProgress = true;
        Message.setInProgress(msgData.id, true);
        this.adapter.notifyDataSetChanged();
        Handler replySysHandler = new Handler(){

            public void handleMessage(android.os.Message msg) {
                HSMsg msgData = (HSMsg)HSMessagesFragment.this.messagesList.get(position);
                msgData.clickable = false;
                msgData.invisible = true;
                msgData.inProgress = false;
                HSMessagesFragment.this.adapter.notifyDataSetChanged();
                Message.setInProgress(msgData.id, false);
                Message.setInvisible(msgData.id, true);
                HSMessagesFragment.this.renderReplyMsg(msg);
                try {
                    JSONObject eventData = new JSONObject();
                    eventData.put("type", (Object)"conversation");
                    HSFunnel.pushEvent("r", eventData);
                    if (HSMessagesFragment.this.helpshiftDelegate != null) {
                        HSMessagesFragment.this.helpshiftDelegate.userRepliedToConversation("User reviewed the app");
                    }
                    String rurl = HSMessagesFragment.this.hsStorage.getConfig().optString("rurl", "");
                    if (!TextUtils.isEmpty((CharSequence)(rurl = rurl.trim()))) {
                        HSMessagesFragment.this.hsApiData.disableReview();
                        HSMessagesFragment.this.gotoApp(rurl);
                    }
                }
                catch (JSONException e) {
                    Log.d((String)HSMessagesFragment.TAG, (String)e.getMessage(), (Throwable)e);
                }
            }
        };
        Handler replySysFailHandler = new Handler(){

            public void handleMessage(android.os.Message msg) {
                HSMsg msgData = (HSMsg)HSMessagesFragment.this.messagesList.get(position);
                msgData.clickable = true;
                msgData.inProgress = false;
                Message.setInProgress(msgData.id, false);
                HSMessagesFragment.this.adapter.notifyDataSetChanged();
                HashMap result = (HashMap)msg.obj;
                Integer status = (Integer)result.get("status");
                if (!HSMessagesFragment.this.isDetached()) {
                    SnackbarUtil.showErrorSnackbar(status, HSMessagesFragment.this.getView());
                }
            }
        };
        this.addMessage(replySysHandler, replySysFailHandler, this.issueId, "", "ar", messageId);
    }

    public void sendScreenshot(String screenshotPath, int position) {
        HSMsg msgData;
        if (position == 0) {
            msgData = AttachmentUtil.addAndGetLocalRscMsg(this.hsStorage, this.issueId, screenshotPath);
            this.messagesList.add(msgData);
        } else {
            msgData = this.messagesList.get(position);
            msgData.screenshot = screenshotPath;
        }
        Message.setScreenshot(msgData.id, screenshotPath);
        this.adapter.notifyDataSetChanged();
        this.attachImage(this.messagesList.indexOf(msgData));
    }

    public void removeScreenshot(int position) {
        HSMsg msgData = this.messagesList.get(position);
        if (msgData.id.startsWith("localRscMessage_")) {
            IssuesDataSource.deleteMessage(msgData.id);
            this.messagesList.remove(position);
        } else {
            Message.setScreenshot(msgData.id, "");
            msgData.screenshot = "";
        }
        this.adapter.notifyDataSetChanged();
    }

    public void selectImagePopup(int position) {
        this.hsMessagesListener.pickImage(position);
    }

    public void attachImage(final int position) {
        String profileId = this.hsApiData.getProfileId();
        HSMsg msgData = this.messagesList.get(position);
        msgData.clickable = false;
        msgData.inProgress = true;
        Message.setInProgress(msgData.id, true);
        this.adapter.notifyDataSetChanged();
        Handler replySysHandler = new Handler(){

            public void handleMessage(android.os.Message msg) {
                HSMsg msgData = (HSMsg)HSMessagesFragment.this.messagesList.get(position);
                HashMap result = (HashMap)msg.obj;
                JSONObject message = (JSONObject)result.get("response");
                try {
                    JSONObject eventData = new JSONObject();
                    eventData.put("type", (Object)"url");
                    eventData.put("body", (Object)message.getJSONObject("meta").getJSONArray("attachments").getJSONObject(0).getString("url"));
                    eventData.put("id", (Object)HSMessagesFragment.this.issueId);
                    HSFunnel.pushEvent("m", eventData);
                    if (HSMessagesFragment.this.helpshiftDelegate != null) {
                        HSMessagesFragment.this.helpshiftDelegate.userRepliedToConversation("User sent a screenshot");
                    }
                }
                catch (JSONException e) {
                    Log.d((String)HSMessagesFragment.TAG, (String)"Error while getting screenshot url", (Throwable)e);
                }
                try {
                    AttachmentUtil.copyAttachment(HSMessagesFragment.this.getContext(), HSMessagesFragment.this.hsApiData, msgData.screenshot, msgData.id, 0);
                }
                catch (IOException e) {
                    Log.d((String)HSMessagesFragment.TAG, (String)"Saving uploaded screenshot", (Throwable)e);
                }
                if (msgData.id.startsWith("localRscMessage_")) {
                    IssuesDataSource.deleteMessage(msgData.id);
                    HSMessagesFragment.this.messagesList.remove(position);
                } else {
                    msgData.inProgress = false;
                    msgData.invisible = true;
                    msgData.screenshot = "";
                    msgData.clickable = false;
                    Message.setInProgress(msgData.id, false);
                    Message.setInvisible(msgData.id, true);
                    Message.setScreenshot(msgData.id, "");
                }
                HSMessagesFragment.this.adapter.notifyDataSetChanged();
                HSMessagesFragment.this.renderReplyMsg(msg);
            }
        };
        Handler replySysFailHandler = new Handler(){

            public void handleMessage(android.os.Message msg) {
                HSMsg msgData = (HSMsg)HSMessagesFragment.this.messagesList.get(position);
                msgData.clickable = true;
                msgData.inProgress = false;
                Message.setInProgress(msgData.id, false);
                HSMessagesFragment.this.adapter.notifyDataSetChanged();
                HSMessagesFragment.this.messagesList.set(position, msgData);
                HashMap result = (HashMap)msg.obj;
                Integer status = (Integer)result.get("status");
                if (!HSMessagesFragment.this.isDetached()) {
                    SnackbarUtil.showErrorSnackbar(status, HSMessagesFragment.this.getView());
                }
            }
        };
        this.hsClient.addScMessage(replySysHandler, replySysFailHandler, profileId, this.issueId, "", "sc", msgData.id, msgData.screenshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadAttachment(String urlStr, String messageId, int attachId) throws IOException {
        URL url = new URL(urlStr);
        InputStream input = null;
        FileOutputStream output = null;
        try {
            String outputName = messageId + attachId + "-thumbnail";
            File outputFile = new File(this.getContext().getFilesDir(), outputName);
            String fname = outputFile.getAbsolutePath();
            if (!outputFile.exists()) {
                int read;
                this.hsApiData.storeFile(outputName);
                input = url.openConnection().getInputStream();
                output = this.getContext().openFileOutput(outputName, 0);
                byte[] data = new byte[1024];
                while ((read = input.read(data)) != -1) {
                    output.write(data, 0, read);
                }
            }
            String string2 = fname;
            return string2;
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }

    public void downloadAdminAttachment(JSONObject attachment, int position, int downloadType) {
        if (ApplicationUtil.isPermissionGranted(this.getContext(), "android.permission.WRITE_EXTERNAL_STORAGE") || downloadType == 8) {
            this.startAdminAttachmentDownload(attachment, position, downloadType);
        } else {
            int apiVersion = ApplicationUtil.getDeviceApiVersion();
            if (apiVersion < 9) {
                if (!this.isDetached()) {
                    SnackbarUtil.showSnackbar(this.getView(), R.string.hs__permission_not_granted, -1);
                }
            } else if (apiVersion < 23) {
                this.startDownloadWithSystemService(attachment);
            } else {
                InputUtil.hideKeyboard(this.getContext(), (View)this.replyField);
                this.pendingDownloadInfo = new HashMap();
                this.pendingDownloadInfo.put("attachment", attachment);
                this.pendingDownloadInfo.put("position", position);
                this.pendingDownloadInfo.put("downloadType", downloadType);
                this.requestStoragePermission();
            }
        }
    }

    private void startAdminAttachmentDownload(JSONObject attachment, int position, int downloadType) {
        HSMsg msgData = this.messagesList.get(position);
        switch (downloadType) {
            case 6: {
                msgData.state = 1;
                this.updateView(msgData);
                break;
            }
            case 7: {
                msgData.state = 2;
                this.updateView(msgData);
                break;
            }
            case 8: {
                if (this.hsStorage.isDownloadActive(msgData.id)) {
                    return;
                }
                String thumbnailPath = this.hsStorage.getFilePathForThumbnail(msgData.id);
                File thumbnail = new File(thumbnailPath);
                if (!thumbnail.exists()) break;
                return;
            }
        }
        DownloadManager.startDownload(attachment, position, msgData.id, this.issueId, downloadType);
    }

    @TargetApi(value=11)
    private void startDownloadWithSystemService(JSONObject attachment) {
        android.app.DownloadManager downloadManager = (android.app.DownloadManager)this.getContext().getSystemService("download");
        Uri attachmentUri = Uri.parse((String)attachment.optString("url", ""));
        DownloadManager.Request request = new DownloadManager.Request(attachmentUri);
        if (ApplicationUtil.getDeviceApiVersion() >= 11) {
            request.setNotificationVisibility(1);
        }
        downloadManager.enqueue(request);
        if (!this.isDetached()) {
            SnackbarUtil.showSnackbar(this.getView(), R.string.hs__starting_download, -1);
        }
    }

    private void requestStoragePermission() {
        this.showRationaleSnackbar = PermissionUtil.requestPermissions(this, new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"}, 90, (View)this.replyField);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (requestCode == 90) {
            if (grantResults.length == 1 && grantResults[0] == 0) {
                this.downloadAdminAttachment((JSONObject)this.pendingDownloadInfo.get("attachment"), (Integer)this.pendingDownloadInfo.get("position"), (Integer)this.pendingDownloadInfo.get("downloadType"));
            } else {
                this.permissionDeniedSnackbar = Snackbar.make((View)this.replyField, (int)R.string.hs__permission_denied_message, (int)-1).setAction(R.string.hs__permission_denied_snackbar_action, new View.OnClickListener(){

                    public void onClick(View v) {
                        PermissionUtil.showSettingsPage(HSMessagesFragment.this.getContext());
                    }
                });
                this.permissionDeniedSnackbar.show();
            }
        } else {
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        }
    }

    public void launchAttachment(HSMsg msg) {
        try {
            JSONObject attachmentObj = new JSONObject(msg.body);
            String contentType = attachmentObj.optString("content-type", "");
            String filePath = msg.type.equals("admin_attachment_generic") ? this.hsStorage.getFilePathForGenericAttachment(msg.id) : this.hsStorage.getFilePathForImage(msg.id);
            File file = new File(filePath);
            if (file.exists()) {
                Uri uri = Uri.fromFile((File)file);
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setDataAndType(uri, contentType);
                if (intent.resolveActivity(this.getContext().getPackageManager()) != null) {
                    this.startActivity(intent);
                } else if (this.helpshiftDelegate != null) {
                    this.helpshiftDelegate.displayAttachmentFile(file);
                } else if (!this.isDetached()) {
                    SnackbarUtil.showErrorSnackbar(4, this.getView());
                }
            } else if (!this.isDetached()) {
                SnackbarUtil.showErrorSnackbar(5, this.getView());
            }
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"launchAttachment : ", (Throwable)e);
        }
    }

    public void updateView(HSMsg msgData) {
        int start = this.messagesListView.getFirstVisiblePosition();
        int end = this.messagesListView.getLastVisiblePosition();
        for (int i = start; i <= end; ++i) {
            if (!msgData.equals(this.messagesListView.getItemAtPosition(i))) continue;
            View view = this.messagesListView.getChildAt(i - start);
            this.adapter.getView(i, view, (ViewGroup)this.messagesListView);
            break;
        }
    }

    @TargetApi(value=13)
    public void onCreateContextMenu(ContextMenu menu2, View v, ContextMenu.ContextMenuInfo menuInfo) {
        menu2.add(0, v.getId(), 0, R.string.hs__copy);
        TextView copyTextView = (TextView)v;
        String copyText = copyTextView.getText().toString();
        if (Build.VERSION.SDK_INT >= 13) {
            ClipboardManager clipboard = (ClipboardManager)this.getContext().getSystemService("clipboard");
            ClipData clip = ClipData.newPlainText((CharSequence)"Copy Text", (CharSequence)copyText);
            clipboard.setPrimaryClip(clip);
        } else {
            android.text.ClipboardManager clipboard = (android.text.ClipboardManager)this.getContext().getSystemService("clipboard");
            clipboard.setText((CharSequence)copyText);
        }
    }

    @Override
    public void onDownloadTaskPaused(int position, String msgId, String issueId, int downloadType) {
    }

    @Override
    public void onDownloadTaskResumed(int position, String msgId, String issueId, int downloadType) {
    }

    @Override
    public void onDownloadTaskComplete(String filePath, int position, String msgId, String issueId, int downloadType) {
        if (issueId.equals(this.issueId)) {
            HSMsg msgData = this.messagesList.get(position);
            if (msgId.equals(msgData.id)) {
                switch (downloadType) {
                    case 6: {
                        msgData.state = 3;
                        break;
                    }
                    case 7: {
                        msgData.state = 3;
                        msgData.screenshot = filePath;
                        break;
                    }
                    case 8: {
                        msgData.state = 1;
                        msgData.screenshot = filePath;
                    }
                }
                this.updateView(msgData);
                if (this.isResumed() && downloadType != 8) {
                    this.launchAttachment(msgData);
                }
            }
        }
    }

    @Override
    public void onDownloadTaskFailed(int position, String msgId, String issueId, int downloadType) {
        if (issueId.equals(this.issueId)) {
            HSMsg msgData = this.messagesList.get(position);
            if (msgId.equals(msgData.id)) {
                switch (downloadType) {
                    case 6: {
                        msgData.state = 0;
                        this.updateView(msgData);
                        break;
                    }
                    case 7: {
                        msgData.state = 1;
                        this.updateView(msgData);
                    }
                }
            }
        }
    }

    @Override
    public void onProgressChanged(double progress, int position, String msgId, String issueId, int downloadType) {
        if (issueId.equals(this.issueId)) {
            HSMsg msgData = this.messagesList.get(position);
            if (msgId.equals(msgData.id)) {
                if (downloadType == 6) {
                    msgData.state = 2;
                    int start = this.messagesListView.getFirstVisiblePosition();
                    int end = this.messagesListView.getLastVisiblePosition();
                    for (int i = start; i <= end; ++i) {
                        if (!msgData.equals(this.messagesListView.getItemAtPosition(i))) continue;
                        View view = this.messagesListView.getChildAt(i - start);
                        ProgressBar progressBar = (ProgressBar)view.findViewById(16908301);
                        progressBar.setProgress((int)progress);
                        this.adapter.getView(i, view, (ViewGroup)this.messagesListView);
                        break;
                    }
                } else if (downloadType == 7 && msgData.state != 2) {
                    msgData.state = 2;
                    this.updateView(msgData);
                }
            }
        }
    }

    public void retryMessage(final String id2) {
        try {
            JSONObject failedMessage = this.hsApiData.storage.popFailedMessage(id2, this.hsApiData.getProfileId());
            if (failedMessage == null) {
                return;
            }
            JSONObject tempMess = new JSONObject(failedMessage, HSJSONUtils.getJSONObjectKeys(failedMessage));
            tempMess.put("state", 1);
            JSONArray messages = this.hsApiData.getMessagesWithFails(this.issueId);
            messages.put((Object)tempMess);
            this.refreshMessages(messages);
            this.hsApiData.storage.storeFailedMessage(tempMess, this.hsApiData.getProfileId());
            Handler addMessageHandler = new Handler(){

                public void handleMessage(android.os.Message msg) {
                    super.handleMessage(msg);
                    try {
                        ((HSMessagesFragment)HSMessagesFragment.this).hsApiData.storage.popFailedMessage(id2, HSMessagesFragment.this.hsApiData.getProfileId());
                    }
                    catch (JSONException e) {
                        Log.d((String)HSMessagesFragment.TAG, (String)"addMessageHandler", (Throwable)e);
                    }
                    HSMessagesFragment.this.refreshMessages();
                }
            };
            this.addMessage(addMessageHandler, addMessageHandler, failedMessage.getString("issue_id"), failedMessage.getString("body"), failedMessage.getString("type"), failedMessage.getString("refers"), failedMessage.optInt("state", 0) - 1);
        }
        catch (JSONException e) {
            Log.d((String)TAG, (String)"retryMessage", (Throwable)e);
        }
    }

    private void addMessage(Handler success, Handler failure, String issueId, String messageText, String type, String refers) {
        this.hsStorage.setScreenShotDraft(false);
        if (!type.equals("ar")) {
            this.hsApiData.setCSatState(issueId, HSApiData.HS_ISSUE_CSAT_STATE.CSAT_NOT_APPLICABLE);
        }
        this.hsApiData.addMessage(success, failure, issueId, messageText, type, refers);
    }

    private void addMessage(Handler success, Handler failure, String issueId, String messageText, String type, String refers, int failedState) {
        this.hsStorage.setScreenShotDraft(false);
        if (!type.equals("ar")) {
            this.hsApiData.setCSatState(issueId, HSApiData.HS_ISSUE_CSAT_STATE.CSAT_NOT_APPLICABLE);
        }
        this.hsApiData.addMessage(success, failure, issueId, messageText, type, refers, failedState);
    }

    public LinearLayout getMessageBox() {
        return this.messageBox;
    }

    private class DownloadImagesTask
    extends AsyncTask<HashMap, Void, HashMap> {
        private DownloadImagesTask() {
        }

        protected HashMap doInBackground(HashMap ... imagesData) {
            HashMap imageData = imagesData[0];
            String url = (String)imageData.get("url");
            String messageId = (String)imageData.get("messageId");
            int attachId = (Integer)imageData.get("attachId");
            int position = (Integer)imageData.get("position");
            HashMap<String, Object> result = new HashMap<String, Object>();
            try {
                String filePath = HSMessagesFragment.this.downloadAttachment(url, messageId, attachId);
                result.put("success", true);
                result.put("filepath", filePath);
                result.put("position", position);
                return result;
            }
            catch (IOException e) {
                Log.d((String)HSMessagesFragment.TAG, (String)"Downloading image", (Throwable)e);
                result.put("success", false);
                return result;
            }
        }

        protected void onPostExecute(HashMap result) {
            if (((Boolean)result.get("success")).booleanValue()) {
                int position = (Integer)result.get("position");
                HSMsg msgData = (HSMsg)HSMessagesFragment.this.messagesList.get(position);
                msgData.screenshot = (String)result.get("filepath");
                HSMessagesFragment.this.adapter.notifyDataSetChanged();
            }
        }
    }
}

