/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import com.helpshift.support.AlertToRateAppListener;
import com.helpshift.support.D;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSFunnel;
import com.helpshift.support.HSStorage;
import com.helpshift.support.Log;
import com.helpshift.support.activities.ParentActivity;
import com.helpshift.support.util.HSActivityUtil;
import java.io.Serializable;
import org.json.JSONException;

public final class HSReviewFragment
extends DialogFragment {
    private static AlertToRateAppListener alertToRateAppListener;
    private final String TAG = "HelpshiftDebug";
    private HSApiData data;
    private HSStorage storage;
    private boolean disableReview = true;
    private String rurl = "";

    protected static void setAlertToRateAppListener(AlertToRateAppListener listener) {
        alertToRateAppListener = listener;
    }

    public Dialog onCreateDialog(Bundle savedInstanceState) {
        FragmentActivity activity = this.getActivity();
        Bundle extras = activity.getIntent().getExtras();
        if (extras != null) {
            this.disableReview = extras.getBoolean("disableReview", true);
            this.rurl = extras.getString("rurl");
        }
        this.data = new HSApiData((Context)activity);
        this.storage = this.data.storage;
        return this.initAlertDialog(activity);
    }

    private void gotoApp(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)url.trim()));
            if (intent.resolveActivity(this.getContext().getPackageManager()) != null) {
                this.getContext().startActivity(intent);
            }
        }
    }

    public void onCancel(DialogInterface dialog) {
        HSFunnel.pushAppReviewedEvent("later");
        this.sendAlertToRateAppAction(2);
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.disableReview) {
            this.data.disableReview();
        }
        this.getActivity().finish();
    }

    private void sendAlertToRateAppAction(int action) {
        if (alertToRateAppListener != null) {
            alertToRateAppListener.onAction(action);
        }
        alertToRateAppListener = null;
    }

    private Dialog initAlertDialog(FragmentActivity activity) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
        builder.setMessage(D.string.hs__review_message);
        AlertDialog dialog = builder.create();
        dialog.setTitle(D.string.hs__review_title);
        dialog.setCanceledOnTouchOutside(false);
        dialog.setButton(-1, (CharSequence)this.getResources().getString(D.string.hs__rate_button), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                try {
                    if (TextUtils.isEmpty((CharSequence)HSReviewFragment.this.rurl)) {
                        HSReviewFragment.this.rurl = HSReviewFragment.this.storage.getConfig().optString("rurl", "");
                    }
                    HSReviewFragment.this.rurl = HSReviewFragment.this.rurl.trim();
                    if (!TextUtils.isEmpty((CharSequence)HSReviewFragment.this.rurl)) {
                        HSReviewFragment.this.gotoApp(HSReviewFragment.this.rurl);
                    }
                }
                catch (JSONException e) {
                    Log.d("HelpshiftDebug", e.getMessage());
                }
                HSFunnel.pushAppReviewedEvent("reviewed");
                HSReviewFragment.this.sendAlertToRateAppAction(0);
            }
        });
        dialog.setButton(-3, (CharSequence)this.getResources().getString(D.string.hs__feedback_button), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                HSFunnel.pushAppReviewedEvent("feedback");
                HSReviewFragment.this.sendAlertToRateAppAction(1);
                if (!HSReviewFragment.this.storage.getIsConversationShowing().booleanValue()) {
                    Intent i = new Intent(HSReviewFragment.this.getContext(), ParentActivity.class);
                    i.putExtra("support_mode", 1);
                    i.putExtra("decomp", true);
                    i.putExtra("showInFullScreen", (Serializable)HSActivityUtil.isFullScreen((Activity)HSReviewFragment.this.getActivity()));
                    i.putExtra("chatLaunchSource", "support");
                    i.putExtra("isRoot", true);
                    i.putExtra("search_performed", true);
                    HSReviewFragment.this.getActivity().startActivity(i);
                }
            }
        });
        dialog.setButton(-2, (CharSequence)this.getResources().getString(D.string.hs__review_close_button), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                HSFunnel.pushAppReviewedEvent("later");
                HSReviewFragment.this.sendAlertToRateAppAction(2);
            }
        });
        return dialog;
    }
}

