/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import com.helpshift.support.Faq;
import com.helpshift.support.RankComparator;
import com.helpshift.support.external.DoubleMetaphone;
import com.helpshift.support.util.HSTransliterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HSSearch {
    public static final String TAG = "HelpShiftDebug";
    private static DoubleMetaphone metaPhone = new DoubleMetaphone();
    private static boolean indexing = false;
    private static boolean markDeinit = false;

    public static void init() {
        if (!indexing) {
            Thread indexThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    HSTransliterator.init();
                }
            });
            indexThread.setDaemon(true);
            indexThread.start();
        }
    }

    public static void deinit() {
        if (!indexing) {
            HSTransliterator.deinit();
        } else {
            markDeinit = true;
        }
    }

    public static String stripHtml(String html) {
        return html.replaceAll("<[^>]+>", "");
    }

    public static ArrayList<String> generateTokens(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        Pattern p = Pattern.compile("\\w+");
        Matcher m = p.matcher(str);
        while (m.find()) {
            if (m.group(0).length() <= 2) continue;
            tokens.add(m.group(0));
        }
        return tokens;
    }

    public static ArrayList<String> generateTokensForSearchQuery(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        Pattern p = Pattern.compile("\\w+");
        Matcher m = p.matcher(str);
        while (m.find()) {
            if (m.group(0).length() <= 2 && str.length() <= 2) continue;
            tokens.add(m.group(0));
        }
        return tokens;
    }

    public static ArrayList<String> generateNgrams(int min, int max, String str) {
        ArrayList<String> output = new ArrayList<String>();
        for (int i = min; i < str.length() && i <= max; ++i) {
            output.add(str.substring(0, i));
        }
        return output;
    }

    public static ArrayList<HashMap<String, String>> generateVariations(final String word, final String wordType) {
        HashSet<HashMap> output = new HashSet<HashMap>();
        output.add(new HashMap(){
            {
                this.put("value", word);
                this.put("type", wordType);
            }
        });
        ArrayList<String> ngrams = HSSearch.generateNgrams(2, 10, word);
        for (final String ngram : ngrams) {
            output.add(new HashMap(){
                {
                    this.put("value", ngram);
                    this.put("type", "ngram");
                }
            });
        }
        output.add(new HashMap(){
            {
                this.put("value", metaPhone.encode(word).toLowerCase());
                this.put("type", "metaphone");
            }
        });
        return new ArrayList<HashMap<String, String>>(output);
    }

    public static ArrayList<HashMap<String, String>> generateSearchVariations(final String word) {
        HashSet<HashMap> output = new HashSet<HashMap>();
        output.add(new HashMap(){
            {
                this.put("value", word);
                this.put("type", "word");
            }
        });
        output.add(new HashMap(){
            {
                this.put("value", metaPhone.encode(word).toLowerCase());
                this.put("type", "metaphone");
            }
        });
        return new ArrayList<HashMap<String, String>>(output);
    }

    public static String sanitize(String str) {
        String htmlText = HSSearch.stripHtml(str);
        return HSTransliterator.unidecode(htmlText.toLowerCase());
    }

    public static int calcFreq(String type, String token) {
        if (token.length() == 1) {
            return 5;
        }
        if (type == "ngram") {
            return token.length();
        }
        if (type == "word") {
            return 30;
        }
        if (type == "metaphone") {
            return 1;
        }
        if (type == "imp_word") {
            return 300;
        }
        if (type == "tag_word") {
            return 150;
        }
        return 1;
    }

    public static HashMap<String, Integer> indexDocument(String title, String doc, List<String> tags) {
        ArrayList<HashMap<String, String>> output = new ArrayList<HashMap<String, String>>();
        for (String str : HSSearch.generateTokens(HSSearch.sanitize(doc))) {
            output.addAll(HSSearch.generateVariations(str, "word"));
        }
        for (String str : HSSearch.generateTokens(HSSearch.sanitize(title))) {
            output.addAll(HSSearch.generateVariations(str, "imp_word"));
        }
        for (String tag : tags) {
            output.addAll(HSSearch.generateVariations(HSSearch.sanitize(tag), "tag_word"));
        }
        HashMap<String, Integer> indexDoc = new HashMap<String, Integer>();
        for (HashMap hashMap : output) {
            String token = (String)hashMap.get("value");
            int tokenFreq = 0;
            if (indexDoc.containsKey(token)) {
                tokenFreq = indexDoc.get(token);
            }
            indexDoc.put(token, tokenFreq += HSSearch.calcFreq((String)hashMap.get("type"), token));
        }
        return indexDoc;
    }

    public static HashMap indexDocuments(ArrayList<Faq> docs) {
        HashMap<String, HashMap> fullIndex = new HashMap<String, HashMap>();
        if (indexing) {
            return null;
        }
        if (!HSTransliterator.isLoaded()) {
            HSTransliterator.init();
            markDeinit = true;
        }
        indexing = true;
        HashMap tfidfIndex = HSSearch.buildTfidfIndex(docs);
        HashMap fuzzyIndex = HSSearch.buildFuzzyIndex(docs);
        fullIndex.put("i", tfidfIndex);
        fullIndex.put("f", fuzzyIndex);
        indexing = false;
        if (markDeinit) {
            HSSearch.deinit();
            markDeinit = false;
        }
        return fullIndex;
    }

    protected static ArrayList<HashMap<String, String>> filterSearchQuery(ArrayList<HashMap<String, String>> queryTerms, HS_SEARCH_OPTIONS options) {
        ArrayList<HashMap<String, String>> terms = new ArrayList<HashMap<String, String>>();
        for (HashMap<String, String> termMap : queryTerms) {
            String type = termMap.get("type");
            if (options == HS_SEARCH_OPTIONS.FULL_SEARCH) {
                terms.add(termMap);
                continue;
            }
            if (options == HS_SEARCH_OPTIONS.METAPHONE_SEARCH && type.equals("metaphone")) {
                terms.add(termMap);
                continue;
            }
            if (options != HS_SEARCH_OPTIONS.KEYWORD_SEARCH || !type.equals("word") && !type.equals("ngram")) continue;
            terms.add(termMap);
        }
        return terms;
    }

    public static ArrayList<HashMap> queryDocs(String query, HashMap tfidf, HS_SEARCH_OPTIONS options) {
        HashMap<String, Double> docRanks = new HashMap<String, Double>();
        HashSet resultDocSet = null;
        HashMap matchedTermsMap = new HashMap();
        ArrayList<HashMap<String, String>> terms = new ArrayList<HashMap<String, String>>();
        for (String string2 : HSSearch.generateTokensForSearchQuery(HSSearch.sanitize(query))) {
            terms.addAll(HSSearch.filterSearchQuery(HSSearch.generateSearchVariations(string2), options));
        }
        if (tfidf != null) {
            for (HashMap hashMap : terms) {
                String term = (String)hashMap.get("value");
                String type = (String)hashMap.get("type");
                HashMap termDocMap = (HashMap)tfidf.get(term);
                if (termDocMap == null || termDocMap.keySet().size() <= 0) continue;
                for (String docId : termDocMap.keySet()) {
                    ArrayList<String> matchTerms = (ArrayList<String>)matchedTermsMap.get(docId);
                    if (matchTerms == null) {
                        matchTerms = new ArrayList<String>();
                    }
                    if (term.length() > 0) {
                        matchTerms.add(term);
                    }
                    matchedTermsMap.put(docId, matchTerms);
                    Double docTFID = (Double)termDocMap.get(docId);
                    Double docRank = docRanks.get(docId);
                    Double docContribution = docTFID * (double)HSSearch.calcFreq(type, term);
                    if (docRank != null) {
                        docRanks.put(docId, docRank + docContribution);
                        continue;
                    }
                    docRanks.put(docId, docContribution);
                }
                HashSet termDocSet = new HashSet();
                termDocSet.addAll(termDocMap.keySet());
                if (resultDocSet != null && !resultDocSet.isEmpty()) {
                    resultDocSet.addAll(termDocSet);
                    continue;
                }
                resultDocSet = new HashSet(termDocSet);
            }
        }
        if (resultDocSet == null || resultDocSet.isEmpty()) {
            RankComparator docRankComp = new RankComparator(docRanks);
            TreeMap<String, Double> treeMap = new TreeMap<String, Double>(docRankComp);
            treeMap.putAll(docRanks);
            return HSSearch.sortMatchedTermsMap(treeMap, matchedTermsMap);
        }
        if (resultDocSet.size() == 1) {
            HashMap<String, String> docIdTermsMap = new HashMap<String, String>();
            ArrayList<HashMap> arrayList = new ArrayList<HashMap>();
            String docId = (String)resultDocSet.iterator().next();
            docIdTermsMap.put("f", docId);
            docIdTermsMap.put("t", (String)matchedTermsMap.get(docId));
            arrayList.add(docIdTermsMap);
            return arrayList;
        }
        HashMap<String, Double> resultDocRanks = new HashMap<String, Double>();
        for (String docId : resultDocSet) {
            resultDocRanks.put(docId, docRanks.get(docId));
        }
        RankComparator rankComparator = new RankComparator(resultDocRanks);
        TreeMap<String, Double> sortedDocRanks = new TreeMap<String, Double>(rankComparator);
        sortedDocRanks.putAll(resultDocRanks);
        return HSSearch.sortMatchedTermsMap(sortedDocRanks, matchedTermsMap);
    }

    private static ArrayList<HashMap> sortMatchedTermsMap(TreeMap sortedDocRanks, HashMap matchedTermsMap) {
        ArrayList<HashMap> sortedResults = new ArrayList<HashMap>();
        Set sortedDocIds = sortedDocRanks.keySet();
        for (String docId : sortedDocIds) {
            HashMap<String, String> docIdTermsMap = new HashMap<String, String>();
            docIdTermsMap.put("f", docId);
            docIdTermsMap.put("t", (String)matchedTermsMap.get(docId));
            sortedResults.add(docIdTermsMap);
        }
        return sortedResults;
    }

    protected static HashMap buildTfidfIndex(ArrayList<Faq> docs) {
        HashMap termMap;
        Integer totalDocNum = docs.size();
        ArrayList indexedDocs = new ArrayList();
        Integer i = 0;
        for (Faq doc : docs) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("terms", HSSearch.indexDocument(doc.getTitle(), doc.getBody(), doc.getTags()));
            hashMap.put("id", i + "");
            i = i + 1;
            indexedDocs.add(hashMap);
        }
        HashMap<String, HashMap<String, Integer>> globalTerms = new HashMap<String, HashMap<String, Integer>>();
        for (HashMap hashMap : indexedDocs) {
            String string2 = (String)hashMap.get("id");
            HashMap terms = (HashMap)hashMap.get("terms");
            for (String term : terms.keySet()) {
                int termFreq = (Integer)terms.get(term);
                if (globalTerms.containsKey(term)) {
                    Integer docFreq;
                    termMap = (HashMap)globalTerms.get(term);
                    Integer maxFreq = (Integer)termMap.get("maxFreq");
                    if (maxFreq == null) {
                        maxFreq = 0;
                    }
                    docFreq = (docFreq = (Integer)termMap.get("docFreq")) == null ? Integer.valueOf(0) : Integer.valueOf(docFreq + 1);
                    if (maxFreq < termFreq) {
                        termMap.put("maxFreq", termFreq);
                    }
                    termMap.put("docFreq", docFreq);
                    globalTerms.put(term, termMap);
                    continue;
                }
                termMap = new HashMap();
                termMap.put("maxFreq", termFreq);
                termMap.put("docFreq", 1);
                globalTerms.put(term, termMap);
            }
        }
        HashMap<String, HashMap<String, Integer>> tfidf = new HashMap<String, HashMap<String, Integer>>();
        for (HashMap hashMap : indexedDocs) {
            String docId = (String)hashMap.get("id");
            HashMap terms = (HashMap)hashMap.get("terms");
            if (terms == null) continue;
            for (String term : terms.keySet()) {
                termMap = (HashMap)tfidf.get(term);
                if (termMap == null) {
                    termMap = new HashMap();
                }
                Integer localTf = (Integer)terms.get(term);
                HashMap globalTerm = (HashMap)globalTerms.get(term);
                Integer maxTf = (Integer)globalTerm.get("maxFreq");
                Integer docTf = (Integer)globalTerm.get("docFreq");
                Double tf = localTf / maxTf;
                Double idf = Math.log10(totalDocNum / docTf);
                termMap.put(docId, tf * idf);
                tfidf.put(term, termMap);
            }
        }
        return tfidf;
    }

    protected static HashMap buildFuzzyIndex(ArrayList<Faq> docs) {
        HashMap fuzzyIndex = new HashMap();
        int i = 0;
        for (Faq doc : docs) {
            String title = doc.getTitle();
            for (String token : HSSearch.generateTokens(HSSearch.sanitize(title))) {
                if ((token = token.toLowerCase()).length() <= 3) continue;
                HashMap<String, String> tokenMap = new HashMap<String, String>();
                tokenMap.put("w", token);
                tokenMap.put("id", i + "");
                String firstCharacter = token.substring(0, 1);
                ArrayList firstCharIndex = (ArrayList)fuzzyIndex.get(firstCharacter);
                if (firstCharIndex == null) {
                    firstCharIndex = new ArrayList();
                }
                firstCharIndex.add(tokenMap);
                fuzzyIndex.put(firstCharacter, firstCharIndex);
                String secondCharacter = token.substring(1, 2);
                ArrayList secondCharIndex = (ArrayList)fuzzyIndex.get(secondCharacter);
                if (secondCharIndex == null) {
                    secondCharIndex = new ArrayList();
                }
                secondCharIndex.add(tokenMap);
                fuzzyIndex.put(secondCharacter, secondCharIndex);
            }
            ++i;
        }
        return fuzzyIndex;
    }

    public static ArrayList<HashMap> getFuzzyMatches(String query, HashMap fuzzyIndex) {
        ArrayList<HashMap> resultArray = new ArrayList<HashMap>();
        if (fuzzyIndex != null) {
            HashMap<String, ArrayList<String>> faqIdsWithKeywords = new HashMap<String, ArrayList<String>>();
            for (String token : HSSearch.generateTokens(HSSearch.sanitize(query))) {
                String rootChar = token.substring(0, 1);
                ArrayList<String> neighbourChars = new ArrayList<String>(HSSearch.getNeighbourCharacters(rootChar));
                neighbourChars.add(rootChar);
                for (String character : neighbourChars) {
                    ArrayList wordsList = (ArrayList)fuzzyIndex.get(character);
                    if (wordsList == null) continue;
                    for (HashMap wordMap : wordsList) {
                        String wordToken = (String)wordMap.get("w");
                        float wordDistance = HSSearch.calculateWordDistance(wordToken, token);
                        if (!((double)wordDistance > 0.7)) continue;
                        String id2 = (String)wordMap.get("id");
                        ArrayList<String> matchWordList = (ArrayList<String>)faqIdsWithKeywords.get(id2);
                        if (matchWordList == null) {
                            matchWordList = new ArrayList<String>();
                        }
                        matchWordList.add(wordToken);
                        faqIdsWithKeywords.put(id2, matchWordList);
                    }
                }
            }
            Set docIds = faqIdsWithKeywords.keySet();
            for (String docId : docIds) {
                HashMap<String, String> docIdTermsMap = new HashMap<String, String>();
                docIdTermsMap.put("f", docId);
                docIdTermsMap.put("t", (String)faqIdsWithKeywords.get(docId));
                resultArray.add(docIdTermsMap);
            }
        }
        return resultArray;
    }

    private static List<String> getNeighbourCharacters(String inputCharacter) {
        HashMap<String, String[]> characterTable = new HashMap<String, String[]>();
        characterTable.put("a", new String[]{"q", "w", "s", "z"});
        characterTable.put("b", new String[]{"v", "h", "n"});
        characterTable.put("c", new String[]{"x", "f", "v"});
        characterTable.put("d", new String[]{"s", "z", "x"});
        characterTable.put("e", new String[]{"w", "s", "d", "r"});
        characterTable.put("f", new String[]{"d", "g", "c", "x"});
        characterTable.put("g", new String[]{"h", "f", "v", "b"});
        characterTable.put("h", new String[]{"g", "j", "b", "n"});
        characterTable.put("i", new String[]{"u", "o", "k", "j"});
        characterTable.put("j", new String[]{"m", "n", "h", "k"});
        characterTable.put("k", new String[]{"j", "l", "m"});
        characterTable.put("l", new String[]{"k", "p", "m"});
        characterTable.put("m", new String[]{"n", "b", "l"});
        characterTable.put("n", new String[]{"b", "j", "m"});
        characterTable.put("o", new String[]{"l", "k", "p"});
        characterTable.put("p", new String[]{"l", "o"});
        characterTable.put("q", new String[]{"w", "a"});
        characterTable.put("r", new String[]{"s", "d", "e", "f"});
        characterTable.put("s", new String[]{"a", "z", "d"});
        characterTable.put("t", new String[]{"r", "f", "g", "y"});
        characterTable.put("u", new String[]{"j", "h", "i", "y"});
        characterTable.put("v", new String[]{"c", "g", "b"});
        characterTable.put("w", new String[]{"q", "a", "s"});
        characterTable.put("x", new String[]{"z", "s", "c"});
        characterTable.put("y", new String[]{"g", "h", "t", "u"});
        characterTable.put("z", new String[]{"a", "s", "x"});
        if (characterTable.containsKey(inputCharacter)) {
            return Arrays.asList((Object[])characterTable.get(inputCharacter));
        }
        return new ArrayList<String>();
    }

    private static float calculateWordDistance(String originalString, String comparisionString) {
        originalString = originalString.trim();
        comparisionString = comparisionString.trim();
        originalString = originalString.toLowerCase();
        comparisionString = comparisionString.toLowerCase();
        int n = originalString.length();
        int m = comparisionString.length();
        if (n++ != 0 && m++ != 0) {
            int k;
            int[] d = new int[n * m];
            for (k = 0; k < n; ++k) {
                d[k] = k;
            }
            for (k = 0; k < m; ++k) {
                d[k * n] = k;
            }
            for (int i = 1; i < n; ++i) {
                for (int j = 1; j < m; ++j) {
                    int cost = originalString.charAt(i - 1) == comparisionString.charAt(j - 1) ? 0 : 1;
                    d[j * n + i] = HSSearch.smallestOf(d[(j - 1) * n + i] + 1, d[j * n + i - 1] + 1, d[(j - 1) * n + i - 1] + cost);
                    if (i <= 1 || j <= 1 || originalString.charAt(i - 1) != comparisionString.charAt(j - 2) || originalString.charAt(i - 2) != comparisionString.charAt(j - 1)) continue;
                    d[j * n + i] = HSSearch.smallestOf(d[j * n + i], d[(j - 2) * n + i - 2] + cost);
                }
            }
            int distance = d[n * m - 1];
            int maxLength = n > m ? n : m;
            return 1.0f - (float)distance / (float)maxLength;
        }
        return 0.0f;
    }

    private static int smallestOf(int a, int b, int c) {
        int min = a;
        if (b < min) {
            min = b;
        }
        if (c < min) {
            min = c;
        }
        return min;
    }

    private static int smallestOf(int a, int b) {
        int min = a;
        if (b < min) {
            min = b;
        }
        return min;
    }

    public static enum HS_SEARCH_OPTIONS {
        FULL_SEARCH,
        METAPHONE_SEARCH,
        KEYWORD_SEARCH;

    }
}

