/*
 * Decompiled with CFR 0.152.
 */
package com.helpshift.support;

import android.app.ActivityManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Build;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import com.helpshift.support.HSApiData;
import com.helpshift.support.HSLifecycleCallbacks;
import com.helpshift.support.util.HSNotification;
import com.helpshift.support.util.HSPolling;
import java.util.List;

public final class HSService
extends Service {
    private HSApiData data = null;
    public static final String TAG = "HelpShiftDebug";
    private Boolean foreground;
    private HSLifecycleCallbacks hsLifecycleCallbacks = null;
    private final IBinder hsBinder = new HSBinder();
    private Handler getCountHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (HSService.this.isAppOnForeground()) {
                if (!HSService.this.foreground.booleanValue() && notifCountPoller != null) {
                    notifCountPoller.resetInterval();
                }
                HSService.this.foreground = true;
                Handler notifHandler = HSNotification.getNotifHandler((Context)HSService.this, notifCountPoller);
                HSService.this.data.getNotificationData(notifHandler, new Handler());
            } else {
                HSService.this.foreground = false;
                HSService.this.stopSelf();
            }
        }
    };
    private static HSPolling notifCountPoller = null;

    private String getAppName() {
        ApplicationInfo ai;
        PackageManager pm = this.getPackageManager();
        try {
            ai = pm.getApplicationInfo(this.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            ai = null;
        }
        String applicationName = ai != null ? pm.getApplicationLabel(ai) : "(unknown)";
        return applicationName;
    }

    private boolean isAppOnForeground() {
        if (Build.VERSION.SDK_INT >= 14) {
            if (this.hsLifecycleCallbacks == null) {
                this.hsLifecycleCallbacks = HSLifecycleCallbacks.getInstance();
            }
            HSService hSService = this;
            return hSService.hsLifecycleCallbacks.isForeground();
        }
        ActivityManager activityManager = (ActivityManager)this.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return false;
        }
        String packageName = this.getPackageName();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.importance != 100 || !appProcess.processName.equals(packageName)) continue;
            return true;
        }
        return false;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        if (this.data == null) {
            this.data = new HSApiData((Context)this);
        }
        if (this.foreground == null) {
            this.foreground = true;
        }
        if (notifCountPoller == null) {
            notifCountPoller = new HSPolling(this.getCountHandler, 5, true, (Context)this);
            notifCountPoller.startRepeatingTask();
        }
        return 2;
    }

    public IBinder onBind(Intent intent) {
        return this.hsBinder;
    }

    public void onDestroy() {
        if (notifCountPoller != null) {
            notifCountPoller.stopRepeatingTask();
            notifCountPoller = null;
        }
        super.onDestroy();
    }

    public static void resetInterval() {
        if (notifCountPoller != null) {
            notifCountPoller.resetInterval();
        }
    }

    public static void stopPolling() {
        if (notifCountPoller != null) {
            notifCountPoller.stopRepeatingTask();
        }
    }

    public class HSBinder
    extends Binder {
        HSService getService() {
            return HSService.this;
        }
    }
}

